/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table.filter;

import com.android.ide.common.resources.Locale;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.filter.StringResourceTableRowFilter;
import com.android.tools.idea.rendering.FlagManager;
import javax.swing.Icon;
import javax.swing.RowFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0006\b\u0001\u0012\u00020\u000e0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/editors/strings/table/filter/NeedsTranslationForLocaleRowFilter;", "Lcom/android/tools/idea/editors/strings/table/filter/StringResourceTableRowFilter;", "locale", "Lcom/android/ide/common/resources/Locale;", "(Lcom/android/ide/common/resources/Locale;)V", "getDescription", "", "getIcon", "Ljavax/swing/Icon;", "include", "", "entry", "Ljavax/swing/RowFilter$Entry;", "Lcom/android/tools/idea/editors/strings/table/StringResourceTableModel;", "", "intellij.android.core"})
public final class NeedsTranslationForLocaleRowFilter
extends StringResourceTableRowFilter {
    @NotNull
    private final Locale locale;

    public NeedsTranslationForLocaleRowFilter(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.locale = locale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean include(@NotNull RowFilter.Entry<? extends StringResourceTableModel, ? extends Integer> entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        Integer n = entry.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"entry.identifier");
        StringResource stringResource = entry.getModel().getStringResourceAt(((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)stringResource, (String)"entry.model.getStringResourceAt(entry.identifier)");
        StringResource resource = stringResource;
        if (!resource.isTranslatable()) return false;
        String string = resource.getTranslationAsString(this.locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resource.getTranslationAsString(locale)");
        if (((CharSequence)string).length() != 0) return false;
        return true;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Show Keys Needing a Translation for " + Locale.getLocaleLabel((Locale)this.locale, (boolean)false);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon2 = FlagManager.getFlagImage(this.locale);
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getFlagImage(locale)");
        return icon2;
    }
}

