/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.ide.common.resources.Locale;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.VirtualFiles;
import com.android.tools.idea.editors.strings.model.StringResourceKey;
import com.android.tools.idea.editors.strings.model.StringResourceRepository;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class StringResourceTableModel
extends AbstractTableModel {
    public static final int KEY_COLUMN = 0;
    public static final int RESOURCE_FOLDER_COLUMN = 1;
    public static final int UNTRANSLATABLE_COLUMN = 2;
    public static final int DEFAULT_VALUE_COLUMN = 3;
    public static final int FIXED_COLUMN_COUNT = 4;
    private final StringResourceRepository myRepository;
    @Nullable
    private final Project myProject;
    @Nullable
    private final StringResourceData myData;
    private List<StringResourceKey> myKeys;
    private List<Locale> myLocales;

    public StringResourceTableModel(@NotNull StringResourceRepository repository2, @NotNull Project project) {
        this(repository2, project, StringResourceData.create(project, repository2));
    }

    StringResourceTableModel() {
        this(StringResourceRepository.empty(), null, null);
    }

    @VisibleForTesting
    StringResourceTableModel(@Nullable StringResourceRepository repository2, @Nullable Project project, @Nullable StringResourceData data) {
        this.myRepository = repository2;
        this.myProject = project;
        this.myData = data;
        this.myKeys = data == null ? Collections.emptyList() : data.getKeys();
        this.myLocales = data == null ? Collections.emptyList() : data.getLocaleList();
    }

    @NotNull
    public StringResourceRepository getRepository() {
        return this.myRepository;
    }

    @Nullable
    public StringResourceData getData() {
        return this.myData;
    }

    @NotNull
    public StringResource getStringResourceAt(int row2) {
        return this.myData.getStringResource(this.getKey(row2));
    }

    @NotNull
    public List<StringResourceKey> getKeys() {
        return this.myKeys;
    }

    @NotNull
    public StringResourceKey getKey(int row2) {
        return this.myKeys.get(row2);
    }

    @Nullable
    public Locale getLocale(int column2) {
        assert (0 <= column2 && column2 < this.getColumnCount()) : column2;
        return column2 < 4 ? null : this.myLocales.get(column2 - 4);
    }

    @Override
    public int getRowCount() {
        return this.myKeys.size();
    }

    @Override
    public int getColumnCount() {
        return 4 + this.myLocales.size();
    }

    @Override
    public void setValueAt(@NotNull Object value2, final int row2, final int column2) {
        assert (this.myData != null && this.myKeys != null);
        switch (column2) {
            case 0: {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myData.setKeyName(this.getKey(row2), (String)value2);
                    this.myKeys = this.myData.getKeys();
                    this.myLocales = this.myData.getLocaleList();
                    this.fireTableRowsUpdated(0, this.myKeys.size() - 1);
                });
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Boolean doNotTranslate = (Boolean)value2;
                if (!this.myData.setTranslatable(this.getKey(row2), doNotTranslate == false)) break;
                this.fireTableCellUpdated(row2, column2);
                break;
            }
            case 3: {
                Futures.addCallback(this.getStringResourceAt(row2).setDefaultValue((String)value2), (FutureCallback)new FutureCallback<Boolean>(){

                    public void onSuccess(@Nullable Boolean changed) {
                        if (changed != null && changed.booleanValue()) {
                            StringResourceTableModel.this.fireTableCellUpdated(row2, column2);
                        }
                    }

                    public void onFailure(@NotNull Throwable t) {
                    }
                }, (Executor)SameThreadExecutor.INSTANCE);
                break;
            }
            default: {
                Locale locale = this.getLocale(column2);
                assert (locale != null);
                Futures.addCallback(this.getStringResourceAt(row2).putTranslation(locale, (String)value2), (FutureCallback)new FutureCallback<Boolean>(){

                    public void onSuccess(@Nullable Boolean changed) {
                        if (changed != null && changed.booleanValue()) {
                            StringResourceTableModel.this.fireTableCellUpdated(row2, column2);
                        }
                    }

                    public void onFailure(@NotNull Throwable t) {
                    }
                }, (Executor)SameThreadExecutor.INSTANCE);
            }
        }
    }

    @Override
    @NotNull
    public Object getValueAt(int row2, int column2) {
        switch (column2) {
            case 0: {
                return this.getKey(row2).getName();
            }
            case 1: {
                return this.computeResourceFolderString(this.getKey(row2));
            }
            case 2: {
                return !this.getStringResourceAt(row2).isTranslatable();
            }
            case 3: {
                return this.getStringResourceAt(row2).getDefaultValueAsString();
            }
        }
        Locale locale = this.getLocale(column2);
        assert (locale != null);
        return this.getStringResourceAt(row2).getTranslationAsString(locale);
    }

    @Override
    @NotNull
    public String getColumnName(int column2) {
        String columnName;
        switch (column2) {
            case 0: {
                return "Key";
            }
            case 1: {
                return "Resource Folder";
            }
            case 2: {
                return "Untranslatable";
            }
            case 3: {
                return "Default Value";
            }
        }
        Locale locale = this.getLocale(column2);
        try {
            columnName = Locale.getLocaleLabel((Locale)locale, (boolean)false);
        }
        catch (AssertionError e) {
            columnName = locale.toString();
            Logger.getInstance(StringResourceTableModel.class).warn("Failed to get label for locale '" + columnName + "'", (Throwable)((Object)e));
        }
        return columnName;
    }

    @Override
    public Class<?> getColumnClass(int column2) {
        return column2 == 2 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int row2, int column2) {
        switch (column2) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return !this.getStringResourceAt(row2).getDefaultValueAsString().contains("\n");
            }
        }
        Locale locale = this.getLocale(column2);
        assert (locale != null);
        return !this.getStringResourceAt(row2).getTranslationAsString(locale).contains("\n");
    }

    @Nullable
    public String getCellProblem(int row2, int column2) {
        switch (column2) {
            case 0: {
                return this.myData.validateKey(this.getKey(row2));
            }
            case 1: 
            case 2: {
                return null;
            }
            case 3: {
                return this.getStringResourceAt(row2).validateDefaultValue();
            }
        }
        Locale locale = this.getLocale(column2);
        assert (locale != null);
        return this.getStringResourceAt(row2).validateTranslation(locale);
    }

    @NotNull
    private String computeResourceFolderString(StringResourceKey key) {
        assert (this.myProject != null);
        return key.getDirectory() == null ? "" : VirtualFiles.toString(key.getDirectory(), this.myProject);
    }

    public static boolean isStringValueColumn(int index2) {
        return index2 >= 3;
    }
}

