/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.GridPasteUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001c0\u001cJ\u0014\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001c0\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/editors/strings/table/Parser;", "", "str", "", "(Ljava/lang/String;)V", "alternativeInterpretations", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "currentGrid", "", "currentRow", "fillerSellCount", "", "insideQuotedSegment", "", "maxQuotedDelimiterCount", "offset", "openingQuoteAccepted", "quotedDelimiterCount", "quotedDelimiterCountAtSegmentStart", "segmentStart", "getStr", "()Ljava/lang/String;", "addCell", "", "addRow", "appendColumn", "nextAlternative", "parse", "", "parseOnce", "processDelimiter", "delimiter", "", "intellij.android.core"})
final class Parser {
    @NotNull
    private final String str;
    @NotNull
    private final List<List<String>> currentGrid;
    @NotNull
    private List<String> currentRow;
    private boolean insideQuotedSegment;
    private boolean openingQuoteAccepted;
    private int segmentStart;
    private int offset;
    private int fillerSellCount;
    private int quotedDelimiterCount;
    private int quotedDelimiterCountAtSegmentStart;
    private int maxQuotedDelimiterCount;
    @NotNull
    private IntArrayList alternativeInterpretations;

    public Parser(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.str = str;
        this.currentGrid = new ArrayList();
        this.currentRow = new ArrayList();
        this.openingQuoteAccepted = true;
        this.alternativeInterpretations = new IntArrayList();
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    @NotNull
    public final List<List<String>> parse() {
        List bestGrid = this.currentGrid;
        int bestFillerSellCount = Integer.MAX_VALUE;
        for (int i = 0; i < 1000; ++i) {
            this.parseOnce();
            if (this.fillerSellCount == 0) {
                return this.currentGrid;
            }
            if (this.fillerSellCount < bestFillerSellCount) {
                bestFillerSellCount = this.fillerSellCount;
                bestGrid = new ArrayList(this.currentGrid);
            }
            this.maxQuotedDelimiterCount = RangesKt.coerceAtLeast((int)this.maxQuotedDelimiterCount, (int)this.quotedDelimiterCount);
            if (!this.nextAlternative()) break;
        }
        return bestGrid;
    }

    private final List<List<String>> parseOnce() {
        this.currentGrid.clear();
        this.currentRow = new ArrayList();
        this.insideQuotedSegment = false;
        this.openingQuoteAccepted = true;
        this.segmentStart = 0;
        this.offset = 0;
        this.fillerSellCount = 0;
        this.quotedDelimiterCount = 0;
        this.quotedDelimiterCountAtSegmentStart = 0;
        while (this.offset < this.str.length()) {
            char c = this.str.charAt(this.offset);
            if (c == '\"') {
                if (this.insideQuotedSegment) {
                    this.insideQuotedSegment = false;
                    this.openingQuoteAccepted = true;
                } else if (this.openingQuoteAccepted) {
                    this.insideQuotedSegment = true;
                }
            } else if (c == '\t' ? true : c == '\n') {
                this.processDelimiter(c);
            } else {
                this.openingQuoteAccepted = false;
            }
            int n = this.offset;
            this.offset = n + 1;
        }
        if (this.offset > this.segmentStart) {
            this.addRow();
        }
        return this.currentGrid;
    }

    private final void processDelimiter(char delimiter) {
        int n;
        boolean wasInsideQuotedSegment = this.insideQuotedSegment;
        if (!this.insideQuotedSegment || this.alternativeInterpretations.contains(this.quotedDelimiterCount)) {
            if (this.insideQuotedSegment && (this.offset - this.segmentStart < 2 || this.str.charAt(this.offset - 1) != '\"')) {
                this.offset = this.segmentStart - 1;
                this.openingQuoteAccepted = false;
                this.quotedDelimiterCount = this.quotedDelimiterCountAtSegmentStart;
            } else {
                n = delimiter;
                if (n == 9) {
                    this.addCell();
                } else if (n == 10) {
                    this.addRow();
                    this.currentRow = new ArrayList();
                }
                this.segmentStart = this.offset + 1;
                this.openingQuoteAccepted = true;
                this.quotedDelimiterCountAtSegmentStart = this.quotedDelimiterCount;
            }
            this.insideQuotedSegment = false;
        }
        if (wasInsideQuotedSegment) {
            n = this.quotedDelimiterCount;
            this.quotedDelimiterCount = n + 1;
        }
    }

    private final void addRow() {
        this.addCell();
        if (!((Collection)this.currentRow).isEmpty()) {
            if (!((Collection)this.currentGrid).isEmpty() && this.currentRow.size() < ((List)CollectionsKt.first(this.currentGrid)).size()) {
                this.fillerSellCount += ((List)CollectionsKt.first(this.currentGrid)).size() - this.currentRow.size();
                GridPasteUtils.access$expandToSize(this.currentRow, ((List)CollectionsKt.first(this.currentGrid)).size(), "");
            }
            this.currentGrid.add(this.currentRow);
        }
    }

    private final void addCell() {
        String string = this.str.substring(this.segmentStart, this.offset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String segment = string;
        this.currentRow.add(GridPasteUtils.access$unquote(segment));
        if (!((Collection)this.currentGrid).isEmpty() && this.currentRow.size() > ((List)CollectionsKt.first(this.currentGrid)).size()) {
            this.appendColumn();
            this.fillerSellCount += this.currentGrid.size();
        }
    }

    private final void appendColumn() {
        for (List<String> row2 : this.currentGrid) {
            row2.add("");
        }
    }

    private final boolean nextAlternative() {
        IntArrayList $this$nextAlternative_u24lambda_u240 = this.alternativeInterpretations;
        boolean bl = false;
        int i = $this$nextAlternative_u24lambda_u240.size();
        while (--i >= 0) {
            int a = GridPasteUtils.access$incrementAndGet($this$nextAlternative_u24lambda_u240, i);
            int j = i;
            while (++a <= this.maxQuotedDelimiterCount) {
                if (++j >= $this$nextAlternative_u24lambda_u240.size() || $this$nextAlternative_u24lambda_u240.getInt(j) > a) {
                    return true;
                }
                $this$nextAlternative_u24lambda_u240.set(j, a);
            }
            int n = $this$nextAlternative_u24lambda_u240.size();
            for (int k = i; k < n; ++k) {
                $this$nextAlternative_u24lambda_u240.set(k, 0);
            }
        }
        if (this.maxQuotedDelimiterCount >= 0 && $this$nextAlternative_u24lambda_u240.size() >= this.maxQuotedDelimiterCount) {
            return false;
        }
        int n = $this$nextAlternative_u24lambda_u240.size();
        for (int k = 0; k < n; ++k) {
            $this$nextAlternative_u24lambda_u240.set(k, k);
        }
        $this$nextAlternative_u24lambda_u240.add($this$nextAlternative_u24lambda_u240.size());
        return true;
    }
}

