/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFilesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class StringResourceEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String ID = "string-resource-editor";

    public static boolean canViewTranslations(@NotNull Project project, @NotNull VirtualFile file2) {
        if (ResourceFilesUtil.getFolderType(file2) != ResourceFolderType.VALUES) {
            return false;
        }
        Module m = ProjectFileIndex.getInstance((Project)project).getModuleForFile(file2);
        if (m == null || AndroidFacet.getInstance((Module)m) == null) {
            return false;
        }
        String name2 = IdeResourcesUtil.getDefaultResourceFileName(ResourceType.STRING);
        assert (name2 != null);
        if (file2.getName().endsWith(name2)) {
            return true;
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringResourceEditorProvider.fileContainsStringResource(project, file2);
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> StringResourceEditorProvider.fileContainsStringResource(project, file2));
    }

    public static boolean fileContainsStringResource(Project project, VirtualFile virtualFile) {
        XmlTag tag;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile instanceof XmlFile && (tag = ((XmlFile)psiFile).getRootTag()) != null && tag.getName().equals("resources")) {
            XmlTag[] subTags = tag.getSubTags();
            return Arrays.stream(subTags).anyMatch(it -> it.getName().equals("string"));
        }
        return false;
    }

    public static void openEditor(@NotNull Module module2) {
        StringsVirtualFile vf = StringsVirtualFile.getStringsVirtualFile(module2);
        if (vf != null) {
            ApplicationManager.getApplication().invokeLater(() -> StringResourceEditorProvider.lambda$openEditor$2(module2, (VirtualFile)vf));
        }
    }

    public static void openEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        StringsVirtualFile stringsFile = StringsVirtualFile.getInstance(project, file2);
        assert (stringsFile != null);
        ApplicationManager.getApplication().invokeLater(() -> StringResourceEditorProvider.lambda$openEditor$3(project, (VirtualFile)stringsFile));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        return file2 instanceof StringsVirtualFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        return new StringResourceEditor((StringsVirtualFile)file2);
    }

    @NotNull
    public String getEditorTypeId() {
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }

    private static /* synthetic */ void lambda$openEditor$3(Project project, VirtualFile stringsFile) {
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, stringsFile);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
    }

    private static /* synthetic */ void lambda$openEditor$2(Module module2, VirtualFile vf) {
        Project project = module2.getProject();
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, vf);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
    }
}

