/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.model.StringResourceKey;
import com.android.tools.idea.editors.strings.model.StringResourceRepository;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StringResourceWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceData {
    private static final int MAX_LOCALE_LABEL_COUNT = 3;
    private final LinkedHashMap<StringResourceKey, StringResource> myKeyToResourceMap;
    private final Project myProject;
    private final StringResourceRepository myRepository;
    private final StringResourceWriter myStringResourceWriter = StringResourceWriter.INSTANCE;

    private StringResourceData(@NotNull Project project, @NotNull StringResourceRepository repository2) {
        this.myKeyToResourceMap = new LinkedHashMap();
        this.myProject = project;
        this.myRepository = repository2;
    }

    @NotNull
    public static StringResourceData create(@NotNull Project project, @NotNull StringResourceRepository repository2) {
        StringResourceData data = new StringResourceData(project, repository2);
        repository2.getKeys().forEach(key -> data.myKeyToResourceMap.put((StringResourceKey)key, new StringResource((StringResourceKey)key, data)));
        return data;
    }

    @NotNull
    final Project getProject() {
        return this.myProject;
    }

    @NotNull
    final StringResourceRepository getRepository() {
        return this.myRepository;
    }

    public void setKeyName(@NotNull StringResourceKey key, @NotNull String name2) {
        if (key.getName().equals(name2)) {
            return;
        }
        boolean mapContainsName = this.myKeyToResourceMap.keySet().stream().map(k -> k.getName()).anyMatch(n -> n.equals(name2));
        if (mapContainsName) {
            return;
        }
        ResourceItem value2 = this.getStringResource(key).getDefaultValueAsResourceItem();
        if (value2 == null) {
            return;
        }
        XmlTag stringElement = IdeResourcesUtil.getItemTag(this.myProject, value2);
        assert (stringElement != null);
        XmlAttribute nameAttribute2 = stringElement.getAttribute("name");
        assert (nameAttribute2 != null);
        XmlAttributeValue nameAttributeValue = nameAttribute2.getValueElement();
        assert (nameAttributeValue != null);
        new RenameProcessor(this.myProject, (PsiElement)nameAttributeValue, name2, false, false).run();
        this.myKeyToResourceMap.remove(key);
        key = new StringResourceKey(name2, key.getDirectory());
        this.myKeyToResourceMap.put(key, new StringResource(key, this));
    }

    public boolean setTranslatable(@NotNull StringResourceKey key, boolean translatable) {
        StringResource stringResource = this.getStringResource(key);
        ResourceItem item2 = stringResource.getDefaultValueAsResourceItem();
        if (item2 != null) {
            String translatableAsString;
            if (translatable) {
                translatableAsString = null;
                stringResource.setTranslatable(true);
            } else {
                translatableAsString = "false";
                stringResource.setTranslatable(false);
            }
            return this.myStringResourceWriter.setAttribute(this.myProject, "translatable", translatableAsString, item2);
        }
        return false;
    }

    @Nullable
    public String validateKey(@NotNull StringResourceKey key) {
        if (!this.myKeyToResourceMap.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        StringResource stringResource = this.getStringResource(key);
        if (!stringResource.isTranslatable()) {
            Collection<Locale> localesWithTranslation = stringResource.getTranslatedLocales();
            if (!localesWithTranslation.isEmpty()) {
                return String.format("Key '%1$s' is marked as non translatable, but is translated in %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()), StringResourceData.summarizeLocales(localesWithTranslation));
            }
        } else {
            if (stringResource.getDefaultValueAsResourceItem() == null) {
                return "Key '" + key.getName() + "' missing default value";
            }
            Collection<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return String.format("Key '%1$s' has translations missing for %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)missingTranslations.size()), StringResourceData.summarizeLocales(missingTranslations));
            }
        }
        return null;
    }

    @NotNull
    @VisibleForTesting
    Collection<Locale> getMissingTranslations(@NotNull StringResourceKey key) {
        HashSet missingTranslations = Sets.newHashSet();
        for (Locale locale : this.getLocaleSet()) {
            StringResource stringResource = this.getStringResource(key);
            if (!stringResource.isTranslationMissing(locale)) continue;
            missingTranslations.add(locale);
        }
        return missingTranslations;
    }

    @VisibleForTesting
    @NotNull
    static String summarizeLocales(@NotNull Collection<Locale> locales) {
        if (locales.isEmpty()) {
            return "";
        }
        int size = locales.size();
        if (size == 1) {
            return StringResourceData.getLabel((Locale)Iterables.getFirst(locales, null));
        }
        List<Locale> sorted2 = StringResourceData.getLowest(locales);
        if (size <= 3) {
            return StringResourceData.getLabels(sorted2.subList(0, size - 1)) + " and " + StringResourceData.getLabel(sorted2.get(size - 1));
        }
        return StringResourceData.getLabels(sorted2) + " and " + (size - 3) + " more";
    }

    @NotNull
    private static List<Locale> getLowest(@NotNull Collection<Locale> locales) {
        return locales.stream().limit(3L).sorted(Comparator.comparing(StringResourceData::getLabel)).collect(Collectors.toList());
    }

    private static String getLabels(Collection<Locale> locales) {
        return locales.stream().map(StringResourceData::getLabel).collect(Collectors.joining(", "));
    }

    private static String getLabel(@Nullable Locale locale) {
        return locale == null ? "" : Locale.getLocaleLabel((Locale)locale, (boolean)false);
    }

    public boolean containsKey(@NotNull StringResourceKey key) {
        return this.myKeyToResourceMap.containsKey(key);
    }

    @NotNull
    public StringResource getStringResource(@NotNull StringResourceKey key) {
        StringResource resource = this.myKeyToResourceMap.get(key);
        if (resource == null) {
            throw new IllegalArgumentException(key.toString());
        }
        return resource;
    }

    @NotNull
    public Collection<StringResource> getResources() {
        return this.myKeyToResourceMap.values();
    }

    @NotNull
    public List<StringResourceKey> getKeys() {
        return new ArrayList<StringResourceKey>(this.myKeyToResourceMap.keySet());
    }

    @NotNull
    public List<Locale> getLocaleList() {
        return this.getTranslatedLocaleStream().distinct().sorted(Locale.LANGUAGE_NAME_COMPARATOR).collect(Collectors.toList());
    }

    @NotNull
    public Set<Locale> getLocaleSet() {
        return this.getTranslatedLocaleStream().collect(Collectors.toSet());
    }

    @NotNull
    private Stream<Locale> getTranslatedLocaleStream() {
        return this.myKeyToResourceMap.values().stream().flatMap(resource -> resource.getTranslatedLocales().stream());
    }

    @Nullable
    XmlFile getDefaultLocaleXml(@NotNull Locale locale) {
        XmlFile lastFile = null;
        for (StringResource stringResource : this.myKeyToResourceMap.values()) {
            PsiFile file2;
            XmlTag tag;
            ResourceItem resourceItem = stringResource.getTranslationAsResourceItem(locale);
            if (resourceItem == null || (tag = IdeResourcesUtil.getItemTag(this.myProject, resourceItem)) == null || !((file2 = tag.getContainingFile()) instanceof XmlFile)) continue;
            if (lastFile == null) {
                lastFile = (XmlFile)file2;
                continue;
            }
            if (lastFile == file2) continue;
            return null;
        }
        return lastFile;
    }
}

