/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.escape.xml.CharacterDataEscaper;
import com.android.ide.common.util.PathString;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.model.StringResourceKey;
import com.android.tools.idea.editors.strings.model.StringResourceRepository;
import com.android.tools.idea.res.DynamicValueResourceItem;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.StringResourceWriter;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResource {
    private static final Logger LOGGER = Logger.getInstance(StringResource.class);
    @NotNull
    private final StringResourceKey myKey;
    @NotNull
    private final StringResourceData myData;
    private boolean myTranslatable;
    @Nullable
    private String myTentativeDefaultValue = null;
    @Nullable
    private ResourceItemEntry myDefaultValue;
    @NotNull
    private final Map<Locale, ResourceItemEntry> myLocaleToTranslationMap;
    private final StringResourceWriter myStringResourceWriter = StringResourceWriter.INSTANCE;

    public StringResource(@NotNull StringResourceKey key, @NotNull StringResourceData data) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myKey = key;
        this.myData = data;
        boolean translatable = true;
        ResourceItemEntry defaultValue = null;
        HashMap<Locale, ResourceItemEntry> localeToTranslationMap = new HashMap<Locale, ResourceItemEntry>();
        for (ResourceItem item2 : data.getRepository().getItems(key)) {
            XmlTag tag;
            if (!(item2 instanceof PsiResourceItem) && !(item2 instanceof DynamicValueResourceItem)) {
                LOGGER.warn(item2 + " has an unexpected class " + item2.getClass().getName());
            }
            if ((tag = IdeResourcesUtil.getItemTag(data.getProject(), item2)) != null && "false".equals(tag.getAttributeValue("translatable"))) {
                translatable = false;
            }
            LocaleQualifier qualifier = item2.getConfiguration().getLocaleQualifier();
            String tagText = StringResource.getTextOfTag(tag);
            if (qualifier == null) {
                defaultValue = new ResourceItemEntry(item2, tagText);
                continue;
            }
            localeToTranslationMap.put(Locale.create((LocaleQualifier)qualifier), new ResourceItemEntry(item2, tagText));
        }
        this.myTranslatable = translatable;
        this.myDefaultValue = defaultValue;
        this.myLocaleToTranslationMap = localeToTranslationMap;
    }

    @NotNull
    String getTagText(@Nullable Locale locale) {
        ResourceItemEntry resourceItemEntry = this.myDefaultValue;
        if (locale != null) {
            resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        }
        return resourceItemEntry == null ? "" : resourceItemEntry.myTagText;
    }

    @Nullable
    ResourceItem getDefaultValueAsResourceItem() {
        return this.myDefaultValue == null ? null : this.myDefaultValue.myResourceItem;
    }

    @NotNull
    public String getDefaultValueAsString() {
        return this.myDefaultValue == null ? "" : this.myDefaultValue.myString;
    }

    @UiThread
    @NotNull
    public ListenableFuture<Boolean> setDefaultValue(@NotNull String defaultValue) {
        if (this.myDefaultValue == null) {
            if (defaultValue.equals(this.myTentativeDefaultValue)) {
                return Futures.immediateFuture((Object)false);
            }
            this.myTentativeDefaultValue = defaultValue;
            ListenableFuture<ResourceItem> futureItem = this.createDefaultValue(defaultValue);
            return Futures.transform(futureItem, item2 -> {
                this.myTentativeDefaultValue = null;
                if (item2 == null) {
                    return false;
                }
                this.myDefaultValue = new ResourceItemEntry((ResourceItem)item2, StringResource.getTextOfTag(IdeResourcesUtil.getItemTag(this.myData.getProject(), item2)));
                return true;
            }, (Executor)SameThreadExecutor.INSTANCE);
        }
        if (this.myDefaultValue.myString.equals(defaultValue)) {
            return Futures.immediateFuture((Object)false);
        }
        boolean changed = this.myStringResourceWriter.setItemText(this.myData.getProject(), this.myDefaultValue.myResourceItem, defaultValue);
        if (!changed) {
            return Futures.immediateFuture((Object)false);
        }
        if (defaultValue.isEmpty()) {
            this.myDefaultValue = null;
            return Futures.immediateFuture((Object)true);
        }
        ResourceItem item3 = this.myData.getRepository().getDefaultValue(this.myKey);
        assert (item3 != null);
        this.myDefaultValue = new ResourceItemEntry(item3, StringResource.getTextOfTag(IdeResourcesUtil.getItemTag(this.myData.getProject(), item3)));
        return Futures.immediateFuture((Object)true);
    }

    @NotNull
    private ListenableFuture<ResourceItem> createDefaultValue(@NotNull String value2) {
        if (value2.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        Project project = this.myData.getProject();
        StringResourceWriter.INSTANCE.addDefault(project, this.myKey, value2, this.myTranslatable);
        SettableFuture futureItem = SettableFuture.create();
        StringResourceRepository stringRepository = this.myData.getRepository();
        stringRepository.invokeAfterPendingUpdatesFinish(this.myKey, () -> futureItem.set((Object)stringRepository.getDefaultValue(this.myKey)));
        return futureItem;
    }

    @Nullable
    public String validateDefaultValue() {
        if (this.myDefaultValue == null) {
            return "Key \"" + this.myKey.getName() + "\" is missing its default value";
        }
        if (!this.myDefaultValue.myStringValid) {
            return "Invalid XML";
        }
        return null;
    }

    public boolean isTranslatable() {
        return this.myTranslatable;
    }

    public void setTranslatable(boolean translatable) {
        this.myTranslatable = translatable;
    }

    @Nullable
    ResourceItem getTranslationAsResourceItem(@NotNull Locale locale) {
        ResourceItemEntry resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        return resourceItemEntry == null ? null : resourceItemEntry.myResourceItem;
    }

    @NotNull
    public String getTranslationAsString(@NotNull Locale locale) {
        ResourceItemEntry resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        return resourceItemEntry == null ? "" : resourceItemEntry.myString;
    }

    @NotNull
    public ListenableFuture<Boolean> putTranslation(@NotNull Locale locale, @NotNull String translation) {
        if (this.getTranslationAsResourceItem(locale) == null) {
            List<StringResourceKey> keys = this.myData.getKeys();
            int index2 = keys.indexOf(this.myKey);
            StringResourceKey anchor = null;
            if (index2 != -1) {
                StringResourceKey next;
                StringResource nextResource;
                while (++index2 < keys.size() && this.hasSameDefaultValueFile(nextResource = this.myData.getStringResource(next = keys.get(index2)))) {
                    if (nextResource.getTranslationAsResourceItem(locale) == null) continue;
                    anchor = next;
                    break;
                }
            }
            return Futures.transform(this.createTranslationBefore(locale, translation, anchor), item2 -> {
                if (item2 == null) {
                    return false;
                }
                this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry((ResourceItem)item2, StringResource.getTextOfTag(IdeResourcesUtil.getItemTag(this.myData.getProject(), item2))));
                return true;
            }, (Executor)SameThreadExecutor.INSTANCE);
        }
        if (this.getTranslationAsString(locale).equals(translation)) {
            return Futures.immediateFuture((Object)false);
        }
        ResourceItem item3 = this.getTranslationAsResourceItem(locale);
        assert (item3 != null);
        boolean changed = this.myStringResourceWriter.setItemText(this.myData.getProject(), item3, translation);
        if (!changed) {
            return Futures.immediateFuture((Object)false);
        }
        if (translation.isEmpty()) {
            this.myLocaleToTranslationMap.remove(locale);
            return Futures.immediateFuture((Object)true);
        }
        item3 = this.myData.getRepository().getTranslation(this.myKey, locale);
        assert (item3 != null);
        this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry(item3, StringResource.getTextOfTag(IdeResourcesUtil.getItemTag(this.myData.getProject(), item3))));
        return Futures.immediateFuture((Object)true);
    }

    @NotNull
    private ListenableFuture<ResourceItem> createTranslationBefore(@NotNull Locale locale, @NotNull String value2, @Nullable StringResourceKey anchor) {
        if (value2.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        VirtualFile resourceDirectory = this.myKey.getDirectory();
        if (resourceDirectory == null) {
            return Futures.immediateFuture(null);
        }
        Project project = this.myData.getProject();
        XmlFile file2 = this.myData.getDefaultLocaleXml(locale);
        if (file2 != null) {
            StringResourceWriter.INSTANCE.addTranslationToFile(project, file2, this.myKey, value2, anchor);
        } else {
            StringResourceWriter.INSTANCE.addTranslation(project, this.myKey, value2, locale, this.getDefaultValueFileName(), anchor);
        }
        SettableFuture futureItem = SettableFuture.create();
        StringResourceRepository stringRepository = this.myData.getRepository();
        stringRepository.invokeAfterPendingUpdatesFinish(this.myKey, () -> futureItem.set((Object)stringRepository.getTranslation(this.myKey, locale)));
        return futureItem;
    }

    @Nullable
    public String validateTranslation(@NotNull Locale locale) {
        ResourceItemEntry entry = this.myLocaleToTranslationMap.get(locale);
        if (entry != null && !entry.myStringValid) {
            return "Invalid XML";
        }
        if (this.myTranslatable && this.isTranslationMissing(locale)) {
            return "Key \"" + this.myKey.getName() + "\" is missing its " + Locale.getLocaleLabel((Locale)locale, (boolean)false) + " translation";
        }
        if (!this.myTranslatable && !this.isTranslationMissing(locale)) {
            return "Key \"" + this.myKey.getName() + "\" is untranslatable and should not be translated to " + Locale.getLocaleLabel((Locale)locale, (boolean)false);
        }
        return null;
    }

    @NotNull
    Collection<Locale> getTranslatedLocales() {
        return this.myLocaleToTranslationMap.keySet();
    }

    boolean isTranslationMissing(@NotNull Locale locale) {
        ResourceItemEntry item2 = this.myLocaleToTranslationMap.get(locale);
        if (StringResource.isTranslationMissing(item2) && locale.hasRegion()) {
            String language = locale.qualifier.getLanguage();
            assert (language != null);
            locale = Locale.create((String)language);
            item2 = this.myLocaleToTranslationMap.get(locale);
        }
        return StringResource.isTranslationMissing(item2);
    }

    private boolean hasSameDefaultValueFile(StringResource other) {
        return Objects.equals(this.getDefaultValueFileName(), other.getDefaultValueFileName());
    }

    @NotNull
    private String getDefaultValueFileName() {
        PathString pathString;
        ResourceItem resourceItem = this.getDefaultValueAsResourceItem();
        if (resourceItem != null && (pathString = resourceItem.getOriginalSource()) != null) {
            String fileName = pathString.getFileName();
            assert (!fileName.isEmpty());
            return fileName;
        }
        return "strings.xml";
    }

    private static boolean isTranslationMissing(@Nullable ResourceItemEntry item2) {
        return item2 == null || item2.myString.isEmpty();
    }

    @NotNull
    private static String getTextOfTag(@Nullable XmlTag tag) {
        return tag == null ? "" : tag.getText();
    }

    private static final class ResourceItemEntry {
        @NotNull
        private final ResourceItem myResourceItem;
        @NotNull
        private final String myTagText;
        @NotNull
        private final String myString;
        private final boolean myStringValid;

        private ResourceItemEntry(@NotNull ResourceItem resourceItem, @NotNull String tagText) {
            this.myResourceItem = resourceItem;
            this.myTagText = tagText;
            ResourceValue value2 = resourceItem.getResourceValue();
            if (value2 == null) {
                this.myString = "";
                this.myStringValid = true;
                return;
            }
            String string = value2.getRawXmlValue();
            assert (string != null);
            boolean stringValid = true;
            try {
                string = CharacterDataEscaper.unescape((String)string);
            }
            catch (IllegalArgumentException exception) {
                stringValid = false;
            }
            this.myString = string;
            this.myStringValid = stringValid;
        }
    }
}

