/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.Locale;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.res.StringResourceWriter;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import java.awt.Point;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;

final class RemoveLocaleMouseListener
implements FrozenColumnTableListener {
    private final StringResourceViewPanel myPanel;
    private final StringResourceWriter myStringResourceWriter = StringResourceWriter.INSTANCE;

    RemoveLocaleMouseListener(@NotNull StringResourceViewPanel panel2) {
        this.myPanel = panel2;
    }

    @Override
    public void headerPopupTriggered(@NotNull FrozenColumnTableEvent event2) {
        Locale locale = ((StringResourceTableModel)event2.getSource().getModel()).getLocale(event2.getModelColumnIndex());
        if (locale == null) {
            return;
        }
        JBMenuItem item2 = new JBMenuItem("Remove Locale");
        item2.setName("removeLocaleMenuItem");
        item2.addActionListener(e -> {
            this.myStringResourceWriter.removeLocale(locale, this.myPanel.getFacet(), this);
            this.myPanel.reloadData();
        });
        JBPopupMenu menu = new JBPopupMenu();
        menu.add((JMenuItem)item2);
        Point point = event2.getPoint();
        menu.show(event2.getSubcomponent(), point.x, point.y);
    }
}

