/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.util.PathString;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.tools.adtui.workbench.WorkBenchLoadingPanel;
import com.android.tools.idea.editors.manifest.AnnotationColors;
import com.android.tools.idea.editors.manifest.InjectedBuildDotGradleFile;
import com.android.tools.idea.editors.manifest.ManifestFileWithMetadata;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.editors.manifest.ManifestXmlType;
import com.android.tools.idea.editors.manifest.ManifestXmlWithMetadata;
import com.android.tools.idea.editors.manifest.UnknownManifestFile;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.DependencyScopeType;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.StudioHtmlLinkManager;
import com.android.utils.FileUtils;
import com.android.utils.HtmlBuilder;
import com.android.utils.PositionXmlParser;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@UiThread
public class ManifestPanel
extends JPanel
implements TreeSelectionListener {
    private static final String SUGGESTION_MARKER = "Suggestion: ";
    private static final Pattern ADD_SUGGESTION_FORMAT = Pattern.compile(".*? 'tools:([\\w:]+)=\"([\\w:]+)\"' to \\<(\\w+)\\> element at (.+) to override\\.", 32);
    private static final Pattern FILE_POSITION_FORMAT = Pattern.compile("[^:]+:(\\d+):(\\d+)-[\\d:]+", 32);
    private static final Pattern NAV_FILE_PATTERN = Pattern.compile(".*/res/.*navigation(-[^/]*)?/[^/]*$");
    private static final File GRADLE_MODEL_MARKER_FILE = new File("build.gradle");
    private final AndroidFacet myFacet;
    private final Font myDefaultFont;
    private final Tree myTree;
    private final JEditorPane myDetails;
    private final WorkBenchLoadingPanel myLoadingPanel;
    private final JBSplitter mySplitter;
    private JPopupMenu myPopup;
    private JMenuItem myRemoveItem;
    private MergedManifestSnapshot myManifest;
    private boolean myManifestEditable;
    private final List<ManifestFileWithMetadata> myFiles = new ArrayList<ManifestFileWithMetadata>();
    private final List<ManifestFileWithMetadata> myOtherFiles = new ArrayList<ManifestFileWithMetadata>();
    private final StudioHtmlLinkManager myHtmlLinkManager = new StudioHtmlLinkManager();
    private VirtualFile myFile;
    private final Color myBackgroundColor;
    private Map<PathString, ExternalAndroidLibrary> myLibrariesByManifestDir;

    public ManifestPanel(@NotNull AndroidFacet facet2, @NotNull Disposable parent2) {
        this.myFacet = facet2;
        this.setLayout(new BorderLayout());
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        this.myBackgroundColor = scheme.getDefaultBackground();
        this.myDefaultFont = scheme.getFont(EditorFontType.PLAIN);
        this.myTree = new FileColorTree();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new SyntaxHighlightingCellRenderer()));
        TreeSelectionModel selectionModel = this.myTree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        selectionModel.addTreeSelectionListener(this);
        this.myDetails = this.createDetailsPane(facet2);
        this.addSpeedSearch();
        this.createPopupMenu();
        this.registerGotoAction();
        this.mySplitter = new JBSplitter(0.5f);
        this.mySplitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myTree));
        this.mySplitter.setSecondComponent((JComponent)new JBScrollPane((Component)this.myDetails));
        this.myLoadingPanel = new WorkBenchLoadingPanel((LayoutManager)new BorderLayout(), parent2, 0);
        this.myLoadingPanel.add((Component)this.mySplitter);
        this.add((Component)this.myLoadingPanel);
    }

    @NotNull
    public JEditorPane getDetailsPane() {
        return this.myDetails;
    }

    @NotNull
    public Tree getTree() {
        return this.myTree;
    }

    private JEditorPane createDetailsPane(@NotNull AndroidFacet facet2) {
        JEditorPane details = new JEditorPane();
        details.setMargin((Insets)JBUI.insets((int)5));
        details.setEditorKit(HTMLEditorKitBuilder.simple());
        details.setEditable(false);
        details.setFont(this.myDefaultFont);
        details.setBackground(this.myBackgroundColor);
        HyperlinkListener hyperLinkListener = e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String url = e.getDescription();
                this.myHtmlLinkManager.handleUrl(url, facet2.getModule(), null, false, HtmlLinkManager.NOOP_SURFACE);
            }
        };
        details.addHyperlinkListener(hyperLinkListener);
        return details;
    }

    private void createPopupMenu() {
        this.myPopup = new JBPopupMenu();
        JBMenuItem gotoItem = new JBMenuItem("Go to Declaration");
        gotoItem.addActionListener(e -> {
            TreePath treePath = this.myTree.getSelectionPath();
            ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
            if (node != null) {
                this.goToDeclaration(node.getUserObject());
            }
        });
        this.myPopup.add((JMenuItem)gotoItem);
        this.myRemoveItem = new JBMenuItem("Remove");
        this.myRemoveItem.addActionListener(e -> {
            TreePath treePath = this.myTree.getSelectionPath();
            ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
            WriteCommandAction.writeCommandAction((Project)this.myFacet.getModule().getProject(), (PsiFile[])new PsiFile[]{ManifestUtils.getMainManifest(this.myFacet)}).withName("Removing manifest tag").run(() -> ManifestUtils.toolsRemove(ManifestUtils.getMainManifest(this.myFacet), node.getUserObject()));
        });
        this.myPopup.add(this.myRemoveItem);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ManifestTreeNode node;
                Node attribute2;
                TreePath treePath;
                if (e.getClickCount() == 2 && e.getButton() == 1 && (treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && (attribute2 = (node = (ManifestTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof Attr) {
                    ManifestPanel.this.goToDeclaration(attribute2);
                }
            }

            private void handlePopup(@NotNull MouseEvent e) {
                TreePath treePath = ManifestPanel.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (treePath == null || e.getSource() == ManifestPanel.this.myDetails) {
                    treePath = ManifestPanel.this.myTree.getSelectionPath();
                }
                if (treePath != null) {
                    ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
                    ManifestPanel.this.myRemoveItem.setEnabled(ManifestPanel.this.canRemove(node.getUserObject()));
                    JBPopupMenu.showByEvent((MouseEvent)e, (JPopupMenu)ManifestPanel.this.myPopup);
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)ml);
        this.myDetails.addMouseListener(ml);
    }

    private void registerGotoAction() {
        AnAction goToDeclarationAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ManifestTreeNode node = (ManifestTreeNode)ManifestPanel.this.myTree.getLastSelectedPathComponent();
                if (node != null) {
                    ManifestPanel.this.goToDeclaration(node.getUserObject());
                }
            }
        };
        goToDeclarationAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("GotoDeclaration").getShortcutSet(), (JComponent)this.myTree);
    }

    @NotNull
    private TreeSpeedSearch addSpeedSearch() {
        return new TreeSpeedSearch((JTree)this.myTree);
    }

    public void startLoading() {
        this.mySplitter.setVisible(false);
        this.myLoadingPanel.setLoadingText("Computing merged manifest...");
        this.myLoadingPanel.startLoading();
    }

    public void showLoadingError() {
        this.myLoadingPanel.abortLoading("Unable to compute merged manifest.", AllIcons.General.Warning);
    }

    public void showManifest(MergedManifestSnapshot manifest, @NotNull VirtualFile selectedManifest, boolean isEditable) {
        this.myManifestEditable = isEditable;
        this.setManifestSnapshot(manifest, selectedManifest);
        this.myLoadingPanel.stopLoading();
        this.mySplitter.setVisible(true);
    }

    private void setManifestSnapshot(@NotNull MergedManifestSnapshot manifest, @NotNull VirtualFile selectedManifest) {
        this.myFile = selectedManifest;
        this.myManifest = manifest;
        this.myLibrariesByManifestDir = Arrays.stream(ModuleManager.getInstance((Project)this.myManifest.getModule().getProject()).getModules()).flatMap(module2 -> ProjectSystemUtil.getModuleSystem(module2).getAndroidLibraryDependencies(DependencyScopeType.MAIN).stream().filter(it -> it.getManifestFile() != null)).collect(Collectors.toMap(it -> it.getManifestFile().getParent(), it -> it, (a, b) -> a));
        Document document2 = this.myManifest.getDocument();
        Element root = document2 != null ? document2.getDocumentElement() : null;
        this.myTree.setModel((TreeModel)(root == null ? null : new DefaultTreeModel(new ManifestTreeNode(root))));
        ArrayList<ManifestFileWithMetadata> sortedFiles = new ArrayList<ManifestFileWithMetadata>();
        ArrayList<ManifestFileWithMetadata> sortedOtherFiles = new ArrayList<ManifestFileWithMetadata>();
        List<VirtualFile> manifestFiles = this.myManifest.getManifestFiles();
        sortedFiles.add(this.createMetadataForFile(this.myFacet, new SourceFilePosition(VfsUtilCore.virtualToIoFile((VirtualFile)selectedManifest), SourcePosition.UNKNOWN)));
        HashSet referenced = Sets.newHashSet();
        if (root != null) {
            this.recordLocationReferences(root, referenced);
        }
        for (VirtualFile f : manifestFiles) {
            if (f.equals(selectedManifest)) continue;
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)f);
            if (referenced.contains(file2)) {
                sortedFiles.add(this.createMetadataForFile(this.myFacet, new SourceFilePosition(file2, SourcePosition.UNKNOWN)));
                continue;
            }
            sortedOtherFiles.add(this.createMetadataForFile(this.myFacet, new SourceFilePosition(file2, SourcePosition.UNKNOWN)));
        }
        if (referenced.contains(GRADLE_MODEL_MARKER_FILE)) {
            sortedFiles.add(this.createMetadataForFile(this.myFacet, new SourceFilePosition(GRADLE_MODEL_MARKER_FILE, SourcePosition.UNKNOWN)));
        }
        Collections.sort(sortedFiles);
        Collections.sort(sortedOtherFiles);
        this.myFiles.clear();
        this.myFiles.addAll(sortedFiles);
        this.myOtherFiles.clear();
        this.myOtherFiles.addAll(sortedOtherFiles);
        if (root != null) {
            TreeUtil.expandAll((JTree)this.myTree);
        }
        this.updateDetails(null);
    }

    private void recordLocationReferences(@NotNull Node node, @NotNull Set<File> files2) {
        block4: {
            short type;
            block3: {
                Actions.Record record;
                block5: {
                    XmlNode.NodeKey targetId;
                    type = node.getNodeType();
                    if (type != 2) break block3;
                    List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
                    if (records.isEmpty() || !(targetId = (record = records.get(0)).getTargetId()).toString().contains("@")) break block4;
                    if (record.getActionType() != Actions.ActionType.INJECTED) break block5;
                    files2.add(GRADLE_MODEL_MARKER_FILE);
                    break block4;
                }
                File location = record.getActionLocation().getFile().getSourceFile();
                if (location == null || files2.contains(location)) break block4;
                files2.add(location);
                break block4;
            }
            if (type == 1) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1) continue;
                    this.recordLocationReferences(child, files2);
                }
                NamedNodeMap attributes = node.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.recordLocationReferences(attributes.item(i), files2);
                }
            }
        }
    }

    @Override
    public void valueChanged(@Nullable TreeSelectionEvent e) {
        if (e != null && e.isAddedPath()) {
            TreePath treePath = e.getPath();
            ManifestTreeNode node = (ManifestTreeNode)treePath.getLastPathComponent();
            this.updateDetails(node);
        } else {
            this.updateDetails(null);
        }
    }

    private void updateDetails(@Nullable ManifestTreeNode node) {
        Node manifestNode = node != null ? node.getUserObject() : null;
        HtmlBuilder sb = this.prepareHtmlReport(manifestNode);
        this.myDetails.setText(sb.getHtml());
        this.myDetails.setCaretPosition(0);
    }

    @NotNull
    private HtmlBuilder prepareHtmlReport(@Nullable Node node) {
        HtmlBuilder sb = new HtmlBuilder();
        this.prepareReportHeader(sb);
        if (node != null) {
            this.prepareSelectedNodeReport(node, sb);
        } else {
            this.prepareMergingErrorsReportForEverything(sb);
        }
        sb.closeHtmlBody();
        return sb;
    }

    private void prepareMergingErrorsReportForEverything(@NotNull HtmlBuilder sb) {
        List<MergingReport.Record> warnings;
        List<MergingReport.Record> errors2 = this.myManifest.getLoggingRecords().stream().filter(record -> record.getSeverity().equals((Object)MergingReport.Record.Severity.ERROR)).collect(Collectors.toList());
        if (!errors2.isEmpty()) {
            this.appendMergeRecordTitle(sb, "Merge Errors");
            errors2.forEach(record -> this.prepareErrorRecord(sb, (MergingReport.Record)record));
        }
        if (!(warnings = this.myManifest.getLoggingRecords().stream().filter(record -> record.getSeverity().equals((Object)MergingReport.Record.Severity.WARNING)).collect(Collectors.toList())).isEmpty()) {
            this.appendMergeRecordTitle(sb, "Merge Warnings");
            warnings.forEach(record -> this.prepareErrorRecord(sb, (MergingReport.Record)record));
        }
    }

    private void prepareSelectedNodeReport(@NotNull Node manifestNode, @NotNull HtmlBuilder sb) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, manifestNode);
        sb.beginUnderline().beginBold();
        sb.add("Merging Log");
        sb.endBold().endUnderline().newline();
        if (records.isEmpty()) {
            sb.add("No records found. (This is a bug in the manifest merger.)");
        }
        SourceFilePosition prev = null;
        boolean prevInjected = false;
        for (Actions.Record record : records) {
            boolean injected;
            SourceFilePosition location = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
            if (location.equals(prev)) continue;
            prev = location;
            Actions.ActionType actionType = record.getActionType();
            boolean bl = injected = actionType == Actions.ActionType.INJECTED;
            if (injected && prevInjected) continue;
            prevInjected = injected;
            if (injected) {
                sb.add("Value provided by Gradle");
                sb.newline();
                continue;
            }
            sb.add(StringUtil.capitalize((String)StringUtil.toLowerCase((String)String.valueOf(actionType))));
            sb.add(" from the ");
            sb.addHtml(this.getHtml(this.myFacet, location));
            String reason = record.getReason();
            if (reason != null) {
                sb.add("; reason: ");
                sb.add(reason);
            }
            sb.newline();
        }
        this.prepareMergingErrorsForNode(manifestNode, sb, records);
    }

    private void prepareMergingErrorsForNode(@NotNull Node manifestNode, @NotNull HtmlBuilder sb, List<? extends Actions.Record> actionRecords) {
        if (this.doesNodeHaveRecordOfSeverity(manifestNode, MergingReport.Record.Severity.WARNING)) {
            this.appendMergeRecordTitle(sb, "Merge Warnings");
            this.myManifest.getLoggingRecords().stream().filter(record -> actionRecords.stream().anyMatch(actionRecord -> record.getSourceLocation().equals((Object)actionRecord.getActionLocation()))).forEach(record -> this.prepareErrorRecord(sb, (MergingReport.Record)record));
        }
        if (this.doesNodeHaveRecordOfSeverity(manifestNode, MergingReport.Record.Severity.ERROR)) {
            this.appendMergeRecordTitle(sb, "Merge Errors");
            this.myManifest.getLoggingRecords().stream().filter(record -> actionRecords.stream().anyMatch(actionRecord -> record.getSourceLocation().equals((Object)actionRecord.getActionLocation()))).forEach(record -> this.prepareErrorRecord(sb, (MergingReport.Record)record));
        }
    }

    private void appendMergeRecordTitle(@NotNull HtmlBuilder sb, String title) {
        sb.newline();
        sb.beginUnderline().beginBold();
        sb.add(title);
        sb.endBold().endUnderline().newline();
    }

    private void prepareErrorRecord(@NotNull HtmlBuilder sb, MergingReport.Record record) {
        sb.addHtml(ManifestPanel.getHtmlForErrorRecord(record.getSeverity()));
        sb.add(" ");
        try {
            sb.addHtml(ManifestPanel.getErrorHtml(this.myFacet, record.getMessage(), record.getSourceLocation(), this.myHtmlLinkManager, LocalFileSystem.getInstance().findFileByIoFile(this.myFiles.get(0).getFile()), this.myManifestEditable));
        }
        catch (Exception ex) {
            Logger.getInstance(ManifestPanel.class).error("error getting error html", (Throwable)ex);
            sb.add(record.getMessage());
        }
        sb.add(" ");
        sb.addHtml(this.getHtml(this.myFacet, record.getSourceLocation()));
        sb.newline();
    }

    private void prepareReportHeader(@NotNull HtmlBuilder sb) {
        Font font = StartupUiUtil.getLabelFont();
        sb.addHtml("<html><body style=\"font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt;\">");
        sb.beginUnderline().beginBold();
        sb.add("Manifest Sources");
        sb.endBold().endUnderline().newline();
        sb.addHtml("<table border=\"0\">");
        String borderColor = ColorUtil.toHex((Color)JBColor.GRAY);
        for (ManifestFileWithMetadata file2 : this.myFiles) {
            if (file2.getFile() == null) continue;
            Color color = this.getFileColor(file2.getFile());
            sb.addHtml("<tr><td width=\"24\" height=\"24\" style=\"background-color:#");
            sb.addHtml(ColorUtil.toHex((Color)color));
            sb.addHtml("; border: 1px solid #");
            sb.addHtml(borderColor);
            sb.addHtml(";\">");
            sb.addHtml("</td><td>");
            this.describePosition(sb, file2);
            sb.addHtml("</td></tr>");
        }
        sb.addHtml("</table>");
        sb.newline();
        if (!this.myOtherFiles.isEmpty()) {
            sb.beginUnderline().beginBold();
            sb.add("Other Manifest Files");
            sb.endBold().endUnderline().newline();
            sb.add("(Included in merge, but did not contribute any elements)").newline();
            for (ManifestFileWithMetadata file2 : this.myOtherFiles) {
                this.describePosition(sb, file2);
                sb.newline();
            }
            sb.newline().newline();
        }
    }

    @NotNull
    private Color getNodeColor(@NotNull Node node) {
        Actions.Record record;
        File file2;
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
        if (!records.isEmpty() && (file2 = (record = records.get(0)).getActionType() == Actions.ActionType.INJECTED ? this.createMetadataForFile(this.myFacet, new SourceFilePosition(GRADLE_MODEL_MARKER_FILE, SourcePosition.UNKNOWN)).getFile() : this.createMetadataForFile(this.myFacet, ManifestUtils.getActionLocation(this.myFacet.getModule(), record)).getFile()) != null) {
            return this.getFileColor(file2);
        }
        return this.myBackgroundColor;
    }

    private boolean doesNodeHaveRecordOfSeverity(@NotNull Node node, MergingReport.Record.Severity severity) {
        List<? extends Actions.Record> actionRecords = ManifestUtils.getRecords(this.myManifest, node);
        return this.myManifest.getLoggingRecords().stream().filter(record -> record.getSeverity().equals((Object)severity)).anyMatch(record -> {
            for (Actions.Record actionRecord : actionRecords) {
                if (!record.getSourceLocation().equals((Object)actionRecord.getActionLocation())) continue;
                return true;
            }
            return false;
        });
    }

    @Nullable
    private Icon getNodeIcon(@NotNull Node node) {
        if (this.doesNodeHaveRecordOfSeverity(node, MergingReport.Record.Severity.ERROR)) {
            return StudioIcons.Common.ERROR;
        }
        if (this.doesNodeHaveRecordOfSeverity(node, MergingReport.Record.Severity.WARNING)) {
            return StudioIcons.Common.WARNING;
        }
        return null;
    }

    @NotNull
    private Color getFileColor(@NotNull File file2) {
        int index2 = this.getFileIndex(file2);
        if (index2 == 0) {
            return this.myBackgroundColor;
        }
        return AnnotationColors.BG_COLORS[(index2 - 1) * 3 % AnnotationColors.BG_COLORS.length];
    }

    private int getFileIndex(@NotNull File file2) {
        int index2 = 0;
        for (ManifestFileWithMetadata metadata : this.myFiles) {
            if (file2.getAbsolutePath().equals(metadata.getFile().getAbsolutePath())) {
                return index2;
            }
            ++index2;
        }
        for (ManifestFileWithMetadata metadata : this.myOtherFiles) {
            if (file2.getAbsolutePath().equals(metadata.getFile().getAbsolutePath())) {
                return index2;
            }
            ++index2;
        }
        return index2;
    }

    private boolean canRemove(@NotNull Node node) {
        if (!this.myManifestEditable) {
            return false;
        }
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, node);
        if (records.isEmpty()) {
            return false;
        }
        File mainManifest = VfsUtilCore.virtualToIoFile((VirtualFile)ManifestUtils.getMainManifest(this.myFacet).getVirtualFile());
        for (Actions.Record record : records) {
            if (!FileUtil.filesEqual((File)ManifestUtils.getActionLocation(this.myFacet.getModule(), record).getFile().getSourceFile(), (File)mainManifest)) continue;
            return false;
        }
        return true;
    }

    private void goToDeclaration(Node element2) {
        List<? extends Actions.Record> records = ManifestUtils.getRecords(this.myManifest, element2);
        for (Actions.Record record : records) {
            File ioFile;
            SourceFilePosition sourceFilePosition = ManifestUtils.getActionLocation(this.myFacet.getModule(), record);
            SourceFile sourceFile = sourceFilePosition.getFile();
            if (SourceFile.UNKNOWN.equals((Object)sourceFile) || (ioFile = sourceFile.getSourceFile()) == null) continue;
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            assert (file2 != null);
            int line2 = -1;
            int column2 = 0;
            SourcePosition sourcePosition = sourceFilePosition.getPosition();
            if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                line2 = sourcePosition.getStartLine();
                column2 = sourcePosition.getStartColumn();
            }
            Project project = this.myFacet.getModule().getProject();
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, line2, column2);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
            break;
        }
    }

    @NotNull
    static String getErrorHtml(@NotNull AndroidFacet facet2, @NotNull String message2, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile, boolean manifestEditable) {
        HtmlBuilder sb = new HtmlBuilder();
        int index2 = message2.indexOf(SUGGESTION_MARKER);
        if (manifestEditable && index2 >= 0) {
            String action2 = message2.substring(index2 += SUGGESTION_MARKER.length(), message2.indexOf(32, index2));
            sb.add(message2.substring(0, index2));
            message2 = message2.substring(index2);
            if ("add".equals(action2)) {
                sb.addHtml(ManifestPanel.getErrorAddHtml(facet2, message2, position, htmlLinkManager, currentlyOpenFile));
            } else if ("use".equals(action2)) {
                sb.addHtml(ManifestPanel.getErrorUseHtml(facet2, message2, position, htmlLinkManager, currentlyOpenFile));
            } else if ("remove".equals(action2)) {
                sb.add(message2);
            }
        } else {
            sb.add(message2);
        }
        return sb.getHtml();
    }

    @NotNull
    private static String getErrorAddHtml(@NotNull AndroidFacet facet2, @NotNull String message2, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        HtmlBuilder sb = new HtmlBuilder();
        Matcher matcher = ADD_SUGGESTION_FORMAT.matcher(message2);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("unexpected add suggestion format " + message2);
        }
        String attributeName = matcher.group(1);
        String attributeValue = matcher.group(2);
        String tagName = matcher.group(3);
        String filePosition = matcher.group(4);
        Matcher filePosMatcher = FILE_POSITION_FORMAT.matcher(filePosition);
        if (position.getPosition().equals((Object)SourcePosition.UNKNOWN) || !filePosMatcher.matches()) {
            Logger.getInstance(ManifestPanel.class).info("Unknown source position for " + tagName + " tag in file " + position.getFile());
            sb.add(message2);
            return sb.getHtml();
        }
        int line2 = Integer.parseInt(filePosMatcher.group(1));
        int col = Integer.parseInt(filePosMatcher.group(2));
        XmlFile mainManifest = ManifestPanel.getMainManifestFile(facet2, position.getFile().getSourceFile());
        Element element2 = ManifestPanel.getElementAt(mainManifest, line2, col);
        if (element2 != null && tagName.equals(element2.getTagName())) {
            Element xmlTag = element2;
            sb.addLink(message2, htmlLinkManager.createRunnableLink(() -> ManifestPanel.addToolsAttribute(mainManifest, xmlTag, attributeName, attributeValue)));
        } else {
            Logger.getInstance(ManifestPanel.class).warn("can not find " + tagName + " tag " + element2);
            sb.add(message2);
        }
        return sb.getHtml();
    }

    private static XmlFile getMainManifestFile(AndroidFacet facet2, File manifestErrorSourceFile) {
        PsiFile psiFile;
        VirtualFile manifestFile;
        if (manifestErrorSourceFile != null && (manifestFile = VfsUtil.findFileByIoFile((File)manifestErrorSourceFile, (boolean)true)) != null && (psiFile = PsiManager.getInstance((Project)facet2.getModule().getProject()).findFile(manifestFile)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return ManifestUtils.getMainManifest(facet2);
    }

    @Nullable
    private static Element getElementAt(XmlFile mainManifest, int line2, int col) {
        Element element2 = null;
        try {
            Document document2 = PositionXmlParser.parse((String)mainManifest.getText());
            for (Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document2, (int)line2, (int)col); node != null; node = node.getParentNode()) {
                if (!(node instanceof Element)) continue;
                element2 = (Element)node;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return element2;
    }

    @NotNull
    private static String getErrorUseHtml(@NotNull AndroidFacet facet2, @NotNull String message2, @NotNull SourceFilePosition position, @NotNull HtmlLinkManager htmlLinkManager, @Nullable VirtualFile currentlyOpenFile) {
        int minSdkVersion2;
        HtmlBuilder sb = new HtmlBuilder();
        String versionPrefix = "to at least ";
        int start2 = message2.indexOf(versionPrefix) + versionPrefix.length();
        if (start2 < 0) {
            throw new IllegalArgumentException("unexpected use suggestion format " + message2);
        }
        int end = message2.indexOf(44, start2);
        if (end < 0) {
            throw new IllegalArgumentException("unexpected use suggestion format " + message2);
        }
        String minSdkVersionString = message2.substring(start2, end);
        try {
            minSdkVersion2 = Integer.parseInt(minSdkVersionString);
        }
        catch (NumberFormatException e) {
            sb.add(message2);
            return sb.getHtml();
        }
        int finalMinSdk = minSdkVersion2;
        Runnable link2 = () -> {
            Runnable linkAction = () -> {
                ProjectBuildModel pbm = ProjectBuildModel.get(facet2.getModule().getProject());
                GradleBuildModel gbm = pbm.getModuleBuildModel(facet2.getModule());
                if (gbm == null) {
                    return;
                }
                gbm.android().defaultConfig().minSdkVersion().setValue(finalMinSdk);
                ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.runWriteCommandAction((Project)facet2.getModule().getProject(), (String)"Update build file minSdkVersion", null, () -> pbm.applyChanges(), (PsiFile[])new PsiFile[]{gbm.getPsiFile()}));
                Runnable syncRunnable = () -> ManifestPanel.requestSync(facet2.getModule().getProject());
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    syncRunnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(syncRunnable);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                linkAction.run();
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(linkAction);
            }
        };
        sb.addLink(message2.substring(0, end), htmlLinkManager.createRunnableLink(link2));
        sb.add(message2.substring(end));
        return sb.getHtml();
    }

    private static void requestSync(Project project) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
    }

    static void addToolsAttribute(@NotNull XmlFile file2, @NotNull Element element2, @NotNull String attributeName, @NotNull String attributeValue) {
        Project project = file2.getProject();
        WriteCommandAction.writeCommandAction((Project)project).withName("Apply manifest suggestion").run(() -> ManifestUtils.addToolsAttribute(file2, element2, attributeName, attributeValue));
    }

    @NotNull
    static String getHtmlForErrorRecord(@NotNull MergingReport.Record.Severity severity) {
        String severityString = StringUtil.capitalize((String)StringUtil.toLowerCase((String)severity.toString()));
        if (severity == MergingReport.Record.Severity.ERROR || severity == MergingReport.Record.Severity.WARNING) {
            return new HtmlBuilder().addHtml("<font color=\"#" + ColorUtil.toHex((Color)JBColor.RED) + "\">").addBold(severityString).addHtml("</font>").endBold().addHtml(":").getHtml();
        }
        return severityString;
    }

    @NotNull
    String getHtml(@NotNull AndroidFacet facet2, @NotNull SourceFilePosition sourceFilePosition) {
        HtmlBuilder sb = new HtmlBuilder();
        this.describePosition(sb, this.createMetadataForFile(facet2, sourceFilePosition));
        return sb.getHtml();
    }

    private ManifestFileWithMetadata createMetadataForFile(@NotNull AndroidFacet facet2, @NotNull SourceFilePosition sourceFilePosition) {
        SourceFile sourceFile = sourceFilePosition.getFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        File file2 = sourceFile.getSourceFile();
        if (file2 != null && file2.getAbsolutePath().equals(GRADLE_MODEL_MARKER_FILE.getAbsolutePath())) {
            VirtualFile gradleBuildFile = GradleUtil.getGradleBuildFile(facet2.getModule());
            if (gradleBuildFile != null) {
                file2 = VfsUtilCore.virtualToIoFile((VirtualFile)gradleBuildFile);
                return new InjectedBuildDotGradleFile(file2);
            }
            return new InjectedBuildDotGradleFile(null);
        }
        if (file2 != null && NAV_FILE_PATTERN.matcher(FileUtils.toSystemIndependentPath((String)file2.toString())).matches()) {
            VirtualFile vResDir;
            Object source = "";
            Boolean isProjectFile = false;
            File resDir = file2.getParentFile() == null ? null : file2.getParentFile().getParentFile();
            VirtualFile virtualFile = vResDir = resDir == null ? null : LocalFileSystem.getInstance().findFileByIoFile(resDir);
            if (vResDir != null) {
                Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)vResDir, (Project)facet2.getModule().getProject());
                if (module2 != null) {
                    isProjectFile = true;
                }
                for (NamedIdeaSourceProvider provider2 : SourceProviderManager.getInstance(facet2).getCurrentSourceProviders()) {
                    if (!Iterables.contains(provider2.getResDirectories(), (Object)vResDir)) continue;
                    source = (String)source + provider2.getName() + " ";
                    break;
                }
            }
            source = (String)source + file2.getName();
            return new ManifestXmlWithMetadata(ManifestXmlType.NAVIGATION_XML, file2, (String)source, isProjectFile, sourcePosition);
        }
        if (file2 != null) {
            Object source = null;
            boolean isProjectFile = false;
            Module[] modules = ModuleManager.getInstance((Project)facet2.getModule().getProject()).getModules();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
            if (vFile != null) {
                NamedIdeaSourceProvider provider3;
                String path2 = file2.getPath();
                Module module3 = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)facet2.getModule().getProject());
                if (module3 != null) {
                    isProjectFile = true;
                    if (modules.length >= 2) {
                        source = ModuleSystemUtil.getHolderModule(module3).getName();
                    }
                    if (path2.contains("exploded-aar")) {
                        source = this.findSourceForFileInExplodedAar(file2);
                    }
                } else if (path2.contains("output") && path2.matches(".*\\w{40}[\\\\/]output.*")) {
                    source = this.findSourceForFileInExplodedAar(file2);
                } else if (path2.contains("caches")) {
                    source = this.findSourceForFileInExplodedAar(file2);
                }
                if ((provider3 = ManifestUtils.findManifestSourceProvider(facet2, vFile)) != null) {
                    String providerName = provider3.getName();
                    source = source == null ? providerName : (String)source + " " + providerName;
                }
            }
            if (source == null) {
                source = file2.getName();
                if (!SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
                    source = (String)source + ":" + String.valueOf(sourcePosition);
                }
            }
            return new ManifestXmlWithMetadata(ManifestXmlType.ANDROID_MANIFEST_XML, file2, (String)source, isProjectFile, sourcePosition);
        }
        return UnknownManifestFile.INSTANCE;
    }

    private void describePosition(@NotNull HtmlBuilder sb, ManifestFileWithMetadata manifestFile) {
        if (manifestFile instanceof InjectedBuildDotGradleFile) {
            InjectedBuildDotGradleFile injectedFile = (InjectedBuildDotGradleFile)manifestFile;
            if (injectedFile.getFile() != null) {
                sb.addHtml("<a href=\"");
                sb.add(injectedFile.getFile().toURI().toString());
                sb.addHtml("\">");
                sb.add(injectedFile.getFile().getName());
                sb.addHtml("</a>");
                sb.add(" injection");
            } else {
                sb.add("build.gradle injection (source location unknown)");
            }
            return;
        }
        if (manifestFile instanceof ManifestXmlWithMetadata) {
            ManifestXmlWithMetadata manifestXml = (ManifestXmlWithMetadata)manifestFile;
            if (manifestXml.getType() == ManifestXmlType.NAVIGATION_XML) {
                sb.addHtml("<a href=\"");
                sb.add(manifestXml.getFile().toURI().toString());
                if (!SourcePosition.UNKNOWN.equals((Object)manifestXml.getSourcePosition())) {
                    sb.add(":");
                    sb.add(String.valueOf(manifestXml.getSourcePosition().getStartLine()));
                    sb.add(":");
                    sb.add(String.valueOf(manifestXml.getSourcePosition().getStartColumn()));
                }
                sb.addHtml("\">");
                sb.add(manifestXml.getSourceLibrary());
                sb.addHtml("</a>");
                sb.add(" navigation file");
                if (!SourcePosition.UNKNOWN.equals((Object)manifestXml.getSourcePosition())) {
                    sb.add(", line ");
                    sb.add(Integer.toString(manifestXml.getSourcePosition().getStartLine()));
                }
                return;
            }
            if (manifestXml.getType() == ManifestXmlType.ANDROID_MANIFEST_XML) {
                sb.addHtml("<a href=\"");
                sb.add(manifestXml.getFile().toURI().toString());
                if (!SourcePosition.UNKNOWN.equals((Object)manifestXml.getSourcePosition())) {
                    sb.add(":");
                    sb.add(String.valueOf(manifestXml.getSourcePosition().getStartLine()));
                    sb.add(":");
                    sb.add(String.valueOf(manifestXml.getSourcePosition().getStartColumn()));
                }
                sb.addHtml("\">");
                sb.add(manifestXml.getSourceLibrary());
                sb.addHtml("</a>");
                sb.add(" manifest");
                if (FileUtil.filesEqual((File)manifestXml.getFile(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile))) {
                    sb.add(" (this file)");
                }
                if (!SourcePosition.UNKNOWN.equals((Object)manifestXml.getSourcePosition())) {
                    sb.add(", line ");
                    sb.add(Integer.toString(manifestXml.getSourcePosition().getStartLine()));
                }
            }
        }
    }

    @Nullable
    private String findSourceForFileInExplodedAar(@NotNull File file2) {
        File parentFile = file2.getParentFile();
        if (parentFile == null) {
            return null;
        }
        PathString parentFilePath = new PathString(parentFile);
        ExternalAndroidLibrary androidLibrary = this.myLibrariesByManifestDir.get(parentFilePath);
        if (androidLibrary == null) {
            return null;
        }
        return GradleUtil.getDependencyDisplayName(androidLibrary.getAddress());
    }

    @NotNull
    public static Color harder(@NotNull Color color) {
        if (color.getBlue() == color.getRed() && color.getRed() == color.getGreen()) {
            return color;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], 1.0f, hsb[2]);
    }

    private class FileColorTree
    extends Tree {
        public FileColorTree() {
            this.setFont(ManifestPanel.this.myDefaultFont);
            this.setBackground(ManifestPanel.this.myBackgroundColor);
        }

        public boolean isFileColorsEnabled() {
            if (this.isOpaque()) {
                this.setOpaque(false);
            }
            return true;
        }

        @Nullable
        public Color getFileColorFor(Object object) {
            return object == null ? null : ManifestPanel.this.getNodeColor((Node)object);
        }
    }

    private class SyntaxHighlightingCellRenderer
    extends ColoredTreeCellRenderer {
        private final SimpleTextAttributes myTagNameAttributes;
        private final SimpleTextAttributes myNameAttributes;
        private final SimpleTextAttributes myValueAttributes;
        private final SimpleTextAttributes myPrefixAttributes;

        public SyntaxHighlightingCellRenderer() {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color tagNameColor = globalScheme.getAttributes(XmlHighlighterColors.XML_TAG_NAME).getForegroundColor();
            Color nameColor = globalScheme.getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_NAME).getForegroundColor();
            Color valueColor = globalScheme.getAttributes(XmlHighlighterColors.XML_ATTRIBUTE_VALUE).getForegroundColor();
            Color prefixColor = globalScheme.getAttributes(XmlHighlighterColors.XML_NS_PREFIX).getForegroundColor();
            this.myTagNameAttributes = new SimpleTextAttributes(1, tagNameColor);
            this.myNameAttributes = new SimpleTextAttributes(0, nameColor);
            this.myValueAttributes = new SimpleTextAttributes(0, valueColor);
            this.myPrefixAttributes = new SimpleTextAttributes(0, prefixColor);
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value2 instanceof ManifestTreeNode) {
                ManifestTreeNode node = (ManifestTreeNode)value2;
                this.setIcon(ManifestPanel.this.getNodeIcon(node.getUserObject()));
                if (node.getUserObject() instanceof Element) {
                    Element element2 = (Element)node.getUserObject();
                    this.append("<");
                    this.append(element2.getTagName(), this.myTagNameAttributes);
                    if (!expanded) {
                        this.append(" ... " + this.getCloseTag(node));
                    }
                }
                if (node.getUserObject() instanceof Attr) {
                    Attr attr = (Attr)node.getUserObject();
                    ManifestTreeNode parent2 = node.getParent();
                    assert (parent2 != null);
                    if (attr.getPrefix() != null) {
                        this.append(attr.getPrefix(), this.myPrefixAttributes);
                        this.append(":");
                        this.append(attr.getLocalName(), this.myNameAttributes);
                    } else {
                        this.append(attr.getName(), this.myNameAttributes);
                    }
                    this.append("=\"");
                    this.append(attr.getValue(), this.myValueAttributes);
                    this.append("\"");
                    if (parent2.lastAttribute() == node) {
                        this.append(" " + this.getCloseTag(node));
                    }
                }
            }
        }

        private String getCloseTag(ManifestTreeNode node) {
            return node.hasElementChildren() ? ">" : "/>";
        }
    }

    static class ManifestTreeNode
    extends DefaultMutableTreeNode {
        public ManifestTreeNode(@NotNull Node obj) {
            super(obj);
        }

        @Override
        @NotNull
        public Node getUserObject() {
            return (Node)super.getUserObject();
        }

        @Override
        public int getChildCount() {
            Node obj = this.getUserObject();
            if (obj instanceof Element) {
                Element element2 = (Element)obj;
                NamedNodeMap attributes = element2.getAttributes();
                int count2 = attributes.getLength();
                NodeList childNodes2 = element2.getChildNodes();
                int n = childNodes2.getLength();
                for (int i = 0; i < n; ++i) {
                    Node child = childNodes2.item(i);
                    if (child.getNodeType() != 1) continue;
                    ++count2;
                }
                return count2;
            }
            return 0;
        }

        @Override
        @NotNull
        public ManifestTreeNode getChildAt(int index2) {
            Node obj = this.getUserObject();
            if (this.children == null && obj instanceof Element) {
                Element element2 = (Element)obj;
                NamedNodeMap attributes = element2.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.add(new ManifestTreeNode(attributes.item(i)));
                }
                NodeList childNodes2 = element2.getChildNodes();
                int n2 = childNodes2.getLength();
                for (int i = 0; i < n2; ++i) {
                    Node child = childNodes2.item(i);
                    if (child.getNodeType() != 1) continue;
                    this.add(new ManifestTreeNode(child));
                }
            }
            return (ManifestTreeNode)super.getChildAt(index2);
        }

        @Override
        public void add(@NotNull MutableTreeNode newChild) {
            this.insert(newChild, this.children == null ? 0 : this.children.size());
        }

        @Override
        @NotNull
        public String toString() {
            Node obj = this.getUserObject();
            if (obj instanceof Attr) {
                Attr xmlAttribute = (Attr)obj;
                return xmlAttribute.getName() + " = " + xmlAttribute.getValue();
            }
            if (obj instanceof Element) {
                Element xmlTag = (Element)obj;
                return xmlTag.getTagName();
            }
            return obj.toString();
        }

        @Override
        @Nullable
        public ManifestTreeNode getParent() {
            return (ManifestTreeNode)super.getParent();
        }

        @NotNull
        public ManifestTreeNode lastAttribute() {
            Node xmlTag = this.getUserObject();
            return this.getChildAt(xmlTag.getAttributes().getLength() - 1);
        }

        public boolean hasElementChildren() {
            Node node = this.getUserObject();
            if (node instanceof Attr) {
                ManifestTreeNode parent2 = this.getParent();
                assert (parent2 != null);
                return parent2.hasElementChildren();
            }
            return node.getChildNodes().getLength() > 0;
        }
    }
}

