/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.liveedit.ui;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.editors.liveedit.ui.DeviceGetter;
import com.android.tools.idea.editors.liveedit.ui.EmulatorLiveEditAdapter;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/editors/liveedit/ui/EmulatorLiveEditAdapter;", "Lcom/android/tools/idea/editors/liveedit/ui/DeviceGetter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedDeviceFutures", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/ddmlib/IDevice;", "getProject", "()Lcom/intellij/openapi/project/Project;", "device", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "devices", "", "register", "", "serial", "unregister", "intellij.android.core"})
public final class EmulatorLiveEditAdapter
implements DeviceGetter {
    @NotNull
    private final Project project;
    @NotNull
    private ConcurrentHashMap<String, ListenableFuture<IDevice>> cachedDeviceFutures;

    public EmulatorLiveEditAdapter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cachedDeviceFutures = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void register(@NotNull String serial) {
        Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
        Map map2 = this.cachedDeviceFutures;
        ListenableFuture listenableFuture = Futures.immediateCancelledFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateCancelledFuture()");
        ListenableFuture listenableFuture2 = listenableFuture;
        map2.put(serial, listenableFuture2);
    }

    public final void unregister(@NotNull String serial) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
            ListenableFuture<IDevice> listenableFuture = this.cachedDeviceFutures.remove(serial);
            if (listenableFuture == null) break block0;
            listenableFuture.cancel(true);
        }
    }

    @Override
    @Nullable
    public String serial(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return (String)dataContext.getData(RunningDevicesConstants.SERIAL_NUMBER_KEY);
    }

    @Override
    @Nullable
    public IDevice device(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        String string = this.serial(dataContext);
        if (string == null) {
            return null;
        }
        String serial = string;
        ListenableFuture<IDevice> listenableFuture = this.cachedDeviceFutures.get(serial);
        if (listenableFuture == null) {
            return null;
        }
        ListenableFuture<IDevice> future2 = listenableFuture;
        if (!future2.isCancelled()) {
            if (future2.isDone()) {
                IDevice device2 = (IDevice)future2.get();
                if (device2 != null) {
                    return device2;
                }
            } else {
                return null;
            }
        }
        File file2 = AndroidSdkUtils.findAdb((Project)this.project).adbPath;
        if (file2 == null) {
            throw new Exception("Could not find adb executable");
        }
        File adbFile = file2;
        ListenableFuture<AndroidDebugBridge> listenableFuture2 = AdbService.getInstance().getDebugBridge(adbFile);
        Intrinsics.checkNotNullExpressionValue(listenableFuture2, (String)"getInstance().getDebugBridge(adbFile)");
        ListenableFuture<AndroidDebugBridge> bridgeFuture = listenableFuture2;
        Map map2 = this.cachedDeviceFutures;
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService()");
        ListenableFuture listenableFuture3 = FutureUtils.transform(bridgeFuture, (Executor)executorService, (Function1)((Function1)new Function1<AndroidDebugBridge, IDevice>(serial){
            final /* synthetic */ String $serial;
            {
                this.$serial = $serial;
                super(1);
            }

            @Nullable
            public final IDevice invoke(@NotNull AndroidDebugBridge debugBridge) {
                Object object;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)debugBridge, (String)"debugBridge");
                    IDevice[] iDeviceArray = debugBridge.getDevices();
                    Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"debugBridge.devices");
                    Object[] objectArray = iDeviceArray;
                    String string = this.$serial;
                    for (Object object2 : objectArray) {
                        IDevice it = (IDevice)object2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSerialNumber(), (Object)string)) continue;
                        object = object2;
                        break block1;
                    }
                    object = null;
                }
                return (IDevice)object;
            }
        }));
        map2.put(serial, listenableFuture3);
        return null;
    }

    @Override
    @NotNull
    public List<IDevice> devices() {
        List<IDevice> list2 = this.cachedDeviceFutures.values().stream().filter(devices.1.INSTANCE).map(devices.2.INSTANCE).filter(devices.3.INSTANCE).map(devices.4.INSTANCE).toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"cachedDeviceFutures.valu\u2026nullable)\n      .toList()");
        return list2;
    }
}

