/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.literals.internal;

import com.android.tools.analytics.Percentiles;
import com.android.tools.idea.editors.literals.LiveLiteralsMonitorHandler;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsDiagnosticsKt;
import com.google.wireless.android.sdk.stats.LiveLiteralsEvent;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u001a\u0010\u0016\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\t\"\u0004\b\u0018\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/editors/literals/internal/RemoteStatsCollector;", "", "msProvider", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "activeDevices", "", "getActiveDevices", "()I", "setActiveDevices", "(I)V", "created", "deployTimeMsPercentiles", "Lcom/android/tools/analytics/Percentiles;", "getDeployTimeMsPercentiles", "()Lcom/android/tools/analytics/Percentiles;", "failedDeployments", "getFailedDeployments", "setFailedDeployments", "problemsPercentiles", "getProblemsPercentiles", "successfulDeployments", "getSuccessfulDeployments", "setSuccessfulDeployments", "buildProto", "Lcom/google/wireless/android/sdk/stats/LiveLiteralsEvent$LiveLiteralsDeployStats;", "deviceType", "Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler$DeviceType;", "isOlderThan", "", "time", "unit", "Ljava/util/concurrent/TimeUnit;", "Companion", "intellij.android.core"})
final class RemoteStatsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long created;
    @NotNull
    private final Percentiles deployTimeMsPercentiles;
    @NotNull
    private final Percentiles problemsPercentiles;
    private int successfulDeployments;
    private int failedDeployments;
    private int activeDevices;
    @NotNull
    private static final double[] ESTIMATION_TARGETS;
    private static final int NUM_RAW_SAMPLES = 80;

    public RemoteStatsCollector(@NotNull Function0<Long> msProvider) {
        Intrinsics.checkNotNullParameter(msProvider, (String)"msProvider");
        this.created = ((Number)msProvider.invoke()).longValue();
        this.deployTimeMsPercentiles = new Percentiles(ESTIMATION_TARGETS, 80);
        this.problemsPercentiles = new Percentiles(ESTIMATION_TARGETS, 80);
    }

    @NotNull
    public final Percentiles getDeployTimeMsPercentiles() {
        return this.deployTimeMsPercentiles;
    }

    @NotNull
    public final Percentiles getProblemsPercentiles() {
        return this.problemsPercentiles;
    }

    public final int getSuccessfulDeployments() {
        return this.successfulDeployments;
    }

    public final void setSuccessfulDeployments(int n) {
        this.successfulDeployments = n;
    }

    public final int getFailedDeployments() {
        return this.failedDeployments;
    }

    public final void setFailedDeployments(int n) {
        this.failedDeployments = n;
    }

    public final int getActiveDevices() {
        return this.activeDevices;
    }

    public final void setActiveDevices(int n) {
        this.activeDevices = n;
    }

    public final boolean isOlderThan(long time2, @NotNull TimeUnit unit, @NotNull Function0<Long> msProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(msProvider, (String)"msProvider");
        return ((Number)msProvider.invoke()).longValue() - this.created > unit.toMillis(time2);
    }

    @NotNull
    public final LiveLiteralsEvent.LiveLiteralsDeployStats buildProto(@NotNull LiveLiteralsMonitorHandler.DeviceType deviceType) {
        Intrinsics.checkNotNullParameter((Object)((Object)deviceType), (String)"deviceType");
        LiveLiteralsEvent.LiveLiteralsDeployStats liveLiteralsDeployStats = LiveLiteralsEvent.LiveLiteralsDeployStats.newBuilder().setDeviceType(LiveLiteralsDiagnosticsKt.protoType(deviceType)).setDeploymentTimeMs(this.deployTimeMsPercentiles.export()).setNumberOfProblems(this.problemsPercentiles.export()).setSuccessfulDeployments(this.successfulDeployments).setFailedDeployments(this.failedDeployments).setDevicesCount(this.activeDevices).build();
        Intrinsics.checkNotNullExpressionValue((Object)liveLiteralsDeployStats, (String)"newBuilder()\n    .setDev\u2026tiveDevices)\n    .build()");
        return liveLiteralsDeployStats;
    }

    static {
        double[] dArray = new double[]{0.5, 0.9, 0.99};
        ESTIMATION_TARGETS = dArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/editors/literals/internal/RemoteStatsCollector$Companion;", "", "()V", "ESTIMATION_TARGETS", "", "NUM_RAW_SAMPLES", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

