/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.literals.internal;

import com.android.tools.idea.editors.literals.internal.LiteralsClassUtilKt;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsConstructorVisitor;
import com.android.tools.idea.editors.literals.internal.MethodData;
import com.android.tools.idea.editors.literals.internal.RecordAnnotationVisitor;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J*\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u0018H$J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002JK\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010\u00042\b\u0010(\u001a\u0004\u0018\u00010\u00042\u0010\u0010)\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+J\u001c\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010\u00042\u0006\u0010/\u001a\u00020\u0015H\u0016J\u001e\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010\u00042\b\u0010\u0002\u001a\u0004\u0018\u00010-H\u0002J\b\u00100\u001a\u00020\u001dH\u0016J8\u00101\u001a\u0002022\u0006\u0010&\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u00042\b\u0010'\u001a\u0004\u0018\u00010\u00042\b\u00103\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u00042\b\u00103\u001a\u0004\u0018\u00010\u0011H\u0002J$\u00106\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00042\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000408H\u0002JC\u00109\u001a\u00020:2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00042\b\u0010.\u001a\u0004\u0018\u00010\u00042\b\u0010'\u001a\u0004\u0018\u00010\u00042\u0010\u0010;\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010<R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsFinder;", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "delegate", "fileInfoAnnotationName", "", "infoAnnotationName", "(Lorg/jetbrains/org/objectweb/asm/ClassVisitor;Ljava/lang/String;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "className", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "constantInitializationValues", "", "", "keyOffsets", "", "liveLiteralsClass", "", "methodsToRewrite", "", "Lcom/android/tools/idea/editors/literals/internal/MethodData;", "sourceFileName", "isLiveLiteralAnnotation", "annotationName", "onLiteralAccessor", "", "fileName", "offset", "initialValue", "data", "removeUnsignedSuffix", "name", "visit", "version", "access", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "descriptor", "visible", "visitEnd", "visitField", "Lorg/jetbrains/org/objectweb/asm/FieldVisitor;", "value", "visitFieldLoad", "key", "visitLiveLiteralAnnotation", "parameters", "", "visitMethod", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiteralsClassUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiteralsClassUtil.kt\ncom/android/tools/idea/editors/literals/internal/LiveLiteralsFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1851#2:317\n1852#2:324\n288#2,2:325\n12#3,5:318\n1#4:323\n*S KotlinDebug\n*F\n+ 1 LiteralsClassUtil.kt\ncom/android/tools/idea/editors/literals/internal/LiveLiteralsFinder\n*L\n295#1:317\n295#1:324\n313#1:325,2\n297#1:318,5\n*E\n"})
public abstract class LiveLiteralsFinder
extends ClassVisitor {
    @NotNull
    private final String fileInfoAnnotationName;
    @NotNull
    private final String infoAnnotationName;
    @NotNull
    private final Logger LOG;
    @NotNull
    private String className;
    private boolean liveLiteralsClass;
    @Nullable
    private String sourceFileName;
    @NotNull
    private final Map<String, Integer> keyOffsets;
    @NotNull
    private final Map<String, Object> constantInitializationValues;
    @NotNull
    private final List<MethodData> methodsToRewrite;

    @JvmOverloads
    public LiveLiteralsFinder(@Nullable ClassVisitor delegate2, @NotNull String fileInfoAnnotationName, @NotNull String infoAnnotationName) {
        Intrinsics.checkNotNullParameter((Object)fileInfoAnnotationName, (String)"fileInfoAnnotationName");
        Intrinsics.checkNotNullParameter((Object)infoAnnotationName, (String)"infoAnnotationName");
        super(589824, delegate2);
        this.fileInfoAnnotationName = fileInfoAnnotationName;
        this.infoAnnotationName = infoAnnotationName;
        Logger logger2 = Logger.getInstance(LiveLiteralsFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(LiveLiteralsFinder::class.java)");
        this.LOG = logger2;
        this.className = "";
        this.keyOffsets = new LinkedHashMap();
        this.constantInitializationValues = new LinkedHashMap();
        this.methodsToRewrite = new ArrayList();
    }

    public /* synthetic */ LiveLiteralsFinder(ClassVisitor classVisitor2, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "androidx.compose.runtime.internal.LiveLiteralFileInfo";
        }
        if ((n & 4) != 0) {
            string2 = "androidx.compose.runtime.internal.LiveLiteralInfo";
        }
        this(classVisitor2, string, string2);
    }

    @NotNull
    protected final String getClassName() {
        return this.className;
    }

    protected final void setClassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.className = string;
    }

    public void visit(int version2, int access, @NotNull String name2, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.className = name2;
        this.liveLiteralsClass = LiteralsClassUtilKt.isLiveLiteralsClassName(this.className);
        super.visit(version2, access, name2, signature, superName, interfaces2);
    }

    private final void visitLiveLiteralAnnotation(String name2, Map<String, String> parameters2) {
        this.LOG.debug("visitLiveLiteralAnnotation " + name2 + " = " + parameters2);
        String string = name2;
        if (Intrinsics.areEqual((Object)string, (Object)this.fileInfoAnnotationName)) {
            this.sourceFileName = parameters2.get("file");
        } else if (Intrinsics.areEqual((Object)string, (Object)this.infoAnnotationName)) {
            Map<String, Integer> map2 = this.keyOffsets;
            String string2 = parameters2.get("key");
            if (string2 == null) {
                throw new IllegalStateException("LiveLiteralInfo must define a key parameter".toString());
            }
            String string3 = string2;
            String string4 = parameters2.get("offset");
            if (string4 == null) {
                throw new IllegalStateException("LiveLiteralInfo must define an offset parameter".toString());
            }
            Integer n = Integer.parseInt(string4);
            map2.put(string3, n);
        }
    }

    private final void visitFieldLoad(String key, Object value2) {
        this.LOG.debug("visitFieldLoad " + key + " = " + value2);
        this.constantInitializationValues.put(key, value2);
    }

    private final boolean isLiveLiteralAnnotation(String annotationName) {
        return Intrinsics.areEqual((Object)annotationName, (Object)this.infoAnnotationName) || Intrinsics.areEqual((Object)annotationName, (Object)this.fileInfoAnnotationName);
    }

    private final AnnotationVisitor visitAnnotation(String descriptor2, AnnotationVisitor delegate2) {
        String annotationName = Type.getType((String)descriptor2).getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)annotationName, (String)"annotationName");
        return this.isLiveLiteralAnnotation(annotationName) ? (AnnotationVisitor)new RecordAnnotationVisitor(annotationName, (Function2<? super String, ? super Map<String, String>, Unit>)((Function2)new Function2<String, Map<String, ? extends String>, Unit>((Object)this){

            public final void invoke(@NotNull String p0, @NotNull Map<String, String> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                LiveLiteralsFinder.access$visitLiveLiteralAnnotation((LiveLiteralsFinder)((Object)this.receiver), p0, p1);
            }
        })) : delegate2;
    }

    @Nullable
    public AnnotationVisitor visitAnnotation(@Nullable String descriptor2, boolean visible) {
        return this.visitAnnotation(descriptor2, super.visitAnnotation(descriptor2, visible));
    }

    @NotNull
    public FieldVisitor visitField(int access, @Nullable String name2, @Nullable String descriptor2, @Nullable String signature, @Nullable Object value2) {
        FieldVisitor fieldVisitor;
        if (this.liveLiteralsClass) {
            FieldVisitor fieldVisitor2 = super.visitField(access, name2, descriptor2, signature, value2);
            fieldVisitor = new FieldVisitor(this, fieldVisitor2){
                final /* synthetic */ LiveLiteralsFinder this$0;
                {
                    this.this$0 = $receiver;
                    super(589824, $super_call_param$1);
                }

                @Nullable
                public AnnotationVisitor visitAnnotation(@Nullable String descriptor2, boolean visible) {
                    return LiveLiteralsFinder.access$visitAnnotation(this.this$0, descriptor2, super.visitAnnotation(descriptor2, visible));
                }
            };
        } else {
            FieldVisitor fieldVisitor3 = super.visitField(access, name2, descriptor2, signature, value2);
            fieldVisitor = fieldVisitor3;
            Intrinsics.checkNotNullExpressionValue((Object)fieldVisitor3, (String)"super.visitField(access,\u2026riptor, signature, value)");
        }
        return fieldVisitor;
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name2, @Nullable String descriptor2, @Nullable String signature, @Nullable String[] exceptions) {
        MethodVisitor methodVisitor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Function0 delegate2 = (Function0)new Function0<MethodVisitor>(this, access, name2, descriptor2, signature, exceptions){
            final /* synthetic */ LiveLiteralsFinder this$0;
            final /* synthetic */ int $access;
            final /* synthetic */ String $name;
            final /* synthetic */ String $descriptor;
            final /* synthetic */ String $signature;
            final /* synthetic */ String[] $exceptions;
            {
                this.this$0 = $receiver;
                this.$access = $access;
                this.$name = $name;
                this.$descriptor = $descriptor;
                this.$signature = $signature;
                this.$exceptions = $exceptions;
                super(0);
            }

            @NotNull
            public final MethodVisitor invoke() {
                MethodVisitor methodVisitor = LiveLiteralsFinder.access$visitMethod$s666722294(this.this$0, this.$access, this.$name, this.$descriptor, this.$signature, this.$exceptions);
                if (methodVisitor == null) {
                    methodVisitor = new MethodVisitor(){};
                }
                return methodVisitor;
            }
        };
        if (this.liveLiteralsClass) {
            this.LOG.debug("visitMethod " + name2 + " " + descriptor2);
            String string = name2;
            methodVisitor = Intrinsics.areEqual((Object)string, (Object)"<clinit>") ? (MethodVisitor)new LiveLiteralsConstructorVisitor((MethodVisitor)delegate2.invoke(), (Function2<? super String, Object, Unit>)((Function2)new Function2<String, Object, Unit>((Object)this){

                public final void invoke(@NotNull String p0, @Nullable Object p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    LiveLiteralsFinder.access$visitFieldLoad((LiveLiteralsFinder)((Object)this.receiver), p0, p1);
                }
            })) : (Intrinsics.areEqual((Object)string, (Object)"<init>") ? (MethodVisitor)delegate2.invoke() : (MethodVisitor)new MethodVisitor(this, access, name2, descriptor2, signature, exceptions){
                final /* synthetic */ LiveLiteralsFinder this$0;
                final /* synthetic */ int $access;
                final /* synthetic */ String $name;
                final /* synthetic */ String $descriptor;
                final /* synthetic */ String $signature;
                final /* synthetic */ String[] $exceptions;
                {
                    this.this$0 = $receiver;
                    this.$access = $access;
                    this.$name = $name;
                    this.$descriptor = $descriptor;
                    this.$signature = $signature;
                    this.$exceptions = $exceptions;
                    super(589824);
                }

                @Nullable
                public AnnotationVisitor visitAnnotation(@Nullable String descriptor2, boolean visible) {
                    return LiveLiteralsFinder.access$visitAnnotation(this.this$0, descriptor2, super.visitAnnotation(descriptor2, visible));
                }

                public void visitEnd() {
                    LiveLiteralsFinder.access$getMethodsToRewrite$p(this.this$0).add(new MethodData(this.$access, this.$name, this.$descriptor, this.$signature, this.$exceptions));
                }
            });
        } else {
            methodVisitor = (MethodVisitor)delegate2.invoke();
        }
        return methodVisitor;
    }

    protected abstract void onLiteralAccessor(@NotNull String var1, int var2, @Nullable Object var3, @NotNull MethodData var4);

    public void visitEnd() {
        Iterable $this$forEach$iv = this.methodsToRewrite;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MethodData data = (MethodData)element$iv;
            boolean bl = false;
            String name2 = this.removeUnsignedSuffix(data.getName());
            Logger $this$debug_u24default$iv = this.LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger2.debug("Rewriting LiveLiterals method " + name2, e$iv);
            }
            String fileName = this.sourceFileName;
            Integer offset = this.keyOffsets.get(name2);
            Object initialValue = this.constantInitializationValues.get(name2);
            if (fileName == null) {
                boolean $i$a$-requireNotNull-LiveLiteralsFinder$visitEnd$1$42 = false;
                String $i$a$-requireNotNull-LiveLiteralsFinder$visitEnd$1$42 = "The file name must have been initialized by a 'androidx.compose.runtime.internal.LiveLiteralFileInfo' annotation";
                throw new IllegalArgumentException($i$a$-requireNotNull-LiveLiteralsFinder$visitEnd$1$42.toString());
            }
            if (offset == null) {
                boolean bl3 = false;
                String string = "'" + name2 + "' key did not have an offset. Missing 'androidx.compose.runtime.internal.LiveLiteralInfo'";
                throw new IllegalArgumentException(string.toString());
            }
            this.onLiteralAccessor(fileName, offset, initialValue, data);
        }
        super.visitEnd();
    }

    private final String removeUnsignedSuffix(String name2) {
        String string;
        block5: {
            block4: {
                String unsignedTypeSuffix;
                Object v0;
                block3: {
                    Iterable $this$firstOrNull$iv = LiteralsClassUtilKt.access$getUnsignedTypesSuffixes$p();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)name2, (String)it, (boolean)false, (int)2, null)) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                if ((string = (unsignedTypeSuffix = (String)v0)) == null) break block4;
                String it = string;
                boolean bl = false;
                String string2 = StringsKt.removeSuffix((String)name2, (CharSequence)it);
                string = string2;
                if (string2 != null) break block5;
            }
            string = name2;
        }
        return string;
    }

    @JvmOverloads
    public LiveLiteralsFinder(@Nullable ClassVisitor delegate2, @NotNull String fileInfoAnnotationName) {
        Intrinsics.checkNotNullParameter((Object)fileInfoAnnotationName, (String)"fileInfoAnnotationName");
        this(delegate2, fileInfoAnnotationName, null, 4, null);
    }

    @JvmOverloads
    public LiveLiteralsFinder(@Nullable ClassVisitor delegate2) {
        this(delegate2, null, null, 6, null);
    }

    public static final /* synthetic */ void access$visitLiveLiteralAnnotation(LiveLiteralsFinder $this, String name2, Map parameters2) {
        $this.visitLiveLiteralAnnotation(name2, parameters2);
    }

    public static final /* synthetic */ AnnotationVisitor access$visitAnnotation(LiveLiteralsFinder $this, String descriptor2, AnnotationVisitor delegate2) {
        return $this.visitAnnotation(descriptor2, delegate2);
    }

    public static final /* synthetic */ MethodVisitor access$visitMethod$s666722294(LiveLiteralsFinder $this, int p0, String p1, String p2, String p3, String[] p4) {
        return super.visitMethod(p0, p1, p2, p3, p4);
    }

    public static final /* synthetic */ void access$visitFieldLoad(LiveLiteralsFinder $this, String key, Object value2) {
        $this.visitFieldLoad(key, value2);
    }

    public static final /* synthetic */ List access$getMethodsToRewrite$p(LiveLiteralsFinder $this) {
        return $this.methodsToRewrite;
    }
}

