/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.literals;

import com.android.annotations.Trace;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.editors.liveedit.LiveEditApplicationConfiguration;
import com.android.tools.idea.editors.liveedit.ui.EmulatorLiveEditAdapter;
import com.android.tools.idea.editors.liveedit.ui.LiveEditIssueNotificationAction;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.run.deployment.liveedit.EditEvent;
import com.android.tools.idea.run.deployment.liveedit.LiveEditAdbEventsListener;
import com.android.tools.idea.run.deployment.liveedit.LiveEditApp;
import com.android.tools.idea.run.deployment.liveedit.LiveEditNotifications;
import com.android.tools.idea.run.deployment.liveedit.LiveEditProjectMonitor;
import com.android.tools.idea.run.deployment.liveedit.LiveEditStatus;
import com.android.tools.idea.run.deployment.liveedit.PsiListener;
import com.android.tools.idea.run.deployment.liveedit.SourceInlineCandidate;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bJ\b\u0010!\u001a\u00020\rH\u0007J\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#j\u0002`&J,\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020$2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170,J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001bJ\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001bJ\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201H\u0003J\u0016\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204J\u0016\u00106\u001a\u00020\u001d2\u0006\u00103\u001a\u0002072\u0006\u00105\u001a\u000207J\u0006\u00108\u001a\u00020\u001dR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/editors/literals/LiveEditService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/Executor;", "adbEventsListener", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditAdbEventsListener;", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/Executor;Lcom/android/tools/idea/run/deployment/liveedit/LiveEditAdbEventsListener;)V", "getAdbEventsListener", "()Lcom/android/tools/idea/run/deployment/liveedit/LiveEditAdbEventsListener;", "deployMonitor", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditProjectMonitor;", "getExecutor", "()Ljava/util/concurrent/Executor;", "setExecutor", "(Ljava/util/concurrent/Executor;)V", "notifications", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditNotifications;", "getProject", "()Lcom/intellij/openapi/project/Project;", "showMultiDeployNotification", "", "showMultiDeviceNotification", "devices", "", "Lcom/android/ddmlib/IDevice;", "dispose", "", "editStatus", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditStatus;", "device", "getDeployMonitor", "inlineCandidateCache", "Ljava/util/LinkedHashMap;", "", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidate;", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidateCache;", "notifyAppDeploy", "packageName", "app", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditApp;", "isLiveEditable", "Lkotlin/Function0;", "notifyAppRefresh", "notifyLiveEditAvailability", "onPsiChanged", "event", "Lcom/android/tools/idea/run/deployment/liveedit/EditEvent;", "toggleLiveEdit", "oldMode", "Lcom/android/tools/idea/editors/liveedit/LiveEditApplicationConfiguration$LiveEditMode;", "newMode", "toggleLiveEditMode", "Lcom/android/tools/idea/editors/literals/LiveEditService$Companion$LiveEditTriggerMode;", "triggerLiveEdit", "Companion", "intellij.android.core"})
public final class LiveEditService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private Executor executor;
    @NotNull
    private final LiveEditAdbEventsListener adbEventsListener;
    @NotNull
    private final LiveEditNotifications notifications;
    @NotNull
    private final LiveEditProjectMonitor deployMonitor;
    private boolean showMultiDeviceNotification;
    private boolean showMultiDeployNotification;
    @NotNull
    private static final String PIGGYBACK_ACTION_ID = "SaveAll";

    public LiveEditService(@NotNull Project project, @NotNull Executor executor2, @NotNull LiveEditAdbEventsListener adbEventsListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)adbEventsListener, (String)"adbEventsListener");
        this.project = project;
        this.executor = executor2;
        this.adbEventsListener = adbEventsListener;
        this.notifications = new LiveEditNotifications(this.project);
        this.showMultiDeviceNotification = true;
        this.showMultiDeployNotification = true;
        final EmulatorLiveEditAdapter adapter2 = new EmulatorLiveEditAdapter(this.project);
        LiveEditIssueNotificationAction.Companion.registerProject(this.project, adapter2);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                LiveEditIssueNotificationAction.Companion.unregisterProject(this.getProject());
            }
        });
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void run() {
                block2: {
                    void $this$forEach$iv;
                    Content[] contentManager;
                    Content[] contentArray;
                    ToolWindowManager toolWindowManager = (ToolWindowManager)this.getProject().getServiceIfCreated(ToolWindowManager.class);
                    Content[] contentArray2 = toolWindowManager != null && (contentArray = toolWindowManager.getToolWindow("Running Devices")) != null ? contentArray.getContentManager() : null;
                    if (contentManager != null) {
                        contentManager = contentArray2;
                        contentManager.addContentManagerListener(new ContentManagerListener(){

                            public void contentAdded(@NotNull ContentManagerEvent event2) {
                                block1: {
                                    String serial;
                                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                                    if (!(event2.getContent().getComponent() instanceof DataProvider)) {
                                        return;
                                    }
                                    JComponent jComponent = event2.getContent().getComponent();
                                    Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DataProvider");
                                    String string = serial = (String)((DataProvider)jComponent).getData(RunningDevicesConstants.SERIAL_NUMBER_KEY.getName());
                                    if (string == null) break block1;
                                    String string2 = string;
                                    EmulatorLiveEditAdapter emulatorLiveEditAdapter = adapter2;
                                    String it = string2;
                                    boolean bl = false;
                                    emulatorLiveEditAdapter.register(it);
                                }
                            }

                            public void contentRemoveQuery(@NotNull ContentManagerEvent event2) {
                                block1: {
                                    String serial;
                                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                                    if (!(event2.getContent().getComponent() instanceof DataProvider)) {
                                        return;
                                    }
                                    JComponent jComponent = event2.getContent().getComponent();
                                    Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DataProvider");
                                    String string = serial = (String)((DataProvider)jComponent).getData(RunningDevicesConstants.SERIAL_NUMBER_KEY.getName());
                                    if (string == null) break block1;
                                    String string2 = string;
                                    EmulatorLiveEditAdapter emulatorLiveEditAdapter = adapter2;
                                    String it = string2;
                                    boolean bl = false;
                                    emulatorLiveEditAdapter.unregister(it);
                                }
                            }
                        });
                    }
                    Content[] contentArray3 = contentManager;
                    if (contentManager == null || (contentArray3 = contentArray3.getContents()) == null) break block2;
                    contentArray = contentArray3;
                    EmulatorLiveEditAdapter emulatorLiveEditAdapter = adapter2;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv).length;
                    for (int i = 0; i < n; ++i) {
                        String s;
                        void element$iv;
                        void it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        if (!(it.getComponent() instanceof DataProvider)) continue;
                        JComponent jComponent = it.getComponent();
                        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DataProvider");
                        String serial = (String)((DataProvider)jComponent).getData(RunningDevicesConstants.SERIAL_NUMBER_KEY.getName());
                        if (serial == null) continue;
                        boolean bl2 = false;
                        emulatorLiveEditAdapter.register(s);
                    }
                }
            }
        });
        PsiListener listener2 = new PsiListener((Function1<? super EditEvent, Unit>)((Function1)new Function1<EditEvent, Unit>((Object)this){

            public final void invoke(@NotNull EditEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                LiveEditService.access$onPsiChanged((LiveEditService)this.receiver, p0);
            }
        }));
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)listener2, (Disposable)this);
        this.deployMonitor = new LiveEditProjectMonitor(this, this.project);
        this.project.getMessageBus().connect((Disposable)this).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                ExecutionTarget executionTarget = env.getExecutionTarget();
                AndroidExecutionTarget androidExecutionTarget = executionTarget instanceof AndroidExecutionTarget ? (AndroidExecutionTarget)executionTarget : null;
                if (androidExecutionTarget == null) {
                    return;
                }
                AndroidExecutionTarget executionTarget2 = androidExecutionTarget;
                Collection<IDevice> collection2 = executionTarget2.getRunningDevices();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"executionTarget.runningDevices");
                Collection<IDevice> devices2 = collection2;
                boolean multiDeploy = deployMonitor.notifyExecution(devices2);
                if (devices2.size() > 1 && showMultiDeviceNotification) {
                    NotificationGroupManager.getInstance().getNotificationGroup("Deploy").createNotification("Live Edit works with multi-device deployments but this is not officially supported.", NotificationType.INFORMATION).addAction((AnAction)new BrowseNotificationAction("Learn more", "https://developer.android.com/studio/run#limitations")).notify(this.getProject());
                    showMultiDeviceNotification = false;
                }
                if (multiDeploy && showMultiDeployNotification) {
                    NotificationGroupManager.getInstance().getNotificationGroup("Deploy").createNotification("Live Edit does not work with previous deployments on different devices.", NotificationType.INFORMATION).addAction((AnAction)new BrowseNotificationAction("Learn more", "https://developer.android.com/studio/run#limitations")).notify(this.getProject());
                    showMultiDeployNotification = false;
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Executor getExecutor() {
        return this.executor;
    }

    public final void setExecutor(@NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"<set-?>");
        this.executor = executor2;
    }

    @NotNull
    public final LiveEditAdbEventsListener getAdbEventsListener() {
        return this.adbEventsListener;
    }

    public LiveEditService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Document changed listeners executor", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026d listeners executor\", 1)");
        this(project, executorService, new LiveEditAdbEventsListener());
    }

    @NotNull
    public final LinkedHashMap<String, SourceInlineCandidate> inlineCandidateCache() {
        return this.deployMonitor.getCompiler().getInlineCandidateCache();
    }

    @VisibleForTesting
    @NotNull
    public final LiveEditProjectMonitor getDeployMonitor() {
        return this.deployMonitor;
    }

    @NotNull
    public final Set<IDevice> devices() {
        Set<IDevice> set = this.deployMonitor.devices();
        Intrinsics.checkNotNullExpressionValue(set, (String)"deployMonitor.devices()");
        return set;
    }

    @NotNull
    public final LiveEditStatus editStatus(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        LiveEditStatus liveEditStatus = this.deployMonitor.status(device2);
        Intrinsics.checkNotNullExpressionValue((Object)liveEditStatus, (String)"deployMonitor.status(device)");
        return liveEditStatus;
    }

    public final boolean notifyAppRefresh(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.deployMonitor.notifyAppRefresh(device2);
    }

    public final boolean notifyAppDeploy(@NotNull String packageName2, @NotNull IDevice device2, @NotNull LiveEditApp app, @NotNull Function0<Boolean> isLiveEditable) {
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter(isLiveEditable, (String)"isLiveEditable");
        return this.deployMonitor.notifyAppDeploy(packageName2, device2, app, new Supplier(isLiveEditable){
            private final /* synthetic */ Function0 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object get() {
                return this.function.invoke();
            }
        });
    }

    public final void toggleLiveEdit(@NotNull LiveEditApplicationConfiguration.LiveEditMode oldMode, @NotNull LiveEditApplicationConfiguration.LiveEditMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)oldMode), (String)"oldMode");
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        if (oldMode == newMode) {
            return;
        }
        if (newMode == LiveEditApplicationConfiguration.LiveEditMode.LIVE_EDIT) {
            if (Companion.usesCompose(this.project) && Companion.hasLiveEditSupportedDeviceConnected()) {
                this.deployMonitor.requestRerun();
            }
        } else {
            this.deployMonitor.clearDevices();
        }
    }

    public final void toggleLiveEditMode(@NotNull Companion.LiveEditTriggerMode oldMode, @NotNull Companion.LiveEditTriggerMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)oldMode), (String)"oldMode");
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        if (oldMode == newMode) {
            return;
        }
        if (newMode == Companion.LiveEditTriggerMode.LE_TRIGGER_AUTOMATIC) {
            this.deployMonitor.onManualLETrigger();
        }
    }

    @Trace
    private final void onPsiChanged(EditEvent event2) {
        this.executor.execute(new Runnable(this, event2){
            final /* synthetic */ LiveEditService this$0;
            final /* synthetic */ EditEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
            }

            public final void run() {
                LiveEditService.access$getDeployMonitor$p(this.this$0).onPsiChanged(this.$event);
            }
        });
    }

    public void dispose() {
    }

    public final void triggerLiveEdit() {
        this.deployMonitor.onManualLETrigger();
    }

    public final void notifyLiveEditAvailability(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.notifications.notifyLiveEditAvailability$intellij_android_core(device2);
    }

    @NotNull
    public static final String getPIGGYBACK_ACTION_ID() {
        return Companion.getPIGGYBACK_ACTION_ID();
    }

    @JvmStatic
    public static final boolean isLeTriggerManual() {
        return Companion.isLeTriggerManual();
    }

    @JvmStatic
    @NotNull
    public static final LiveEditService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final boolean usesCompose(@NotNull Project project) {
        return Companion.usesCompose(project);
    }

    public static final /* synthetic */ void access$onPsiChanged(LiveEditService $this, EditEvent event2) {
        $this.onPsiChanged(event2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/editors/literals/LiveEditService$Companion;", "", "()V", "PIGGYBACK_ACTION_ID", "", "getPIGGYBACK_ACTION_ID$annotations", "getPIGGYBACK_ACTION_ID", "()Ljava/lang/String;", "getInstance", "Lcom/android/tools/idea/editors/literals/LiveEditService;", "project", "Lcom/intellij/openapi/project/Project;", "hasLiveEditSupportedDeviceConnected", "", "isLeTriggerManual", "mode", "Lcom/android/tools/idea/editors/literals/LiveEditService$Companion$LiveEditTriggerMode;", "usesCompose", "LiveEditTriggerMode", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nLiveEditService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditService.kt\ncom/android/tools/idea/editors/literals/LiveEditService$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,254:1\n12708#2,2:255\n*S KotlinDebug\n*F\n+ 1 LiveEditService.kt\ncom/android/tools/idea/editors/literals/LiveEditService$Companion\n*L\n184#1:255,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPIGGYBACK_ACTION_ID() {
            return PIGGYBACK_ACTION_ID;
        }

        @JvmStatic
        public static /* synthetic */ void getPIGGYBACK_ACTION_ID$annotations() {
        }

        public final boolean isLeTriggerManual(@NotNull LiveEditTriggerMode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            return mode == LiveEditTriggerMode.LE_TRIGGER_MANUAL;
        }

        @JvmStatic
        public final boolean isLeTriggerManual() {
            return this.isLeTriggerManual(LiveEditApplicationConfiguration.Companion.getInstance().getLeTriggerMode());
        }

        @JvmStatic
        @NotNull
        public final LiveEditService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LiveEditService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(LiveEditService::class.java)");
            return (LiveEditService)object;
        }

        @JvmStatic
        public final boolean usesCompose(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return UtilKt.stream((Object[])ProjectUtil.getModules((Project)project)).anyMatch(new Predicate(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final boolean test(Module it) {
                    AndroidProjectSystem androidProjectSystem = ProjectSystemService.Companion.getInstance(this.$project).getProjectSystem();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return androidProjectSystem.getModuleSystem(it).getUsesCompose();
                }
            });
        }

        public final boolean hasLiveEditSupportedDeviceConnected() {
            boolean bl;
            block1: {
                AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
                Intrinsics.checkNotNull((Object)androidDebugBridge);
                IDevice[] iDeviceArray = androidDebugBridge.getDevices();
                Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"getBridge()!!.devices");
                Object[] $this$any$iv = iDeviceArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    IDevice device2 = (IDevice)element$iv;
                    boolean bl2 = false;
                    if (!LiveEditProjectMonitor.supportLiveEdits(device2)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/editors/literals/LiveEditService$Companion$LiveEditTriggerMode;", "", "(Ljava/lang/String;I)V", "LE_TRIGGER_MANUAL", "LE_TRIGGER_AUTOMATIC", "intellij.android.core"})
        public static final class LiveEditTriggerMode
        extends Enum<LiveEditTriggerMode> {
            public static final /* enum */ LiveEditTriggerMode LE_TRIGGER_MANUAL = new LiveEditTriggerMode();
            public static final /* enum */ LiveEditTriggerMode LE_TRIGGER_AUTOMATIC = new LiveEditTriggerMode();
            private static final /* synthetic */ LiveEditTriggerMode[] $VALUES;

            public static LiveEditTriggerMode[] values() {
                return (LiveEditTriggerMode[])$VALUES.clone();
            }

            public static LiveEditTriggerMode valueOf(String value2) {
                return Enum.valueOf(LiveEditTriggerMode.class, value2);
            }

            static {
                $VALUES = liveEditTriggerModeArray = new LiveEditTriggerMode[]{LiveEditTriggerMode.LE_TRIGGER_MANUAL, LiveEditTriggerMode.LE_TRIGGER_AUTOMATIC};
            }
        }
    }
}

