/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.literals;

import com.android.tools.idea.editors.literals.LiveEditService;
import com.android.tools.idea.editors.liveedit.LiveEditApplicationConfiguration;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveEditAnActionListener
implements AnActionListener {
    private static final String SAVEALL_NO_SHORTCUT_MSG = "[SaveAll shortcut]";

    public void beforeShortcutTriggered(@NotNull Shortcut shortcut, @NotNull List<AnAction> actions2, @NotNull DataContext dataContext) {
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        if (Arrays.asList(LiveEditAnActionListener.getLiveEditTriggerShortCut()).contains(shortcut)) {
            LiveEditAnActionListener.triggerLiveEdit(project);
        }
    }

    public static void triggerLiveEdit(@NotNull Project project) {
        if (!LiveEditApplicationConfiguration.getInstance().isLiveEdit()) {
            return;
        }
        if (!LiveEditService.Companion.isLeTriggerManual()) {
            return;
        }
        LiveEditService.getInstance(project).triggerLiveEdit();
    }

    @Nullable
    private static Shortcut[] getLiveEditTriggerShortCut() {
        AnAction saveAction = ActionManager.getInstance().getAction(LiveEditService.getPIGGYBACK_ACTION_ID());
        if (saveAction == null) {
            return null;
        }
        Shortcut[] shortcuts = saveAction.getShortcutSet().getShortcuts();
        if (shortcuts.length == 0) {
            return new Shortcut[0];
        }
        return shortcuts;
    }

    public static String getLiveEditTriggerShortCutString() {
        Shortcut[] shortcuts = LiveEditAnActionListener.getLiveEditTriggerShortCut();
        if (shortcuts == null || shortcuts.length == 0) {
            return SAVEALL_NO_SHORTCUT_MSG;
        }
        return KeymapUtil.getShortcutText((Shortcut)shortcuts[0]);
    }
}

