/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.fast;

import com.android.tools.idea.concurrency.AndroidExecutors;
import com.android.tools.idea.editors.fast.EmbeddedCompilerClientImpl;
import com.android.tools.idea.editors.fast.NonRetriableException;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.descriptors.InvalidModuleException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0003\n\u0000\u001a5\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\nH\u0007\u00a2\u0006\u0002\u0010\u000b\u001a\u000e\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u000eH\u0002\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"defaultRetryTimes", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "retryInNonBlockingReadAction", "T", "retryTimes", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "retryBlock", "Lkotlin/Function0;", "(ILcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isCompilationError", "", "", "intellij.android.core"})
public final class EmbeddedCompilerClientImplKt {
    private static final Integer defaultRetryTimes = Integer.getInteger("fast.preview.224875189.retries", 3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCompilationError(Throwable $this$isCompilationError) {
        boolean bl;
        if (!($this$isCompilationError instanceof LiveEditUpdateException)) return false;
        switch (WhenMappings.$EnumSwitchMapping$0[((LiveEditUpdateException)$this$isCompilationError).getError().ordinal()]) {
            case 1: {
                String string = $this$isCompilationError.getMessage();
                if (string == null) return false;
                bl = StringsKt.startsWith$default((String)string, (String)"Analyze Error.", (boolean)false, (int)2, null);
                break;
            }
            case 2: {
                return true;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return false;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    @VisibleForTesting
    public static final <T> T retryInNonBlockingReadAction(int retryTimes, @NotNull ProgressIndicator indicator, @NotNull Function0<? extends T> retryBlock) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(retryBlock, (String)"retryBlock");
        Ref.ObjectRef lastException = new Ref.ObjectRef();
        CompletableDeferred result2 = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        for (int i = 0; i < retryTimes; ++i) {
            int retryAttempt = i;
            boolean bl = false;
            indicator.checkCanceled();
            try {
                ReadAction.nonBlocking((Callable)new Callable((Ref.ObjectRef<Throwable>)lastException, result2, retryBlock){
                    final /* synthetic */ Ref.ObjectRef<Throwable> $lastException;
                    final /* synthetic */ CompletableDeferred<T> $result;
                    final /* synthetic */ Function0<T> $retryBlock;
                    {
                        this.$lastException = $lastException;
                        this.$result = $result;
                        this.$retryBlock = $retryBlock;
                    }

                    public final void call() {
                        try {
                            this.$lastException.element = null;
                            this.$result.complete(this.$retryBlock.invoke());
                        }
                        catch (ProcessCanceledException t) {
                            throw t;
                        }
                        catch (Throwable t) {
                            this.$lastException.element = t instanceof ExecutionException ? t.getCause() : t;
                        }
                    }
                }).wrapProgress(indicator).submit(AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor()).get();
            }
            catch (ProcessCanceledException t) {
                Object object = lastException.element = t.getCause() instanceof InvalidModuleException ? t.getCause() : (Throwable)new NonRetriableException(t);
            }
            if (result2.isCompleted()) {
                return (T)result2.getCompleted();
            }
            if ((Throwable)lastException.element != null) {
                Throwable it;
                boolean bl2 = false;
                Throwable throwable = it instanceof NonRetriableException ? (NonRetriableException)it : null;
                if (throwable != null && (throwable = throwable.getCause()) != null) {
                    Throwable nonRetriableException = throwable;
                    boolean bl3 = false;
                    throw nonRetriableException;
                }
                Logger.getInstance(EmbeddedCompilerClientImpl.class).debug("Retrying after error (retry " + retryAttempt + ")", it);
            }
            indicator.checkCanceled();
            Thread.sleep(RangesKt.coerceAtMost((int)(50 * retryAttempt), (int)200));
        }
        Throwable throwable = (Throwable)lastException.element;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Logger.getInstance(EmbeddedCompilerClientImpl.class).warn("Compile request failed with exception", it);
            throw it;
        }
        throw new ProcessCanceledException();
    }

    public static /* synthetic */ Object retryInNonBlockingReadAction$default(int n, ProgressIndicator progressIndicator, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            Integer n3 = defaultRetryTimes;
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"defaultRetryTimes");
            n = ((Number)n3).intValue();
        }
        if ((n2 & 2) != 0) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        return EmbeddedCompilerClientImplKt.retryInNonBlockingReadAction(n, progressIndicator, function0);
    }

    public static final /* synthetic */ boolean access$isCompilationError(Throwable $receiver) {
        return EmbeddedCompilerClientImplKt.isCompilationError($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LiveEditUpdateException.Error.values().length];
            try {
                nArray[LiveEditUpdateException.Error.ANALYSIS_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.COMPILATION_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.UNABLE_TO_INLINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.NON_KOTLIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.NON_PRIVATE_INLINE_FUNCTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.INTERNAL_ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.UNABLE_TO_LOCATE_COMPOSE_GROUP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.UNSUPPORTED_SRC_CHANGE_RECOVERABLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.UNSUPPORTED_SRC_CHANGE_UNRECOVERABLE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.UNSUPPORTED_BUILD_SRC_CHANGE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.UNSUPPORTED_TEST_SRC_CHANGE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.UNABLE_TO_DESUGAR.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiveEditUpdateException.Error.KNOWN_ISSUE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

