/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.build;

import com.android.tools.idea.editors.build.CodePsiTreeChangeAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0014\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u000bH\u0007J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u000bH\u0002R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/editors/build/PsiCodeFileChangeDetectorService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "(Lcom/intellij/psi/PsiManager;)V", "_fileUpdatesFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/intellij/psi/PsiFile;", "fileUpdatesFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getFileUpdatesFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "outOfDateFiles", "getOutOfDateFiles", "()Ljava/util/Set;", "dispose", "", "markAllAsUpToDate", "markAsUpToDate", "files", "", "markFileAsOutOfDate", "file", "onCodeChange", "Companion", "intellij.android.core"})
public final class PsiCodeFileChangeDetectorService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isDisposed;
    @NotNull
    private final MutableStateFlow<Set<PsiFile>> _fileUpdatesFlow;

    private PsiCodeFileChangeDetectorService(PsiManager psiManager) {
        this.isDisposed = new AtomicBoolean(false);
        this._fileUpdatesFlow = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new CodePsiTreeChangeAdapter((Function1<? super PsiFile, Boolean>)((Function1)new Function1<PsiFile, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull PsiFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !((Set)this.getFileUpdatesFlow().getValue()).contains(it);
            }
        }), (Function1<? super PsiFile, Unit>)((Function1)new Function1<PsiFile, Unit>((Object)this){

            public final void invoke(@NotNull PsiFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((PsiCodeFileChangeDetectorService)this.receiver).onCodeChange(p0);
            }
        })), (Disposable)this);
    }

    @NotNull
    public final StateFlow<Set<PsiFile>> getFileUpdatesFlow() {
        return (StateFlow)this._fileUpdatesFlow;
    }

    @NotNull
    public final Set<PsiFile> getOutOfDateFiles() {
        return (Set)this.getFileUpdatesFlow().getValue();
    }

    public PsiCodeFileChangeDetectorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(project)");
        this(psiManager);
    }

    private final void onCodeChange(PsiFile file2) {
        if (this.isDisposed.get()) {
            return;
        }
        MutableStateFlow<Set<PsiFile>> mutableStateFlow = this._fileUpdatesFlow;
        mutableStateFlow.setValue((Object)SetsKt.plus((Set)((Set)mutableStateFlow.getValue()), (Object)file2));
    }

    private final void markAllAsUpToDate() {
        this._fileUpdatesFlow.setValue((Object)SetsKt.emptySet());
    }

    public final void markAsUpToDate(@NotNull Collection<? extends PsiFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        MutableStateFlow<Set<PsiFile>> mutableStateFlow = this._fileUpdatesFlow;
        mutableStateFlow.setValue((Object)SetsKt.minus((Set)((Set)mutableStateFlow.getValue()), (Iterable)files2));
    }

    @TestOnly
    public final void markFileAsOutOfDate(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.onCodeChange(file2);
    }

    public void dispose() {
        this.isDisposed.set(true);
        this.markAllAsUpToDate();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/editors/build/PsiCodeFileChangeDetectorService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/editors/build/PsiCodeFileChangeDetectorService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PsiCodeFileChangeDetectorService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(PsiCodeFileChangeDetectorService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(PsiCo\u2026ectorService::class.java)");
            return (PsiCodeFileChangeDetectorService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

