/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFakeFileSystem
extends DummyFileSystem {
    @NonNls
    public static final String PROTOCOL = "android-dummy";
    public static final VirtualFileSystem INSTANCE = new AndroidFakeFileSystem();
    public static final char SEPARATOR = '/';

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull String path2) {
        Module m;
        List components = Splitter.on((char)'/').splitToList((CharSequence)path2);
        int size = components.size();
        if (size < 3) {
            return null;
        }
        String projectPath = Joiner.on((char)'/').join(components.subList(0, size - 2));
        String moduleName2 = (String)components.get(size - 2);
        String fileName = (String)components.get(size - 1);
        Project project = AndroidFakeFileSystem.findProject(projectPath);
        if (project == null) {
            return null;
        }
        if ("Translations Editor".equals(fileName) && (m = AndroidFakeFileSystem.findModule(project, moduleName2)) != null) {
            return StringsVirtualFile.getStringsVirtualFile(m);
        }
        return null;
    }

    @NotNull
    public static String constructPathForFile(@NotNull String fileName, @NotNull Module module2) {
        return Joiner.on((char)'/').join((Object)module2.getProject().getBasePath(), (Object)module2.getName(), new Object[]{fileName});
    }

    @NotNull
    public static String constructPathForFile(@NotNull String fileName, @NotNull Project project) {
        return Joiner.on((char)'/').join((Object)project.getBasePath(), (Object)"", new Object[]{fileName});
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String name2) {
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            if (!m.getName().equals(name2)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    private static Project findProject(@NotNull String basePath) {
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!basePath.equals(p.getBasePath())) continue;
            return p;
        }
        return null;
    }
}

