/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.report;

import com.android.tools.idea.actions.SendFeedbackAction;
import com.android.tools.idea.diagnostics.report.DiagnosticsSummaryFileProvider;
import com.android.tools.idea.diagnostics.report.FileInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/diagnostics/report/SystemInfoFileProvider;", "Lcom/android/tools/idea/diagnostics/report/DiagnosticsSummaryFileProvider;", "()V", "name", "", "getName", "()Ljava/lang/String;", "getFiles", "", "Lcom/android/tools/idea/diagnostics/report/FileInfo;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
public final class SystemInfoFileProvider
implements DiagnosticsSummaryFileProvider {
    @NotNull
    public static final SystemInfoFileProvider INSTANCE = new SystemInfoFileProvider();
    @NotNull
    private static final String name = "System Info";

    private SystemInfoFileProvider() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public List<FileInfo> getFiles(@Nullable Project project) {
        String string = PathManager.getLogPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogPath()");
        Path dir = DiagnosticsSummaryFileProvider.Companion.getDiagnosticsDirectoryPath(string);
        Path path2 = dir.resolve("SystemInfo.log");
        File file2 = path2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"path.toFile()");
        String string2 = SendFeedbackAction.getDescription(project);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(project)");
        FilesKt.writeText$default((File)file2, (String)string2, null, (int)2, null);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        Path path3 = Paths.get("SystemInfo.log", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(FILE_NAME)");
        return CollectionsKt.listOf((Object)new FileInfo(path2, path3));
    }
}

