/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.reports;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.diagnostics.jfr.CallTreeAggregator;
import com.android.tools.idea.diagnostics.jfr.EventFilter;
import com.android.tools.idea.diagnostics.jfr.JfrReportGenerator;
import com.android.tools.idea.diagnostics.jfr.JfrReportManager;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.JfrTypingLatencyConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0019\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0019\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports;", "", "()V", "CALL_TREES_FIELD", "", "DEFAULT_COOLDOWN_TIMEOUT", "Lkotlin/time/Duration;", "J", "DEFAULT_LATENCY_THRESHOLD", "DEFAULT_MAX_REPORTING_LENGTH_BYTES", "", "DEFAULT_SESSION_TIMEOUT", "DEFAULT_TYPING_TIMEOUT", "FIELDS", "", "getFIELDS", "()Ljava/util/List;", "KEYSTROKE_COUNT_FIELD", "REPORT_TYPE", "SERVER_FLAG_NAME", "createReportManager", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportManager;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "serverFlagService", "Lcom/android/tools/idea/serverflags/ServerFlagService;", "MyLatencyListener", "MyReportGenerator", "intellij.android.core"})
public final class JfrTypingLatencyReports {
    @NotNull
    public static final JfrTypingLatencyReports INSTANCE = new JfrTypingLatencyReports();
    @NotNull
    private static final String SERVER_FLAG_NAME = "diagnostics/jfr_typing_latency";
    private static final int DEFAULT_MAX_REPORTING_LENGTH_BYTES = 200000;
    @NotNull
    private static final String CALL_TREES_FIELD = "callTrees";
    @NotNull
    private static final String KEYSTROKE_COUNT_FIELD = "keystrokes";
    private static final long DEFAULT_TYPING_TIMEOUT = DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS);
    private static final long DEFAULT_SESSION_TIMEOUT = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
    private static final long DEFAULT_COOLDOWN_TIMEOUT = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
    private static final long DEFAULT_LATENCY_THRESHOLD = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
    @NotNull
    public static final String REPORT_TYPE = "JFR-TypingLatency";
    @NotNull
    private static final List<String> FIELDS;

    private JfrTypingLatencyReports() {
    }

    @NotNull
    public final List<String> getFIELDS() {
        return FIELDS;
    }

    @JvmStatic
    @NotNull
    public static final JfrReportManager<?> createReportManager(@NotNull Disposable parentDisposable, @NotNull ServerFlagService serverFlagService) {
        JfrTypingLatencyConfig config2;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)serverFlagService, (String)"serverFlagService");
        JfrTypingLatencyConfig jfrTypingLatencyConfig = config2 = (JfrTypingLatencyConfig)serverFlagService.getProtoOrNull(SERVER_FLAG_NAME, (Message)JfrTypingLatencyConfig.getDefaultInstance());
        int maxReportLengthBytes = (jfrTypingLatencyConfig != null ? jfrTypingLatencyConfig.hasMaxReportLengthBytes() : false) ? config2.getMaxReportLengthBytes() : 200000;
        return JfrReportManager.Companion.create$default(JfrReportManager.Companion, (Function0)new Function0<MyReportGenerator>(maxReportLengthBytes){
            final /* synthetic */ int $maxReportLengthBytes;
            {
                this.$maxReportLengthBytes = $maxReportLengthBytes;
                super(0);
            }

            @NotNull
            public final MyReportGenerator invoke() {
                return new MyReportGenerator(this.$maxReportLengthBytes);
            }
        }, null, (Function1)new Function1<JfrReportManager<MyReportGenerator>, Unit>(parentDisposable, config2){
            final /* synthetic */ Disposable $parentDisposable;
            final /* synthetic */ JfrTypingLatencyConfig $config;
            {
                this.$parentDisposable = $parentDisposable;
                this.$config = $config;
                super(1);
            }

            public final void invoke(@NotNull JfrReportManager<MyReportGenerator> $this$create) {
                Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                Function1 stopCapture2 = (Function1)new Function1<Integer, Unit>($this$create){
                    final /* synthetic */ JfrReportManager<MyReportGenerator> $this_create;
                    {
                        this.$this_create = $this_create;
                        super(1);
                    }

                    public final void invoke(int keystrokes) {
                        MyReportGenerator myReportGenerator = this.$this_create.getCurrentReportGenerator();
                        if (myReportGenerator != null) {
                            myReportGenerator.setKeystrokeCount(keystrokes);
                        }
                        this.$this_create.stopCapture();
                    }
                };
                CoroutineScope coroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope((Disposable)this.$parentDisposable, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()));
                MyLatencyListener latencyListener2 = new MyLatencyListener(this.$config, (Function0<Unit>)((Function0)new Function0<Unit>($this$create){

                    public final void invoke() {
                        ((JfrReportManager)this.receiver).startCapture();
                    }
                }), (Function1<? super Integer, Unit>)stopCapture2, coroutineScope);
                MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(this.$parentDisposable);
                Topic topic = LatencyListener.TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                messageBusConnection.subscribe(topic, (Object)latencyListener2);
            }
        }, 2, null);
    }

    static {
        Object[] objectArray = new String[]{CALL_TREES_FIELD, KEYSTROKE_COUNT_FIELD};
        FIELDS = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001:\u0002+,BH\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001c\u001a\u00020\u0006H\u0007J\b\u0010\u001d\u001a\u00020\u0006H\u0003J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0019H\u0003J\"\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0019H\u0003J\u001c\u0010(\u001a\u00020\u0011*\u00020\u0019H\u0002\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010*R\u0019\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0019\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001b\u001a\u00020\u0011X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0012\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener;", "Lcom/intellij/openapi/editor/actionSystem/LatencyListener;", "config", "Lcom/android/tools/idea/serverflags/protos/JfrTypingLatencyConfig;", "startCapture", "Lkotlin/Function0;", "", "stopCapture", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "keystrokeCount", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/android/tools/idea/serverflags/protos/JfrTypingLatencyConfig;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlinx/coroutines/CoroutineScope;)V", "cooldownTimeout", "Lkotlin/time/Duration;", "J", "latencyReportingThreshold", "sessionTimeout", "state", "Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$State;", "timeouts", "", "Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$TimeoutType;", "Lkotlinx/coroutines/Job;", "typingTimeout", "cancelAllTimeouts", "doStopRecording", "handleTimeout", "timeoutType", "recordTypingLatency", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "", "latencyMs", "", "startTimeout", "timeout", "timeout-5sfh64U", "(Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$TimeoutType;)J", "State", "TimeoutType", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nJfrTypingLatencyReports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrTypingLatencyReports.kt\ncom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1851#2,2:217\n*S KotlinDebug\n*F\n+ 1 JfrTypingLatencyReports.kt\ncom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener\n*L\n201#1:217,2\n*E\n"})
    public static final class MyLatencyListener
    implements LatencyListener {
        @NotNull
        private final Function0<Unit> startCapture;
        @NotNull
        private final Function1<Integer, Unit> stopCapture;
        @NotNull
        private final CoroutineScope coroutineScope;
        private final long typingTimeout;
        private final long sessionTimeout;
        private final long cooldownTimeout;
        private final long latencyReportingThreshold;
        @NotNull
        private State state;
        private int keystrokeCount;
        @NotNull
        private final Map<TimeoutType, Job> timeouts;

        public MyLatencyListener(@Nullable JfrTypingLatencyConfig config2, @NotNull Function0<Unit> startCapture2, @NotNull Function1<? super Integer, Unit> stopCapture2, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter(startCapture2, (String)"startCapture");
            Intrinsics.checkNotNullParameter(stopCapture2, (String)"stopCapture");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.startCapture = startCapture2;
            this.stopCapture = stopCapture2;
            this.coroutineScope = coroutineScope;
            JfrTypingLatencyConfig jfrTypingLatencyConfig = config2;
            this.typingTimeout = (jfrTypingLatencyConfig != null ? jfrTypingLatencyConfig.hasTypingTimeoutMillis() : false) ? DurationKt.toDuration((long)config2.getTypingTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_TYPING_TIMEOUT;
            JfrTypingLatencyConfig jfrTypingLatencyConfig2 = config2;
            this.sessionTimeout = (jfrTypingLatencyConfig2 != null ? jfrTypingLatencyConfig2.hasSessionTimeoutMillis() : false) ? DurationKt.toDuration((long)config2.getSessionTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_SESSION_TIMEOUT;
            JfrTypingLatencyConfig jfrTypingLatencyConfig3 = config2;
            this.cooldownTimeout = (jfrTypingLatencyConfig3 != null ? jfrTypingLatencyConfig3.hasCooldownTimeoutMillis() : false) ? DurationKt.toDuration((long)config2.getCooldownTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_COOLDOWN_TIMEOUT;
            JfrTypingLatencyConfig jfrTypingLatencyConfig4 = config2;
            this.latencyReportingThreshold = (jfrTypingLatencyConfig4 != null ? jfrTypingLatencyConfig4.hasLatencyReportingThresholdMillis() : false) ? DurationKt.toDuration((long)config2.getLatencyReportingThresholdMillis(), (DurationUnit)DurationUnit.MILLISECONDS) : DEFAULT_LATENCY_THRESHOLD;
            this.state = State.WAITING_TO_RECORD;
            this.timeouts = new LinkedHashMap();
        }

        private final long timeout-5sfh64U(TimeoutType $this$timeout_u2d5sfh64U) {
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$timeout_u2d5sfh64U.ordinal()]) {
                case 1 -> this.typingTimeout;
                case 2 -> this.sessionTimeout;
                case 3 -> this.cooldownTimeout;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @UiThread
        public void recordTypingLatency(@NotNull Editor editor, @Nullable String action2, long latencyMs) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            switch (WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
                case 1: {
                    if (Duration.compareTo-LRDsOJo((long)DurationKt.toDuration((long)latencyMs, (DurationUnit)DurationUnit.MILLISECONDS), (long)this.latencyReportingThreshold) <= 0) break;
                    this.keystrokeCount = 1;
                    this.cancelAllTimeouts();
                    this.startTimeout(TimeoutType.TYPING);
                    this.startTimeout(TimeoutType.SESSION);
                    this.startCapture.invoke();
                    this.state = State.RECORDING;
                    break;
                }
                case 2: {
                    if (Duration.compareTo-LRDsOJo((long)DurationKt.toDuration((long)latencyMs, (DurationUnit)DurationUnit.MILLISECONDS), (long)this.latencyReportingThreshold) > 0) {
                        int n = this.keystrokeCount;
                        this.keystrokeCount = n + 1;
                        this.startTimeout(TimeoutType.TYPING);
                        break;
                    }
                    this.doStopRecording();
                }
            }
        }

        @UiThread
        private final void startTimeout(TimeoutType timeoutType) {
            Job job2 = this.timeouts.remove((Object)timeoutType);
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.timeouts.put(timeoutType, BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, timeoutType, null){
                int label;
                final /* synthetic */ MyLatencyListener this$0;
                final /* synthetic */ TimeoutType $timeoutType;
                {
                    this.this$0 = $receiver;
                    this.$timeoutType = $timeoutType;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)MyLatencyListener.access$timeout-5sfh64U(this.this$0, this.$timeoutType), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            MyLatencyListener.access$handleTimeout(this.this$0, this.$timeoutType);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null));
        }

        @UiThread
        private final void handleTimeout(TimeoutType timeoutType) {
            switch (WhenMappings.$EnumSwitchMapping$0[timeoutType.ordinal()]) {
                case 1: 
                case 2: {
                    if (this.state != State.RECORDING) break;
                    this.doStopRecording();
                    break;
                }
                case 3: {
                    if (this.state != State.COOLDOWN) break;
                    this.cancelAllTimeouts();
                    this.state = State.WAITING_TO_RECORD;
                }
            }
        }

        @UiThread
        public final void cancelAllTimeouts() {
            Iterable $this$forEach$iv = this.timeouts.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Job it = (Job)element$iv;
                boolean bl = false;
                Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
            }
            this.timeouts.clear();
        }

        @UiThread
        private final void doStopRecording() {
            this.stopCapture.invoke((Object)this.keystrokeCount);
            this.keystrokeCount = 0;
            this.cancelAllTimeouts();
            this.startTimeout(TimeoutType.COOLDOWN);
            this.state = State.COOLDOWN;
        }

        public static final /* synthetic */ long access$timeout-5sfh64U(MyLatencyListener $this, TimeoutType $receiver) {
            return $this.timeout-5sfh64U($receiver);
        }

        public static final /* synthetic */ void access$handleTimeout(MyLatencyListener $this, TimeoutType timeoutType) {
            $this.handleTimeout(timeoutType);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$State;", "", "(Ljava/lang/String;I)V", "WAITING_TO_RECORD", "RECORDING", "COOLDOWN", "intellij.android.core"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State WAITING_TO_RECORD = new State();
            public static final /* enum */ State RECORDING = new State();
            public static final /* enum */ State COOLDOWN = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value2) {
                return Enum.valueOf(State.class, value2);
            }

            static {
                $VALUES = stateArray = new State[]{State.WAITING_TO_RECORD, State.RECORDING, State.COOLDOWN};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyLatencyListener$TimeoutType;", "", "(Ljava/lang/String;I)V", "TYPING", "SESSION", "COOLDOWN", "intellij.android.core"})
        private static final class TimeoutType
        extends Enum<TimeoutType> {
            public static final /* enum */ TimeoutType TYPING = new TimeoutType();
            public static final /* enum */ TimeoutType SESSION = new TimeoutType();
            public static final /* enum */ TimeoutType COOLDOWN = new TimeoutType();
            private static final /* synthetic */ TimeoutType[] $VALUES;

            public static TimeoutType[] values() {
                return (TimeoutType[])$VALUES.clone();
            }

            public static TimeoutType valueOf(String value2) {
                return Enum.valueOf(TimeoutType.class, value2);
            }

            static {
                $VALUES = timeoutTypeArray = new TimeoutType[]{TimeoutType.TYPING, TimeoutType.SESSION, TimeoutType.COOLDOWN};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[TimeoutType.values().length];
                try {
                    nArray[TimeoutType.TYPING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TimeoutType.SESSION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TimeoutType.COOLDOWN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[State.values().length];
                try {
                    nArray[State.WAITING_TO_RECORD.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.RECORDING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.COOLDOWN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0001H\u0016J\u0014\u0010\u0011\u001a\u00020\f2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0001H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrTypingLatencyReports$MyReportGenerator;", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;", "maxReportLengthBytes", "", "(I)V", "callTreeAggregator", "Lcom/android/tools/idea/diagnostics/jfr/CallTreeAggregator;", "keystrokeCount", "getKeystrokeCount", "()I", "setKeystrokeCount", "accept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "c", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture;", "captureCompleted", "generateReport", "", "", "intellij.android.core"})
    private static final class MyReportGenerator
    extends JfrReportGenerator {
        private final int maxReportLengthBytes;
        private int keystrokeCount;
        @NotNull
        private final CallTreeAggregator callTreeAggregator;

        public MyReportGenerator(int maxReportLengthBytes) {
            super(JfrTypingLatencyReports.REPORT_TYPE, EventFilter.Companion.getCPU_SAMPLES(), 0L, 0L, null, 28, null);
            this.maxReportLengthBytes = maxReportLengthBytes;
            this.keystrokeCount = -1;
            this.callTreeAggregator = new CallTreeAggregator(CallTreeAggregator.Companion.getTHREAD_FILTER_ALL());
        }

        public final int getKeystrokeCount() {
            return this.keystrokeCount;
        }

        public final void setKeystrokeCount(int n) {
            this.keystrokeCount = n;
        }

        @Override
        public void accept(@NotNull RecordedEvent e, @NotNull JfrReportGenerator.Capture c) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            this.callTreeAggregator.accept(e);
        }

        @Override
        public void captureCompleted(@NotNull JfrReportGenerator.Capture c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Instant instant = c.getEnd();
            Intrinsics.checkNotNull((Object)instant);
            this.callTreeAggregator.processBatch(instant);
        }

        @Override
        @NotNull
        public Map<String, String> generateReport() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JfrTypingLatencyReports.CALL_TREES_FIELD, (Object)this.callTreeAggregator.generateReport(this.maxReportLengthBytes)), TuplesKt.to((Object)JfrTypingLatencyReports.KEYSTROKE_COUNT_FIELD, (Object)String.valueOf(this.keystrokeCount))};
            return MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

