/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.reports;

import com.android.tools.idea.diagnostics.jfr.CallTreeAggregator;
import com.android.tools.idea.diagnostics.jfr.EventFilter;
import com.android.tools.idea.diagnostics.jfr.JfrReportGenerator;
import com.android.tools.idea.diagnostics.jfr.JfrReportManager;
import com.android.tools.idea.diagnostics.jfr.reports.JfrFreezeReports;
import com.android.tools.idea.diagnostics.report.FreezeReport;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrFreezeReports;", "", "()V", "CALL_TREES_FIELD", "", "EMPTY_ANR_STACKTRACE", "EXCEPTION_TYPE", "FIELDS", "", "getFIELDS", "()Ljava/util/List;", "REPORT_TYPE", "createFreezeReportManager", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportManager;", "Lcom/android/tools/idea/diagnostics/jfr/reports/JfrFreezeReports$JfrFreezeReportGenerator;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "JfrFreezeReportGenerator", "intellij.android.core"})
public final class JfrFreezeReports {
    @NotNull
    public static final JfrFreezeReports INSTANCE = new JfrFreezeReports();
    @NotNull
    private static final String CALL_TREES_FIELD = "callTrees";
    @NotNull
    private static final String EXCEPTION_TYPE = "com.android.ApplicationNotResponding";
    @NotNull
    private static final String EMPTY_ANR_STACKTRACE = "com.android.ApplicationNotResponding: \n\tat " + FreezeReport.class.getName() + ".missingEdtStack(Unknown source)";
    @NotNull
    public static final String REPORT_TYPE = "JFR-Freeze";
    @NotNull
    private static final List<String> FIELDS;

    private JfrFreezeReports() {
    }

    @NotNull
    public final List<String> getFIELDS() {
        return FIELDS;
    }

    @NotNull
    public final JfrReportManager<JfrFreezeReportGenerator> createFreezeReportManager(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return JfrReportManager.Companion.create(createFreezeReportManager.1.INSTANCE, null, (Function1)new Function1<JfrReportManager<JfrFreezeReportGenerator>, Unit>(parentDisposable){
            final /* synthetic */ Disposable $parentDisposable;
            {
                this.$parentDisposable = $parentDisposable;
                super(1);
            }

            public final void invoke(@NotNull JfrReportManager<JfrFreezeReportGenerator> $this$create) {
                Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                IdePerformanceListener listener2 = new IdePerformanceListener($this$create){
                    final /* synthetic */ JfrReportManager<JfrFreezeReportGenerator> $this_create;
                    {
                        this.$this_create = $this_create;
                    }

                    public void uiFreezeStarted() {
                        this.$this_create.startCapture();
                        JfrFreezeReportGenerator jfrFreezeReportGenerator = this.$this_create.getCurrentReportGenerator();
                        Intrinsics.checkNotNull((Object)jfrFreezeReportGenerator);
                        String string = ThreadDumper.getEdtStackForCrash((String)ThreadDumper.dumpThreadsToString(), (String)"com.android.ApplicationNotResponding");
                        if (string == null) {
                            string = JfrFreezeReports.access$getEMPTY_ANR_STACKTRACE$p();
                        }
                        jfrFreezeReportGenerator.setEdtStackForCrash(string);
                    }

                    public void uiFreezeFinished(long durationMs, @Nullable File reportDir) {
                        this.$this_create.stopCapture();
                    }
                };
                MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(this.$parentDisposable);
                Topic topic = IdePerformanceListener.TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                messageBusConnection.subscribe(topic, (Object)listener2);
            }
        });
    }

    public static final /* synthetic */ String access$getEMPTY_ANR_STACKTRACE$p() {
        return EMPTY_ANR_STACKTRACE;
    }

    static {
        Object[] objectArray = new String[]{CALL_TREES_FIELD, "exception_info"};
        FIELDS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0001H\u0016J\u0014\u0010\u0011\u001a\u00020\f2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0001H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/JfrFreezeReports$JfrFreezeReportGenerator;", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;", "()V", "callTreeAggregator", "Lcom/android/tools/idea/diagnostics/jfr/CallTreeAggregator;", "edtStackForCrash", "", "getEdtStackForCrash", "()Ljava/lang/String;", "setEdtStackForCrash", "(Ljava/lang/String;)V", "accept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "c", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture;", "captureCompleted", "generateReport", "", "intellij.android.core"})
    public static final class JfrFreezeReportGenerator
    extends JfrReportGenerator {
        @NotNull
        private final CallTreeAggregator callTreeAggregator = new CallTreeAggregator(CallTreeAggregator.Companion.getTHREAD_FILTER_ALL());
        @NotNull
        private String edtStackForCrash = JfrFreezeReports.access$getEMPTY_ANR_STACKTRACE$p();

        public JfrFreezeReportGenerator() {
            super(JfrFreezeReports.REPORT_TYPE, EventFilter.Companion.getCPU_SAMPLES(), -((long)Registry.intValue((String)"performance.watcher.unresponsive.interval.ms", (int)0)), 0L, null, 24, null);
        }

        @NotNull
        public final String getEdtStackForCrash() {
            return this.edtStackForCrash;
        }

        public final void setEdtStackForCrash(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.edtStackForCrash = string;
        }

        @Override
        public void accept(@NotNull RecordedEvent e, @NotNull JfrReportGenerator.Capture c) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            this.callTreeAggregator.accept(e);
        }

        @Override
        public void captureCompleted(@NotNull JfrReportGenerator.Capture c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Instant instant = c.getEnd();
            Intrinsics.checkNotNull((Object)instant);
            this.callTreeAggregator.processBatch(instant);
        }

        @Override
        @NotNull
        public Map<String, String> generateReport() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JfrFreezeReports.CALL_TREES_FIELD, (Object)this.callTreeAggregator.generateReport(200000)), TuplesKt.to((Object)"exception_info", (Object)this.edtStackForCrash)};
            return MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

