/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.analysis;

import com.android.tools.idea.diagnostics.jfr.analysis.CallTree;
import com.android.tools.idea.diagnostics.jfr.analysis.Sample;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/Freeze;", "", "startTime", "", "endTime", "(JJ)V", "getEndTime", "()J", "samples", "", "", "Lcom/android/tools/idea/diagnostics/jfr/analysis/Sample;", "getSamples", "()Ljava/util/Map;", "getStartTime", "aggregateCallTrees", "Lcom/android/tools/idea/diagnostics/jfr/analysis/CallTree;", "containsInstant", "", "i", "Ljava/time/Instant;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nJfrAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrAnalyzer.kt\ncom/android/tools/idea/diagnostics/jfr/analysis/Freeze\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n211#2:117\n212#2:120\n1851#3,2:118\n*S KotlinDebug\n*F\n+ 1 JfrAnalyzer.kt\ncom/android/tools/idea/diagnostics/jfr/analysis/Freeze\n*L\n35#1:117\n35#1:120\n37#1:118,2\n*E\n"})
final class Freeze {
    private final long startTime;
    private final long endTime;
    @NotNull
    private final Map<Long, List<Sample>> samples;

    public Freeze(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.samples = new LinkedHashMap();
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    @NotNull
    public final Map<Long, List<Sample>> getSamples() {
        return this.samples;
    }

    public final boolean containsInstant(@NotNull Instant i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        long l = this.startTime;
        long l2 = this.endTime;
        long l3 = i.toEpochMilli();
        return l <= l3 ? l3 < l2 : false;
    }

    @NotNull
    public final Map<Long, CallTree> aggregateCallTrees() {
        Map trees = new LinkedHashMap();
        Map<Long, List<Sample>> $this$forEach$iv = this.samples;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, List<Sample>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, List<Sample>> element$iv;
            Map.Entry<Long, List<Sample>> entry = element$iv = iterator2.next();
            boolean bl = false;
            long tid = ((Number)entry.getKey()).longValue();
            List<Sample> sampleList = entry.getValue();
            CallTree root = new CallTree("");
            Iterable $this$forEach$iv2 = sampleList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Sample sample = (Sample)element$iv2;
                boolean bl2 = false;
                if (sample.getTruncated()) {
                    int n = root.getTruncatedSampleCount();
                    root.setTruncatedSampleCount(n + 1);
                    continue;
                }
                root.addStacktrace(sample.getStackTrace(), sample.getDuration());
            }
            root.sort();
            Long l = tid;
            trees.put(l, root);
        }
        return trees;
    }
}

