/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr;

import com.android.annotations.concurrency.Slow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import jdk.jfr.Recording;

public class RecordingBuffer {
    private static final Logger LOG = Logger.getInstance(RecordingBuffer.class);
    private Recording[] recordings = new Recording[2];
    private int latest = 0;

    public Recording swapBuffers() {
        if (this.recordings[this.latest] != null) {
            this.recordings[this.latest].stop();
        }
        this.latest = 1 - this.latest;
        Recording oldRecording = this.recordings[this.latest];
        this.createAndStartRecording();
        return oldRecording;
    }

    private void createAndStartRecording() {
        this.recordings[this.latest] = new Recording();
        this.recordings[this.latest].enable("jdk.ExecutionSample").withPeriod(Duration.ofMillis(20L));
        this.recordings[this.latest].enable("jdk.NativeMethodSample").withPeriod(Duration.ofMillis(20L));
        this.recordings[this.latest].enable("jdk.GCPhasePause");
        this.recordings[this.latest].enable("jdk.GCHeapSummary");
        this.recordings[this.latest].setToDisk(true);
        this.recordings[this.latest].start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public Path dumpJfrTo(Path directory) {
        block19: {
            if (this.recordings[this.latest] != null) {
                File dumpDir = null;
                try {
                    dumpDir = FileUtil.createTempDirectory((String)"studio_jfr_recordings", null);
                    ArrayList<File> recordingFiles = new ArrayList<File>();
                    if (this.recordings[1 - this.latest] != null) {
                        recordingFiles.addAll(this.dumpRecording(1 - this.latest, dumpDir, "0.jfr"));
                    }
                    recordingFiles.addAll(this.dumpRecording(this.latest, dumpDir, recordingFiles.size() + ".jfr"));
                    if (recordingFiles.size() == 1) {
                        Files.move(((File)recordingFiles.get(0)).toPath(), new File(directory.toFile(), "recording.jfr").toPath(), StandardCopyOption.REPLACE_EXISTING);
                        break block19;
                    }
                    if (recordingFiles.size() <= 1) break block19;
                    File concatenatedRecordings = new File(directory.toFile(), "recording.jfr");
                    try (FileOutputStream fos = new FileOutputStream(concatenatedRecordings);){
                        for (File jfrFile : recordingFiles) {
                            Files.copy(jfrFile.toPath(), fos);
                        }
                    }
                    catch (IOException e) {
                        FileUtil.delete((File)concatenatedRecordings);
                        LOG.warn((Throwable)e);
                        Path path2 = null;
                        if (dumpDir != null) {
                            FileUtil.delete((File)dumpDir);
                        }
                        return path2;
                    }
                    Path path3 = concatenatedRecordings.toPath();
                    return path3;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
                finally {
                    if (dumpDir != null) {
                        FileUtil.delete((File)dumpDir);
                    }
                }
            }
        }
        return null;
    }

    private List<File> dumpRecording(int index2, File dumpDir, String name2) {
        ArrayList<File> files2 = new ArrayList<File>();
        try {
            Path jfrPath = Paths.get(new File(dumpDir, name2).toURI());
            this.recordings[index2].dump(jfrPath);
            files2.add(jfrPath.toFile());
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return files2;
    }
}

