/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr;

import com.android.tools.idea.diagnostics.jfr.EventFilter;
import com.android.tools.idea.diagnostics.jfr.RecordingManager;
import com.android.tools.idea.diagnostics.jfr.RecordingManagerKt;
import com.android.tools.idea.diagnostics.report.DiagnosticReport;
import com.android.tools.idea.diagnostics.report.DiagnosticReportProperties;
import com.android.tools.idea.diagnostics.report.GenericReport;
import com.intellij.openapi.diagnostic.Logger;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001!B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\rR\u00020\u0000H&J\u0014\u0010\u001b\u001a\u00020\u00172\n\u0010\u001a\u001a\u00060\rR\u00020\u0000H&J\u0006\u0010\u001c\u001a\u00020\u0017J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001eH&J\u0006\u0010\u001f\u001a\u00020\u0017J\u0006\u0010 \u001a\u00020\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0018\u00010\rR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;", "", "reportType", "", "eventFilter", "Lcom/android/tools/idea/diagnostics/jfr/EventFilter;", "startOffsetMs", "", "endOffsetMs", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Lcom/android/tools/idea/diagnostics/jfr/EventFilter;JJLjava/time/Clock;)V", "currentCapture", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture;", "getEventFilter", "()Lcom/android/tools/idea/diagnostics/jfr/EventFilter;", "<set-?>", "", "isFinished", "()Z", "getReportType", "()Ljava/lang/String;", "accept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "c", "captureCompleted", "finish", "generateReport", "", "startCapture", "stopCapture", "Capture", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nJfrReportGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrReportGenerator.kt\ncom/android/tools/idea/diagnostics/jfr/JfrReportGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public abstract class JfrReportGenerator {
    @NotNull
    private final String reportType;
    @NotNull
    private final EventFilter eventFilter;
    private final long startOffsetMs;
    private final long endOffsetMs;
    @NotNull
    private final Clock clock;
    @Nullable
    private Capture currentCapture;
    private boolean isFinished;

    public JfrReportGenerator(@NotNull String reportType, @NotNull EventFilter eventFilter, long startOffsetMs, long endOffsetMs, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)reportType, (String)"reportType");
        Intrinsics.checkNotNullParameter((Object)eventFilter, (String)"eventFilter");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.reportType = reportType;
        this.eventFilter = eventFilter;
        this.startOffsetMs = startOffsetMs;
        this.endOffsetMs = endOffsetMs;
        this.clock = clock;
        if (!(this.startOffsetMs >= -Duration.getInWholeMilliseconds-impl((long)RecordingManagerKt.getJFR_RECORDING_DURATION()))) {
            boolean bl = false;
            String string = "Start offset cannot be less than -" + Duration.getInWholeSeconds-impl((long)RecordingManagerKt.getJFR_RECORDING_DURATION()) + " seconds";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ JfrReportGenerator(String string, EventFilter eventFilter, long l, long l2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        if ((n & 8) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        this(string, eventFilter, l, l2, clock);
    }

    @NotNull
    public final String getReportType() {
        return this.reportType;
    }

    @NotNull
    public final EventFilter getEventFilter() {
        return this.eventFilter;
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    public abstract void accept(@NotNull RecordedEvent var1, @NotNull Capture var2);

    public abstract void captureCompleted(@NotNull Capture var1);

    @NotNull
    public abstract Map<String, String> generateReport();

    public final void finish() {
        this.isFinished = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void startCapture() {
        void it;
        Capture capture;
        if (!(this.currentCapture == null)) {
            boolean $i$a$-check-JfrReportGenerator$startCapture$22 = false;
            String $i$a$-check-JfrReportGenerator$startCapture$22 = "Cannot start capture: capture already in progress";
            throw new IllegalStateException($i$a$-check-JfrReportGenerator$startCapture$22.toString());
        }
        Capture $i$a$-check-JfrReportGenerator$startCapture$22 = capture = new Capture();
        JfrReportGenerator jfrReportGenerator = this;
        boolean bl = false;
        RecordingManager.Companion.getInstance().startCapture((Capture)it);
        jfrReportGenerator.currentCapture = capture;
    }

    public final void stopCapture() {
        if (this.currentCapture == null) {
            boolean bl = false;
            String string = "Cannot stop capture: there is no active capture";
            throw new IllegalStateException(string.toString());
        }
        Capture capture = this.currentCapture;
        if (capture != null) {
            capture.setEnd(this.clock.instant().plusMillis(this.endOffsetMs));
        }
        this.currentCapture = null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u000fj\u0002`\u0011J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture;", "", "(Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;)V", "end", "Ljava/time/Instant;", "getEnd", "()Ljava/time/Instant;", "setEnd", "(Ljava/time/Instant;)V", "start", "getStart", "completeAndGenerateReport", "", "endThreshold", "reportCallback", "Lkotlin/Function1;", "Lcom/android/tools/idea/diagnostics/report/DiagnosticReport;", "Lcom/android/tools/idea/diagnostics/jfr/ReportCallback;", "containsInstant", "instant", "maybeAccept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nJfrReportGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrReportGenerator.kt\ncom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,114:1\n8#2:115\n*S KotlinDebug\n*F\n+ 1 JfrReportGenerator.kt\ncom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture\n*L\n74#1:115\n*E\n"})
    public final class Capture {
        @NotNull
        private final Instant start;
        @Nullable
        private Instant end;

        public Capture() {
            Instant instant = JfrReportGenerator.this.clock.instant().plusMillis(JfrReportGenerator.this.startOffsetMs);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant().plusMillis(startOffsetMs)");
            this.start = instant;
        }

        @NotNull
        public final Instant getStart() {
            return this.start;
        }

        @Nullable
        public final Instant getEnd() {
            return this.end;
        }

        public final void setEnd(@Nullable Instant instant) {
            this.end = instant;
        }

        public final void maybeAccept(@NotNull RecordedEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Instant instant = e.getStartTime();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"e.startTime");
            if (this.containsInstant(instant) && JfrReportGenerator.this.getEventFilter().accepts(e)) {
                JfrReportGenerator.this.accept(e, this);
            }
        }

        private final boolean containsInstant(Instant instant) {
            return !instant.isBefore(this.start) && (this.end == null || instant.isBefore(this.end));
        }

        public final boolean completeAndGenerateReport(@NotNull Instant endThreshold, @NotNull Function1<? super DiagnosticReport, Boolean> reportCallback) {
            Intrinsics.checkNotNullParameter((Object)endThreshold, (String)"endThreshold");
            Intrinsics.checkNotNullParameter(reportCallback, (String)"reportCallback");
            Instant instant = this.end;
            if (!(instant != null ? instant.isBefore(endThreshold) : false)) {
                return false;
            }
            JfrReportGenerator.this.captureCompleted(this);
            if (JfrReportGenerator.this.isFinished()) {
                try {
                    Map<String, String> report2 = JfrReportGenerator.this.generateReport();
                    if (!report2.isEmpty()) {
                        reportCallback.invoke((Object)new GenericReport(JfrReportGenerator.this.getReportType(), report2, new DiagnosticReportProperties(0L, 0L, null, null, null, 31, null)));
                    }
                }
                catch (Exception e) {
                    Capture $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(Capture.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                    logger2.warn((Throwable)e);
                }
            }
            return true;
        }
    }
}

