/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr;

import com.android.tools.idea.diagnostics.TruncatingStringBuilder;
import com.android.tools.idea.diagnostics.jfr.CallTreeAggregator;
import com.android.tools.idea.diagnostics.jfr.EventFilter;
import com.android.tools.idea.diagnostics.jfr.Sample;
import com.android.tools.idea.diagnostics.jfr.analysis.CallTree;
import com.android.tools.idea.diagnostics.jfr.analysis.IdleStacks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedThread;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040#*\u00020\u0015H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/CallTreeAggregator;", "", "threadFilter", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "callTrees", "", "", "Lcom/android/tools/idea/diagnostics/jfr/analysis/CallTree;", "edtId", "samples", "", "Lcom/android/tools/idea/diagnostics/jfr/Sample;", "getThreadFilter", "()Lkotlin/jvm/functions/Function1;", "threadIdToName", "accept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "aggregate", "generateReport", "maxLengthBytes", "", "getReportForThread", "tid", "tree", "processBatch", "endTime", "Ljava/time/Instant;", "sortSamplesAndComputeDurations", "end", "getStacktrace", "", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nCallTreeAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTreeAggregator.kt\ncom/android/tools/idea/diagnostics/jfr/CallTreeAggregator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,109:1\n359#2,7:110\n1054#3:117\n1851#3,2:118\n1002#3,2:121\n1851#3,2:125\n1549#3:128\n1620#3,3:129\n211#4:120\n212#4:123\n211#4:124\n212#4:127\n*S KotlinDebug\n*F\n+ 1 CallTreeAggregator.kt\ncom/android/tools/idea/diagnostics/jfr/CallTreeAggregator\n*L\n47#1:110,7\n64#1:117\n64#1:118,2\n72#1:121,2\n83#1:125,2\n91#1:128\n91#1:129,3\n71#1:120\n71#1:123\n81#1:124\n81#1:127\n*E\n"})
public final class CallTreeAggregator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Boolean> threadFilter;
    @NotNull
    private final Map<Long, List<Sample>> samples;
    @NotNull
    private final Map<Long, String> threadIdToName;
    @NotNull
    private final Map<Long, CallTree> callTrees;
    private long edtId;
    @NotNull
    private static final String EDT = "AWT-EventQueue-0";
    @NotNull
    private static final Function1<String, Boolean> THREAD_FILTER_ALL = Companion.THREAD_FILTER_ALL.1.INSTANCE;
    @NotNull
    private static final Function1<String, Boolean> THREAD_FILTER_EDT_ONLY = Companion.THREAD_FILTER_EDT_ONLY.1.INSTANCE;

    public CallTreeAggregator(@NotNull Function1<? super String, Boolean> threadFilter) {
        Intrinsics.checkNotNullParameter(threadFilter, (String)"threadFilter");
        this.threadFilter = threadFilter;
        this.samples = new LinkedHashMap();
        this.threadIdToName = new LinkedHashMap();
        this.callTrees = new LinkedHashMap();
    }

    @NotNull
    public final Function1<String, Boolean> getThreadFilter() {
        return this.threadFilter;
    }

    /*
     * WARNING - void declaration
     */
    public final void accept(@NotNull RecordedEvent e) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!EventFilter.Companion.getSAMPLING_EVENT_NAMES().contains(e.getEventType().getName())) {
            return;
        }
        RecordedThread thread = e.getThread("sampledThread");
        long tid = thread.getJavaThreadId();
        String threadName = thread.getJavaName();
        Intrinsics.checkNotNullExpressionValue((Object)threadName, (String)"threadName");
        if (!((Boolean)this.threadFilter.invoke((Object)threadName)).booleanValue()) {
            return;
        }
        Long l = tid;
        this.threadIdToName.put(l, threadName);
        if (Intrinsics.areEqual((Object)threadName, (Object)EDT)) {
            this.edtId = tid;
        }
        if (IdleStacks.Companion.isIgnoredThread(threadName)) {
            return;
        }
        List stacktrace = this.getStacktrace(e);
        if (IdleStacks.Companion.isIdle(threadName, stacktrace)) {
            stacktrace = CollectionsKt.listOf((Object)"IDLE.IDLE(Unknown Source)");
        }
        Instant instant = e.getStartTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"e.startTime");
        Sample sample = new Sample(threadName, instant, 0L, stacktrace);
        Map<Long, List<Sample>> map2 = this.samples;
        Long key$iv = tid;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(sample);
    }

    public final void processBatch(@NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        this.sortSamplesAndComputeDurations(endTime);
        this.aggregate();
        this.samples.clear();
    }

    private final String getReportForThread(long tid, CallTree tree2) {
        return this.threadIdToName.get(tid) + ", TID: " + tid + " [" + tree2.getTime() + "ms] (" + tree2.getSampleCount() + ")\n" + tree2 + "\n";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateReport(int maxLengthBytes) {
        void $this$forEach$iv;
        CallTree edtTree = this.callTrees.remove(this.edtId);
        TruncatingStringBuilder sb = new TruncatingStringBuilder(maxLengthBytes, "\n...report truncated...");
        if (edtTree != null) {
            sb.append(this.getReportForThread(this.edtId, edtTree));
        }
        Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)this.callTrees.entrySet());
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((CallTree)it.getValue()).numNodesAboveCutoff());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((CallTree)it.getValue()).numNodesAboveCutoff()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            long tid = ((Number)entry.getKey()).longValue();
            CallTree tree2 = (CallTree)entry.getValue();
            sb.append(this.getReportForThread(tid, tree2));
        }
        return sb.toString();
    }

    private final void sortSamplesAndComputeDurations(Instant end) {
        Map<Long, List<Sample>> $this$forEach$iv = this.samples;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, List<Sample>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<Sample> sampleList;
            Map.Entry<Long, List<Sample>> element$iv;
            Map.Entry<Long, List<Sample>> entry = element$iv = iterator2.next();
            boolean bl = false;
            List<Sample> $this$sortBy$iv = sampleList = entry.getValue();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Sample it = (Sample)a;
                        boolean bl = false;
                        Comparable comparable = it.getTime();
                        it = (Sample)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTime());
                    }
                });
            }
            int n = sampleList.size() - 1;
            for (int i = 0; i < n; ++i) {
                sampleList.get(i).setDuration(sampleList.get(i + 1).getTime().toEpochMilli() - sampleList.get(i).getTime().toEpochMilli());
            }
            ((Sample)CollectionsKt.last(sampleList)).setDuration(end.toEpochMilli() - ((Sample)CollectionsKt.last(sampleList)).getTime().toEpochMilli());
        }
    }

    private final void aggregate() {
        Map<Long, List<Sample>> $this$forEach$iv = this.samples;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, List<Sample>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, List<Sample>> element$iv;
            Map.Entry<Long, List<Sample>> entry = element$iv = iterator2.next();
            boolean bl = false;
            long tid = ((Number)entry.getKey()).longValue();
            List<Sample> sampleList = entry.getValue();
            CallTree callTree = this.callTrees.get(tid);
            if (callTree == null) {
                callTree = new CallTree("");
            }
            CallTree root = callTree;
            Iterable $this$forEach$iv2 = sampleList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Sample sample = (Sample)element$iv2;
                boolean bl2 = false;
                root.addStacktrace(sample.getStackTrace(), sample.getDuration());
            }
            root.sort();
            Long l = tid;
            this.callTrees.put(l, root);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getStacktrace(RecordedEvent $this$getStacktrace) {
        void $this$mapTo$iv$iv;
        List<RecordedFrame> list2 = $this$getStacktrace.getStackTrace().getFrames();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"stackTrace.frames");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void frame;
            StringBuilder stringBuilder;
            RecordedFrame recordedFrame = (RecordedFrame)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            StringBuilder $this$getStacktrace_u24lambda_u248_u24lambda_u247 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$getStacktrace_u24lambda_u248_u24lambda_u247.append(frame.getMethod().getType().getName());
            $this$getStacktrace_u24lambda_u248_u24lambda_u247.append(".");
            $this$getStacktrace_u24lambda_u248_u24lambda_u247.append(frame.getMethod().getName());
            if (frame.getLineNumber() == -1) {
                $this$getStacktrace_u24lambda_u248_u24lambda_u247.append("(Unknown Source)");
            } else {
                $this$getStacktrace_u24lambda_u248_u24lambda_u247.append("(?:" + frame.getLineNumber() + ")");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            collection2.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/CallTreeAggregator$Companion;", "", "()V", "EDT", "", "THREAD_FILTER_ALL", "Lkotlin/Function1;", "", "getTHREAD_FILTER_ALL", "()Lkotlin/jvm/functions/Function1;", "THREAD_FILTER_EDT_ONLY", "getTHREAD_FILTER_EDT_ONLY", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<String, Boolean> getTHREAD_FILTER_ALL() {
            return THREAD_FILTER_ALL;
        }

        @NotNull
        public final Function1<String, Boolean> getTHREAD_FILTER_EDT_ONLY() {
            return THREAD_FILTER_EDT_ONLY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

