/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.visitors;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.classstore.InstanceField;
import com.android.tools.idea.diagnostics.hprof.parser.ConstantPoolEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.HeapDumpRecordType;
import com.android.tools.idea.diagnostics.hprof.parser.InstanceFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.StaticFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import com.android.tools.idea.diagnostics.hprof.util.FileChannelBackedWriteBuffer;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J_\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0016\u00a2\u0006\u0002\u0010#J(\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0016J(\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0016J(\u0010.\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u000201H\u0016J\u0014\u00102\u001a\u00020\u0013*\u00020\u000b2\u0006\u00103\u001a\u00020\rH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/CreateAuxiliaryFilesVisitor;", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "auxOffsetsChannel", "Ljava/nio/channels/FileChannel;", "auxChannel", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "(Ljava/nio/channels/FileChannel;Ljava/nio/channels/FileChannel;Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;)V", "aux", "Lcom/android/tools/idea/diagnostics/hprof/util/FileChannelBackedWriteBuffer;", "directByteBufferCapacityOffset", "", "directByteBufferClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "directByteBufferFdOffset", "offsets", "postVisit", "", "preVisit", "visitClassDump", "classId", "", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "writeId", "id", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nCreateAuxiliaryFilesVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateAuxiliaryFilesVisitor.kt\ncom/android/tools/idea/diagnostics/hprof/visitors/CreateAuxiliaryFilesVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,197:1\n12904#2,3:198\n13571#2,2:201\n13543#2,2:203\n*S KotlinDebug\n*F\n+ 1 CreateAuxiliaryFilesVisitor.kt\ncom/android/tools/idea/diagnostics/hprof/visitors/CreateAuxiliaryFilesVisitor\n*L\n117#1:198,3\n126#1:201,2\n147#1:203,2\n*E\n"})
public final class CreateAuxiliaryFilesVisitor
extends HProfVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileChannel auxOffsetsChannel;
    @NotNull
    private final FileChannel auxChannel;
    @NotNull
    private final ClassStore classStore;
    @NotNull
    private final HProfEventBasedParser parser;
    private FileChannelBackedWriteBuffer offsets;
    private FileChannelBackedWriteBuffer aux;
    @Nullable
    private ClassDefinition directByteBufferClass;
    private int directByteBufferCapacityOffset;
    private int directByteBufferFdOffset;
    @NotNull
    private static final Logger LOG;

    public CreateAuxiliaryFilesVisitor(@NotNull FileChannel auxOffsetsChannel, @NotNull FileChannel auxChannel, @NotNull ClassStore classStore, @NotNull HProfEventBasedParser parser2) {
        Intrinsics.checkNotNullParameter((Object)auxOffsetsChannel, (String)"auxOffsetsChannel");
        Intrinsics.checkNotNullParameter((Object)auxChannel, (String)"auxChannel");
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
        this.auxOffsetsChannel = auxOffsetsChannel;
        this.auxChannel = auxChannel;
        this.classStore = classStore;
        this.parser = parser2;
    }

    @Override
    public void preVisit() {
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer;
        this.disableAll();
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.offsets = new FileChannelBackedWriteBuffer(this.auxOffsetsChannel, false, 2, null);
        this.aux = new FileChannelBackedWriteBuffer(this.auxChannel, false, 2, null);
        this.directByteBufferClass = null;
        ClassDefinition dbbClass = this.classStore.getClassIfExists("java.nio.DirectByteBuffer");
        if (dbbClass != null) {
            this.directByteBufferClass = dbbClass;
            this.directByteBufferCapacityOffset = dbbClass.computeOffsetOfField("capacity", this.classStore);
            this.directByteBufferFdOffset = dbbClass.computeOffsetOfField("fd", this.classStore);
            if (this.directByteBufferCapacityOffset == -1 || this.directByteBufferFdOffset == -1) {
                LOG.error("DirectByteBuffer.capacity and/or .fd field is missing.");
            }
        }
        if ((fileChannelBackedWriteBuffer = this.offsets) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer = null;
        }
        fileChannelBackedWriteBuffer.writeInt(0);
    }

    @Override
    public void postVisit() {
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.aux;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer = null;
        }
        fileChannelBackedWriteBuffer.close();
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer2 = null;
        }
        fileChannelBackedWriteBuffer2.close();
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType) {
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)elementType), (String)"elementType");
        boolean bl2 = bl = arrayObjectId <= Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer2 = null;
        }
        boolean bl3 = bl = fileChannelBackedWriteBuffer2.position() / 4 == (int)arrayObjectId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.offsets;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer3 = null;
        }
        if ((fileChannelBackedWriteBuffer = this.aux) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer = null;
        }
        fileChannelBackedWriteBuffer3.writeInt(fileChannelBackedWriteBuffer.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer4 = null;
        }
        ClassDefinition classDefinition = this.classStore.getClassForPrimitiveArray(elementType);
        Intrinsics.checkNotNull((Object)classDefinition);
        this.writeId(fileChannelBackedWriteBuffer4, (int)classDefinition.getId());
        boolean bl4 = bl = numberOfElements <= Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = this.aux;
        if (fileChannelBackedWriteBuffer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer5 = null;
        }
        fileChannelBackedWriteBuffer5.writeNonNegativeLEB128Int((int)numberOfElements);
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        boolean bl2 = bl = classId <= Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer2 = null;
        }
        boolean bl3 = bl = fileChannelBackedWriteBuffer2.position() / 4 == (int)classId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.offsets;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer3 = null;
        }
        if ((fileChannelBackedWriteBuffer = this.aux) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer = null;
        }
        fileChannelBackedWriteBuffer3.writeInt(fileChannelBackedWriteBuffer.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer4 = null;
        }
        this.writeId(fileChannelBackedWriteBuffer4, 0);
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        long it;
        long element$iv;
        int n;
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        boolean bl2 = bl = arrayObjectId <= Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = arrayClassObjectId <= Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer2 = null;
        }
        boolean bl4 = bl = fileChannelBackedWriteBuffer2.position() / 4 == (int)arrayObjectId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.offsets;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer3 = null;
        }
        if ((fileChannelBackedWriteBuffer = this.aux) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer = null;
        }
        fileChannelBackedWriteBuffer3.writeInt(fileChannelBackedWriteBuffer.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer4 = null;
        }
        this.writeId(fileChannelBackedWriteBuffer4, (int)arrayClassObjectId);
        long[] $this$count$iv = objects;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n2 = $this$count$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$count$iv[n];
            boolean bl5 = false;
            if (!(it != 0L)) continue;
            ++count$iv;
        }
        int nonNullElementsCount = count$iv;
        int nullElementsCount = objects.length - nonNullElementsCount;
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = this.aux;
        if (fileChannelBackedWriteBuffer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer5 = null;
        }
        fileChannelBackedWriteBuffer5.writeNonNegativeLEB128Int(nullElementsCount);
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer6 = this.aux;
        if (fileChannelBackedWriteBuffer6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer6 = null;
        }
        fileChannelBackedWriteBuffer6.writeNonNegativeLEB128Int(nonNullElementsCount);
        long[] $this$forEach$iv = objects;
        boolean $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            boolean bl6;
            it = element$iv = $this$forEach$iv[n];
            boolean bl7 = false;
            if (it == 0L) continue;
            boolean bl8 = bl6 = it <= Integer.MAX_VALUE;
            if (_Assertions.ENABLED && !bl6) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer7 = this.aux;
            if (fileChannelBackedWriteBuffer7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                fileChannelBackedWriteBuffer7 = null;
            }
            this.writeId(fileChannelBackedWriteBuffer7, (int)it);
        }
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes2) {
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        boolean bl2 = bl = objectId <= Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = classObjectId <= Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer2 = null;
        }
        boolean bl4 = bl = fileChannelBackedWriteBuffer2.position() / 4 == (int)objectId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.offsets;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            fileChannelBackedWriteBuffer3 = null;
        }
        if ((fileChannelBackedWriteBuffer = this.aux) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer = null;
        }
        fileChannelBackedWriteBuffer3.writeInt(fileChannelBackedWriteBuffer.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            fileChannelBackedWriteBuffer4 = null;
        }
        this.writeId(fileChannelBackedWriteBuffer4, (int)classObjectId);
        int classOffset = 0;
        ClassDefinition objectClass = this.classStore.get(classObjectId);
        CreateAuxiliaryFilesVisitor $this$visitInstanceDump_u24lambda_u243 = this;
        boolean bl5 = false;
        ClassDefinition classDef = objectClass;
        while (true) {
            InstanceField[] $this$forEach$iv = classDef.getRefInstanceFields();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean bl6;
                InstanceField element$iv;
                InstanceField it = element$iv = $this$forEach$iv[i];
                boolean bl7 = false;
                int offset = classOffset + it.getOffset();
                long value2 = bytes2.getLong(offset);
                if (value2 == 0L) {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = $this$visitInstanceDump_u24lambda_u243.aux;
                    if (fileChannelBackedWriteBuffer5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                        fileChannelBackedWriteBuffer5 = null;
                    }
                    $this$visitInstanceDump_u24lambda_u243.writeId(fileChannelBackedWriteBuffer5, 0);
                    continue;
                }
                long reference = $this$visitInstanceDump_u24lambda_u243.parser.remap(value2);
                boolean bl8 = bl6 = reference != 0L;
                if (_Assertions.ENABLED && !bl6) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer6 = $this$visitInstanceDump_u24lambda_u243.aux;
                if (fileChannelBackedWriteBuffer6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                    fileChannelBackedWriteBuffer6 = null;
                }
                $this$visitInstanceDump_u24lambda_u243.writeId(fileChannelBackedWriteBuffer6, (int)reference);
            }
            classOffset += classDef.getSuperClassOffset();
            if (classDef.getSuperClassId() == 0L) break;
            classDef = $this$visitInstanceDump_u24lambda_u243.classStore.get(classDef.getSuperClassId());
        }
        if (Intrinsics.areEqual((Object)objectClass, (Object)this.directByteBufferClass)) {
            if (this.directByteBufferCapacityOffset == -1 || this.directByteBufferFdOffset == -1) {
                FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer7 = this.aux;
                if (fileChannelBackedWriteBuffer7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                    fileChannelBackedWriteBuffer7 = null;
                }
                fileChannelBackedWriteBuffer7.writeNonNegativeLEB128Int(1);
            } else {
                int directByteBufferCapacity = bytes2.getInt(this.directByteBufferCapacityOffset);
                long directByteBufferFd = bytes2.getLong(this.directByteBufferFdOffset);
                if (directByteBufferFd == 0L) {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer8 = this.aux;
                    if (fileChannelBackedWriteBuffer8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                        fileChannelBackedWriteBuffer8 = null;
                    }
                    fileChannelBackedWriteBuffer8.writeNonNegativeLEB128Int(directByteBufferCapacity);
                } else {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer9 = this.aux;
                    if (fileChannelBackedWriteBuffer9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                        fileChannelBackedWriteBuffer9 = null;
                    }
                    fileChannelBackedWriteBuffer9.writeNonNegativeLEB128Int(1);
                }
            }
        }
    }

    private final void writeId(FileChannelBackedWriteBuffer $this$writeId, int id2) {
        $this$writeId.writeNonNegativeLEB128Int(id2);
    }

    static {
        Logger logger2 = Logger.getInstance(CreateAuxiliaryFilesVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(CreateAuxili\u2026FilesVisitor::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/CreateAuxiliaryFilesVisitor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

