/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.visitors;

import com.android.tools.idea.diagnostics.hprof.classstore.ThreadInfo;
import com.android.tools.idea.diagnostics.hprof.navigator.RootReason;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.HeapDumpRecordType;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/CollectRootReasonsVisitor;", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "threadsMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ThreadInfo;", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V", "roots", "Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "getRoots", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "preVisit", "", "visitRootGlobalJNI", "objectId", "", "jniGlobalRefId", "visitRootJavaFrame", "threadSerialNumber", "frameNumber", "visitRootLocalJNI", "visitRootMonitorUsed", "visitRootNativeStack", "visitRootStickyClass", "visitRootThreadBlock", "visitRootThreadObject", "stackTraceSerialNumber", "visitRootUnknown", "intellij.android.core"})
public final class CollectRootReasonsVisitor
extends HProfVisitor {
    @NotNull
    private final Long2ObjectOpenHashMap<ThreadInfo> threadsMap;
    @NotNull
    private final Long2ObjectOpenHashMap<RootReason> roots;

    public CollectRootReasonsVisitor(@NotNull Long2ObjectOpenHashMap<ThreadInfo> threadsMap) {
        Intrinsics.checkNotNullParameter(threadsMap, (String)"threadsMap");
        this.threadsMap = threadsMap;
        this.roots = new Long2ObjectOpenHashMap();
    }

    @NotNull
    public final Long2ObjectOpenHashMap<RootReason> getRoots() {
        return this.roots;
    }

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(HeapDumpRecordType.RootGlobalJNI);
        this.enable(HeapDumpRecordType.RootJavaFrame);
        this.enable(HeapDumpRecordType.RootLocalJNI);
        this.enable(HeapDumpRecordType.RootMonitorUsed);
        this.enable(HeapDumpRecordType.RootNativeStack);
        this.enable(HeapDumpRecordType.RootStickyClass);
        this.enable(HeapDumpRecordType.RootThreadBlock);
        this.enable(HeapDumpRecordType.RootThreadObject);
        this.enable(HeapDumpRecordType.RootUnknown);
    }

    @Override
    public void visitRootUnknown(long objectId) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootUnknown());
    }

    @Override
    public void visitRootGlobalJNI(long objectId, long jniGlobalRefId) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootGlobalJNI());
    }

    @Override
    public void visitRootLocalJNI(long objectId, long threadSerialNumber, long frameNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootLocalJNI());
    }

    @Override
    public void visitRootJavaFrame(long objectId, long threadSerialNumber, long frameNumber) {
        RootReason rootReason;
        RootReason rootReason2 = rootReason = frameNumber >= 0L ? RootReason.Companion.createJavaFrameReason(((ThreadInfo)this.threadsMap.get(threadSerialNumber)).getFrames().get((int)frameNumber)) : RootReason.Companion.createJavaFrameReason("Unknown location");
        if (!this.roots.containsKey(objectId)) {
            this.roots.put(objectId, (Object)rootReason);
        }
    }

    @Override
    public void visitRootNativeStack(long objectId, long threadSerialNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootNativeStack());
    }

    @Override
    public void visitRootStickyClass(long objectId) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootStickyClass());
    }

    @Override
    public void visitRootThreadBlock(long objectId, long threadSerialNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootThreadBlock());
    }

    @Override
    public void visitRootThreadObject(long objectId, long threadSerialNumber, long stackTraceSerialNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootThreadObject());
    }

    @Override
    public void visitRootMonitorUsed(long objectId) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootMonitorUsed());
    }
}

