/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.parser;

import com.android.tools.idea.diagnostics.hprof.parser.ConstantPoolEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.HeapDumpRecordType;
import com.android.tools.idea.diagnostics.hprof.parser.InstanceFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.RecordType;
import com.android.tools.idea.diagnostics.hprof.parser.StaticFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import com.android.tools.idea.diagnostics.hprof.parser.VisitorContext;
import com.android.tools.idea.diagnostics.hprof.util.HProfReadBuffer;
import com.android.tools.idea.diagnostics.hprof.util.HProfReadBufferSlidingWindow;
import com.google.common.base.Stopwatch;
import com.intellij.openapi.diagnostic.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0016\u0018\u0000 ;2\u00020\u0001:\u0001;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0012H\u0002J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\bH\u0002J\b\u0010(\u001a\u00020\nH\u0002J\b\u0010)\u001a\u00020\bH\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010+\u001a\u00020\u0016H\u0002J\b\u0010,\u001a\u00020\bH\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010.\u001a\u00020\nH\u0002J\b\u0010/\u001a\u00020\bH\u0002J\b\u00100\u001a\u00020\nH\u0002J\u000e\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bJ\u0010\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\bH\u0002J\u000e\u00105\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\bH\u0002J\u0010\u00108\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "Ljava/lang/AutoCloseable;", "fileChannel", "Ljava/nio/channels/FileChannel;", "(Ljava/nio/channels/FileChannel;)V", "buffer", "Lcom/android/tools/idea/diagnostics/hprof/util/HProfReadBuffer;", "heapRecordPosition", "", "<set-?>", "", "idSize", "getIdSize", "()I", "remapFunction", "Ljava/util/function/LongUnaryOperator;", "reparsePosition", "accept", "", "visitor", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "description", "", "acceptClassDump", "acceptHeapDumpRecord", "heapDumpRecordType", "Lcom/android/tools/idea/diagnostics/hprof/parser/HeapDumpRecordType;", "acceptHeapDumpSegment", "length", "acceptInstanceDump", "acceptObjectArrayDump", "acceptPrimitiveArrayDump", "close", "getElementTypeSize", "elementType", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "initialParse", "readByte", "", "readId", "readInt", "readLong", "readNonNullTerminatedString", "readNullTerminatedString", "readRawId", "readTypeSizeValue", "readUnsignedByte", "readUnsignedInt", "readUnsignedShort", "remap", "id", "saveHeapRecordPosition", "position", "setIdRemappingFunction", "skip", "count", "skipHeapDumpRecord", "verifyFormat", "version", "Companion", "intellij.android.core"})
public final class HProfEventBasedParser
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int idSize;
    private long reparsePosition;
    @Nullable
    private LongUnaryOperator remapFunction;
    @NotNull
    private final HProfReadBuffer buffer;
    private long heapRecordPosition;
    @NotNull
    private static final Logger LOG;

    public HProfEventBasedParser(@NotNull FileChannel fileChannel) {
        Intrinsics.checkNotNullParameter((Object)fileChannel, (String)"fileChannel");
        this.buffer = new HProfReadBufferSlidingWindow(fileChannel, this);
        this.initialParse();
    }

    public final int getIdSize() {
        return this.idSize;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public final void setIdRemappingFunction(@NotNull LongUnaryOperator remapFunction) {
        Intrinsics.checkNotNullParameter((Object)remapFunction, (String)"remapFunction");
        this.remapFunction = remapFunction;
    }

    private final void initialParse() {
        this.buffer.position(0L);
        this.verifyFormat(this.readNullTerminatedString());
        this.idSize = this.readInt();
        this.buffer.setIdSize(this.idSize);
        this.readLong();
        this.reparsePosition = this.buffer.position();
    }

    public final void accept(@NotNull HProfVisitor visitor2, @Nullable String description2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.buffer.position(this.reparsePosition);
        visitor2.setVisitorContext(new VisitorContext(this){
            final /* synthetic */ HProfEventBasedParser this$0;
            {
                this.this$0 = $receiver;
            }

            public long getCurrentHeapRecordOffset() {
                return HProfEventBasedParser.access$getHeapRecordPosition$p(this.this$0);
            }

            public int getIdSize() {
                return this.this$0.getIdSize();
            }
        });
        visitor2.preVisit();
        block15: while (!this.buffer.isEof()) {
            int tag = this.readUnsignedByte();
            this.readInt();
            long length = this.readUnsignedInt();
            RecordType recordType = RecordType.Companion.fromInt(tag);
            if (!visitor2.isEnabled(recordType)) {
                this.skip(length);
                continue;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[recordType.ordinal()]) {
                case 1: {
                    visitor2.visitStringInUTF8(this.readRawId(), this.readNonNullTerminatedString(length - (long)this.idSize));
                    continue block15;
                }
                case 2: {
                    visitor2.visitLoadClass(this.readUnsignedInt(), this.readId(), this.readUnsignedInt(), this.readRawId());
                    continue block15;
                }
                case 3: {
                    visitor2.visitUnloadClass(this.readUnsignedInt());
                    continue block15;
                }
                case 4: 
                case 5: {
                    this.acceptHeapDumpSegment(visitor2, length);
                    continue block15;
                }
                case 6: {
                    visitor2.visitHeapDumpEnd();
                    continue block15;
                }
                case 7: {
                    visitor2.visitHeapSummary(this.readUnsignedInt(), this.readUnsignedInt(), this.readLong(), this.readLong());
                    continue block15;
                }
                case 8: {
                    visitor2.visitAllocSites();
                    this.skip(length);
                    continue block15;
                }
                case 9: {
                    visitor2.visitEndThread(this.readUnsignedInt());
                    continue block15;
                }
                case 10: {
                    visitor2.visitStackFrame(this.readRawId(), this.readRawId(), this.readRawId(), this.readRawId(), this.readUnsignedInt(), this.readInt());
                    continue block15;
                }
                case 11: {
                    long stackTraceSerialNumber = this.readUnsignedInt();
                    long threadSerialNumber = this.readUnsignedInt();
                    int numberOfFrames = this.readInt();
                    int n = 0;
                    long[] lArray = new long[numberOfFrames];
                    while (n < numberOfFrames) {
                        int n2 = n++;
                        lArray[n2] = this.readRawId();
                    }
                    long[] frameIds = lArray;
                    visitor2.visitStackTrace(stackTraceSerialNumber, threadSerialNumber, numberOfFrames, frameIds);
                    continue block15;
                }
                case 12: {
                    visitor2.visitCPUSamples();
                    this.skip(length);
                    continue block15;
                }
                case 13: {
                    visitor2.visitStartThread();
                    this.skip(length);
                    continue block15;
                }
                case 14: {
                    visitor2.visitControlSettings();
                    this.skip(length);
                    continue block15;
                }
            }
            throw new RuntimeException("Invalid format.");
        }
        visitor2.postVisit();
        String string = description2;
        LOG.info("HProfEventBasedParser" + (String)(string != null ? " - " + string : "") + ": " + stopwatch);
    }

    private final void skip(long count2) {
        this.buffer.position(this.buffer.position() + count2);
    }

    private final void acceptHeapDumpSegment(HProfVisitor visitor2, long length) {
        visitor2.visitHeapDump();
        long segmentEndPosition = this.buffer.position() + length;
        long currentPosition = this.buffer.position();
        while (currentPosition < segmentEndPosition) {
            int type = this.readUnsignedByte();
            HeapDumpRecordType heapDumpRecordType = HeapDumpRecordType.Companion.fromInt(type);
            if (visitor2.isEnabled(heapDumpRecordType)) {
                this.saveHeapRecordPosition(currentPosition);
                this.acceptHeapDumpRecord(heapDumpRecordType, visitor2);
            } else {
                this.skipHeapDumpRecord(heapDumpRecordType);
            }
            currentPosition = this.buffer.position();
        }
    }

    private final void acceptHeapDumpRecord(HeapDumpRecordType heapDumpRecordType, HProfVisitor visitor2) {
        switch (WhenMappings.$EnumSwitchMapping$1[heapDumpRecordType.ordinal()]) {
            case 1: {
                visitor2.visitRootUnknown(this.readId());
                break;
            }
            case 2: {
                visitor2.visitRootGlobalJNI(this.readId(), this.readRawId());
                break;
            }
            case 3: {
                visitor2.visitRootLocalJNI(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 4: {
                visitor2.visitRootJavaFrame(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 5: {
                visitor2.visitRootNativeStack(this.readId(), this.readUnsignedInt());
                break;
            }
            case 6: {
                visitor2.visitRootStickyClass(this.readId());
                break;
            }
            case 7: {
                visitor2.visitRootThreadBlock(this.readId(), this.readUnsignedInt());
                break;
            }
            case 8: {
                visitor2.visitRootMonitorUsed(this.readId());
                break;
            }
            case 9: {
                visitor2.visitRootThreadObject(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 10: {
                this.acceptClassDump(visitor2);
                break;
            }
            case 11: {
                this.acceptInstanceDump(visitor2);
                break;
            }
            case 12: {
                this.acceptObjectArrayDump(visitor2);
                break;
            }
            case 13: {
                this.acceptPrimitiveArrayDump(visitor2);
                break;
            }
            default: {
                throw new IOException("Unknown heap dump record type: " + heapDumpRecordType);
            }
        }
    }

    private final void skipHeapDumpRecord(HeapDumpRecordType heapDumpRecordType) {
        switch (WhenMappings.$EnumSwitchMapping$1[heapDumpRecordType.ordinal()]) {
            case 1: {
                this.skip(this.idSize);
                break;
            }
            case 2: {
                this.skip(this.idSize * 2);
                break;
            }
            case 3: {
                this.skip(this.idSize + 8);
                break;
            }
            case 4: {
                this.skip(this.idSize + 8);
                break;
            }
            case 5: {
                this.skip(this.idSize + 4);
                break;
            }
            case 6: {
                this.skip(this.idSize);
                break;
            }
            case 7: {
                this.skip(this.idSize + 4);
                break;
            }
            case 8: {
                this.skip(this.idSize);
                break;
            }
            case 9: {
                this.skip(this.idSize + 8);
                break;
            }
            case 10: {
                int i;
                this.skip(7 * this.idSize + 8);
                int toSkip = this.readUnsignedShort();
                int n = toSkip;
                for (i = 0; i < n; ++i) {
                    this.skip(2L);
                    this.readTypeSizeValue(Type.Companion.getType(this.readUnsignedByte()));
                }
                toSkip = this.readUnsignedShort();
                n = toSkip;
                for (i = 0; i < n; ++i) {
                    this.skip(this.idSize);
                    this.readTypeSizeValue(Type.Companion.getType(this.readUnsignedByte()));
                }
                toSkip = this.readUnsignedShort();
                this.skip(toSkip * (this.idSize + 1));
                break;
            }
            case 11: {
                this.skip(this.idSize * 2 + 4);
                long remainingBytes = this.readUnsignedInt();
                this.skip(remainingBytes);
                break;
            }
            case 12: {
                this.skip(this.idSize + 4);
                long objectArraySize = this.readUnsignedInt();
                this.skip((long)this.idSize * (objectArraySize + 1L));
                break;
            }
            case 13: {
                this.skip(this.idSize + 4);
                long primitiveArraySize = this.readUnsignedInt();
                byte elementTypeID = this.readByte();
                this.skip(primitiveArraySize * (long)Type.Companion.getType(elementTypeID).getSize());
                break;
            }
            default: {
                throw new IOException("Unknown heap dump record type: " + heapDumpRecordType);
            }
        }
    }

    private final void saveHeapRecordPosition(long position) {
        this.heapRecordPosition = position;
    }

    private final void acceptInstanceDump(HProfVisitor visitor2) {
        long objectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long classObjectId = this.readId();
        int remainingBytes = this.readInt();
        ByteBuffer byteBuffer = this.buffer.getByteBuffer(remainingBytes);
        visitor2.visitInstanceDump(objectId, stackTraceSerialNumber, classObjectId, byteBuffer);
    }

    private final void acceptObjectArrayDump(HProfVisitor visitor2) {
        long arrayObjectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long numberOfElements = this.readUnsignedInt();
        long arrayClassObjectId = this.readId();
        long[] objects = new long[(int)numberOfElements];
        int n = objects.length;
        for (int i = 0; i < n; ++i) {
            objects[i] = this.readId();
        }
        visitor2.visitObjectArrayDump(arrayObjectId, stackTraceSerialNumber, arrayClassObjectId, objects);
    }

    private final void acceptPrimitiveArrayDump(HProfVisitor visitor2) {
        long arrayObjectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long numberOfElements = this.readUnsignedInt();
        int elementTypeId = this.readUnsignedByte();
        Type elementType = Type.Companion.getType(elementTypeId);
        this.skip(numberOfElements * (long)elementType.getSize());
        visitor2.visitPrimitiveArrayDump(arrayObjectId, stackTraceSerialNumber, numberOfElements, elementType);
    }

    private final void acceptClassDump(HProfVisitor visitor2) {
        int n;
        long classId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long superClassId = this.readId();
        long classloaderClassId = this.readId();
        this.skip(this.idSize * 4);
        long instanceSize = this.readUnsignedInt();
        int countOfConstantPool = this.readUnsignedShort();
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[countOfConstantPool];
        for (int i = 0; i < countOfConstantPool; ++i) {
            n = i;
            int constantPoolIndex = this.readUnsignedShort();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            long value2 = this.readTypeSizeValue(elementType);
            constantPoolEntryArray[n] = elementType == Type.OBJECT ? new ConstantPoolEntry(constantPoolIndex, elementType, this.remap(value2)) : new ConstantPoolEntry(constantPoolIndex, elementType, value2);
        }
        ConstantPoolEntry[] constants = constantPoolEntryArray;
        int countOfStaticFields = this.readUnsignedShort();
        StaticFieldEntry[] constantPoolIndex = new StaticFieldEntry[countOfStaticFields];
        for (n = 0; n < countOfStaticFields; ++n) {
            int n2 = n;
            long staticFieldStringId = this.readRawId();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            long value3 = this.readTypeSizeValue(elementType);
            constantPoolIndex[n2] = elementType == Type.OBJECT ? new StaticFieldEntry(staticFieldStringId, elementType, this.remap(value3)) : new StaticFieldEntry(staticFieldStringId, elementType, value3);
        }
        StaticFieldEntry[] staticFields = constantPoolIndex;
        int countOfInstanceFields = this.readUnsignedShort();
        int n3 = 0;
        InstanceFieldEntry[] instanceFieldEntryArray = new InstanceFieldEntry[countOfInstanceFields];
        while (n3 < countOfInstanceFields) {
            int n4 = n3++;
            long fieldNameStringId = this.readRawId();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            instanceFieldEntryArray[n4] = new InstanceFieldEntry(fieldNameStringId, elementType);
        }
        InstanceFieldEntry[] instanceFields = instanceFieldEntryArray;
        visitor2.visitClassDump(classId, stackTraceSerialNumber, superClassId, classloaderClassId, instanceSize, constants, staticFields, instanceFields);
    }

    public final long remap(long id2) {
        LongUnaryOperator longUnaryOperator = this.remapFunction;
        return longUnaryOperator != null ? longUnaryOperator.applyAsLong(id2) : id2;
    }

    private final long readTypeSizeValue(Type elementType) {
        if (elementType == Type.OBJECT) {
            return this.readRawId();
        }
        switch (this.getElementTypeSize(elementType)) {
            case 1: {
                return this.buffer.get();
            }
            case 2: {
                return this.buffer.getShort();
            }
            case 4: {
                return this.buffer.getInt();
            }
            case 8: {
                return this.buffer.getLong();
            }
        }
        throw new IllegalArgumentException("Invalid size of element type.");
    }

    private final int getElementTypeSize(Type elementType) {
        return elementType == Type.OBJECT ? this.idSize : elementType.getSize();
    }

    private final String readNonNullTerminatedString(long length) {
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Strings larger then 2GB not supported.");
        }
        byte[] bytes2 = new byte[(int)length];
        this.buffer.get(bytes2);
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
        Charset charset2 = charset;
        return new String(bytes2, charset2);
    }

    private final void verifyFormat(String version2) {
        if (!Intrinsics.areEqual((Object)version2, (Object)"JAVA PROFILE 1.0.1") && !Intrinsics.areEqual((Object)version2, (Object)"JAVA PROFILE 1.0.2")) {
            throw new RuntimeException("Invalid format. Got: " + version2);
        }
    }

    private final String readNullTerminatedString() {
        byte c = 0;
        long initialPosition = this.buffer.position();
        while ((c = this.buffer.get()) > 0) {
        }
        if (c == -1) {
            throw new EOFException();
        }
        byte[] bytes2 = new byte[(int)(this.buffer.position() - initialPosition - 1L)];
        this.buffer.position(initialPosition);
        this.buffer.get(bytes2);
        this.buffer.get();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
        Charset charset2 = charset;
        return new String(bytes2, charset2);
    }

    private final int readInt() {
        return this.buffer.getInt();
    }

    private final int readUnsignedByte() {
        return Byte.toUnsignedInt(this.readByte());
    }

    private final byte readByte() {
        return this.buffer.get();
    }

    private final long readLong() {
        return this.buffer.getLong();
    }

    private final long readUnsignedInt() {
        return this.buffer.getUnsignedInt();
    }

    private final int readUnsignedShort() {
        return this.buffer.getUnsignedShort();
    }

    private final long readRawId() {
        return this.buffer.getRawId();
    }

    private final long readId() {
        return this.buffer.getId();
    }

    public static final /* synthetic */ long access$getHeapRecordPosition$p(HProfEventBasedParser $this) {
        return $this.heapRecordPosition;
    }

    static {
        Logger logger2 = Logger.getInstance(HProfEventBasedParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(HProfEventBasedParser::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RecordType.values().length];
            try {
                nArray[RecordType.StringInUTF8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.LoadClass.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.UnloadClass.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.HeapDumpSegment.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.HeapDump.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.HeapDumpEnd.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.HeapSummary.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.AllocSites.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.EndThread.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.StackFrame.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.StackTrace.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.CPUSamples.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.StartThread.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.ControlSettings.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HeapDumpRecordType.values().length];
            try {
                nArray[HeapDumpRecordType.RootUnknown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootGlobalJNI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootLocalJNI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootJavaFrame.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootNativeStack.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootStickyClass.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootThreadBlock.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootMonitorUsed.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.RootThreadObject.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.ClassDump.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.InstanceDump.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.ObjectArrayDump.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HeapDumpRecordType.PrimitiveArrayDump.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

