/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.analysis.GCRootPathsTree;
import com.android.tools.idea.diagnostics.hprof.analysis.RefIndexUtil;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.navigator.RootReason;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.IntList;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import com.android.tools.idea.diagnostics.hprof.util.UByteList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\t\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree;", "", "context", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;", "treeDisplayOptions", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "allObjectsOfClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "(Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;)V", "countOfIgnoredObjects", "", "objectSizeStrategy", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "topNode", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode;", "getDisposedDominatorNodes", "", "", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "printTree", "", "registerObject", "", "objectId", "AllObjectsSameSizeStrategy", "DirectByteBufferNativeSizeStrategy", "Edge", "Node", "ObjectSizeCalculationStrategy", "RegularNode", "RootNode", "SizeFromObjectNavigatorStrategy", "Status", "intellij.android.core"})
public final class GCRootPathsTree {
    @NotNull
    private final AnalysisContext context;
    @NotNull
    private final AnalysisConfig.TreeDisplayOptions treeDisplayOptions;
    @NotNull
    private final RootNode topNode;
    private int countOfIgnoredObjects;
    @NotNull
    private final ObjectSizeCalculationStrategy objectSizeStrategy;

    public GCRootPathsTree(@NotNull AnalysisContext context2, @NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @Nullable ClassDefinition allObjectsOfClass) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)treeDisplayOptions, (String)"treeDisplayOptions");
        this.context = context2;
        this.treeDisplayOptions = treeDisplayOptions;
        this.topNode = new RootNode(this.context.getClassStore());
        this.objectSizeStrategy = ObjectSizeCalculationStrategy.Companion.getBestStrategyForClass(allObjectsOfClass);
    }

    public final void registerObject(int objectId) {
        boolean bl;
        ObjectNavigator nav = this.context.getNavigator();
        IntList parentMapping = this.context.getParentList();
        UByteList refIndexMapping = this.context.getRefIndexList();
        IntList sizesMapping = this.context.getSizesList();
        IntOpenHashSet disposedObjectsIDsSet = this.context.getDisposedObjectsIDs();
        TIntArrayList gcPath = new TIntArrayList();
        TIntArrayList fieldsPath = new TIntArrayList();
        TIntArrayList sizesPath = new TIntArrayList();
        int objectIterationId = objectId;
        int parentId2 = parentMapping.get(objectIterationId);
        int maxTreeDepth = this.treeDisplayOptions.getMaximumTreeDepth();
        for (int count2 = 0; count2 < maxTreeDepth && parentId2 != objectIterationId; ++count2) {
            gcPath.add(objectIterationId);
            fieldsPath.add(refIndexMapping.get(objectIterationId));
            sizesPath.add(sizesMapping.get(objectIterationId));
            objectIterationId = parentId2;
            parentId2 = parentMapping.get(objectIterationId);
        }
        fieldsPath.add(251);
        if (parentId2 != objectIterationId) {
            int n = this.countOfIgnoredObjects;
            this.countOfIgnoredObjects = n + 1;
            return;
        }
        gcPath.add(objectIterationId);
        sizesPath.add(sizesMapping.get(objectIterationId));
        boolean bl2 = bl = gcPath.size() == fieldsPath.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int size = this.objectSizeStrategy.calculateObjectSize(nav, objectId);
        Node currentNode = this.topNode;
        for (int i = gcPath.size() - 1; -1 < i; --i) {
            int id2 = gcPath.get(i);
            ClassDefinition classDefinition = nav.getClassForObjectId(id2);
            currentNode = currentNode.addEdge(id2, size, sizesPath.get(i), classDefinition, (byte)fieldsPath.get(i), disposedObjectsIDsSet.contains(id2));
        }
    }

    @NotNull
    public final String printTree() {
        StringBuilder stringBuilder;
        StringBuilder $this$printTree_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.countOfIgnoredObjects > 0) {
            $this$printTree_u24lambda_u240.append("Ignored " + this.countOfIgnoredObjects + " too-deep objects\n");
        }
        Function1 rootReasonGetter2 = (Function1)new Function1<Integer, String>(this){
            final /* synthetic */ GCRootPathsTree this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(int id2) {
                Object object = GCRootPathsTree.access$getContext$p(this.this$0).getNavigator().getRootReasonForObjectId(id2);
                if (object == null || (object = ((RootReason)object).getDescription()) == null) {
                    object = "<Couldn't find root description>";
                }
                return object;
            }
        };
        $this$printTree_u24lambda_u240.append(this.topNode.createHotPathReport(this.treeDisplayOptions, (Function1<? super Integer, String>)rootReasonGetter2));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final Map<ClassDefinition, List<RegularNode>> getDisposedDominatorNodes() {
        HashMap result2 = new HashMap();
        this.topNode.collectDisposedDominatorNodes(result2);
        return result2;
    }

    public static final /* synthetic */ AnalysisContext access$getContext$p(GCRootPathsTree $this) {
        return $this.context;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$AllObjectsSameSizeStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "objectSize", "", "(I)V", "calculateObjectSize", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class AllObjectsSameSizeStrategy
    implements ObjectSizeCalculationStrategy {
        private final int objectSize;

        public AllObjectsSameSizeStrategy(int objectSize) {
            this.objectSize = objectSize;
        }

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
            return this.objectSize;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$DirectByteBufferNativeSizeStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;)V", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class DirectByteBufferNativeSizeStrategy
    implements ObjectSizeCalculationStrategy {
        @NotNull
        private final ClassDefinition classDefinition;

        public DirectByteBufferNativeSizeStrategy(@NotNull ClassDefinition classDefinition) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            boolean bl = Intrinsics.areEqual((Object)this.classDefinition.getName(), (Object)"java.nio.DirectByteBuffer");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
            nav.goTo(id2, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
            boolean bl = Intrinsics.areEqual((Object)nav.getClass(), (Object)this.classDefinition);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return nav.getExtraData() + nav.getObjectSize();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;BZ)V", "getClassDefinition", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "getDisposed", "()Z", "getRefIndex", "()B", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    public static final class Edge {
        @NotNull
        private final ClassDefinition classDefinition;
        private final byte refIndex;
        private final boolean disposed;

        public Edge(@NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            this.refIndex = refIndex;
            this.disposed = disposed;
        }

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        public final byte getRefIndex() {
            return this.refIndex;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        public final byte component2() {
            return this.refIndex;
        }

        public final boolean component3() {
            return this.disposed;
        }

        @NotNull
        public final Edge copy(@NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            return new Edge(classDefinition, refIndex, disposed);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, ClassDefinition classDefinition, byte by, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = edge.classDefinition;
            }
            if ((n & 2) != 0) {
                by = edge.refIndex;
            }
            if ((n & 4) != 0) {
                bl = edge.disposed;
            }
            return edge.copy(classDefinition, by, bl);
        }

        @NotNull
        public String toString() {
            return "Edge(classDefinition=" + this.classDefinition + ", refIndex=" + this.refIndex + ", disposed=" + this.disposed + ")";
        }

        public int hashCode() {
            int result2 = this.classDefinition.hashCode();
            result2 = result2 * 31 + Byte.hashCode(this.refIndex);
            int n = this.disposed ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)edge.classDefinition)) {
                return false;
            }
            if (this.refIndex != edge.refIndex) {
                return false;
            }
            return this.disposed == edge.disposed;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J8\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "intellij.android.core"})
    public static interface Node {
        @NotNull
        public Node addEdge(int var1, int var2, int var3, @NotNull ClassDefinition var4, byte var5, boolean var6);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "Companion", "intellij.android.core"})
    public static interface ObjectSizeCalculationStrategy {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public int calculateObjectSize(@NotNull ObjectNavigator var1, int var2);

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy$Companion;", "", "()V", "getBestStrategyForClass", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "intellij.android.core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final ObjectSizeCalculationStrategy getBestStrategyForClass(@Nullable ClassDefinition classDefinition) {
                if (classDefinition == null || classDefinition.isArray()) {
                    return new SizeFromObjectNavigatorStrategy();
                }
                if (Intrinsics.areEqual((Object)classDefinition.getName(), (Object)"java.nio.DirectByteBuffer")) {
                    return new DirectByteBufferNativeSizeStrategy(classDefinition);
                }
                return new AllObjectsSameSizeStrategy(classDefinition.getInstanceSize() + ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000(0'R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "()V", "edges", "Ljava/util/HashMap;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Ljava/util/HashMap;", "setEdges", "(Ljava/util/HashMap;)V", "instances", "Lgnu/trove/TIntHashSet;", "getInstances", "()Lgnu/trove/TIntHashSet;", "pathsCount", "", "getPathsCount", "()I", "setPathsCount", "(I)V", "pathsSize", "getPathsSize", "setPathsSize", "totalSizeInDwords", "getTotalSizeInDwords", "setTotalSizeInDwords", "addEdge", "objectId", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "collectDisposedDominatorNodes", "", "result", "", "", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nGCRootPathsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCRootPathsTree.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,434:1\n359#2,7:435\n359#2,7:443\n211#3:442\n212#3:450\n*S KotlinDebug\n*F\n+ 1 GCRootPathsTree.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode\n*L\n203#1:435,7\n231#1:443,7\n229#1:442\n229#1:450\n*E\n"})
    public static final class RegularNode
    implements Node {
        @Nullable
        private HashMap<Edge, RegularNode> edges;
        private int pathsCount;
        private int pathsSize;
        private int totalSizeInDwords;
        @NotNull
        private final TIntHashSet instances = new TIntHashSet(1);

        @Nullable
        public final HashMap<Edge, RegularNode> getEdges() {
            return this.edges;
        }

        public final void setEdges(@Nullable HashMap<Edge, RegularNode> hashMap) {
            this.edges = hashMap;
        }

        public final int getPathsCount() {
            return this.pathsCount;
        }

        public final void setPathsCount(int n) {
            this.pathsCount = n;
        }

        public final int getPathsSize() {
            return this.pathsSize;
        }

        public final void setPathsSize(int n) {
            this.pathsSize = n;
        }

        public final int getTotalSizeInDwords() {
            return this.totalSizeInDwords;
        }

        public final void setTotalSizeInDwords(int n) {
            this.totalSizeInDwords = n;
        }

        @NotNull
        public final TIntHashSet getInstances() {
            return this.instances;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Object object;
            void $this$getOrPut$iv22;
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            HashMap<Edge, RegularNode> localEdges = this.edges;
            if (localEdges == null) {
                this.edges = localEdges = new HashMap(1);
            }
            Map map2 = localEdges;
            Edge key$iv = new Edge(classDefinition, refIndex, disposed);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv22.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                RegularNode answer$iv = new RegularNode();
                $this$getOrPut$iv22.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            RegularNode node = (RegularNode)object;
            int $this$getOrPut$iv22 = node.pathsCount;
            node.pathsCount = $this$getOrPut$iv22 + 1;
            node.pathsSize = (long)node.pathsSize + (long)objectSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.pathsSize += objectSize);
            boolean added = node.instances.add(objectId);
            if (added) {
                node.totalSizeInDwords = (long)node.totalSizeInDwords + (long)subgraphSizeInDwords > Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.totalSizeInDwords += subgraphSizeInDwords);
            }
            return node;
        }

        /*
         * WARNING - void declaration
         */
        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            ArrayDeque<RegularNode> stack = new ArrayDeque<RegularNode>();
            stack.push(this);
            while (!((Collection)stack).isEmpty()) {
                RegularNode currentNode = (RegularNode)stack.pop();
                HashMap<Edge, RegularNode> hashMap = currentNode.edges;
                if (hashMap == null) continue;
                Map $this$forEach$iv = hashMap;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    Edge edge = (Edge)entry.getKey();
                    RegularNode childNode = (RegularNode)entry.getValue();
                    if (edge.getDisposed()) {
                        Object object;
                        void $this$getOrPut$iv;
                        Map<ClassDefinition, List<RegularNode>> map2 = result2;
                        ClassDefinition key$iv = edge.getClassDefinition();
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((List)object).add(childNode);
                        continue;
                    }
                    stack.push(childNode);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001c0\u001bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001e0\"J\u007f\u0010#\u001a\u00020\u00192\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020%0\"2\b\u0010&\u001a\u0004\u0018\u00010\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u000e2\b\u0010(\u001a\u0004\u0018\u00010\u000e2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\u000e2\u0006\u0010,\u001a\u00020-2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010.\u001a\u0004\u0018\u00010\u001e2\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00063"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;)V", "edges", "Lgnu/trove/TIntObjectHashMap;", "Lkotlin/Pair;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Lgnu/trove/TIntObjectHashMap;", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "calculateTotalInstanceCount", "collectDisposedDominatorNodes", "", "result", "", "", "createHotPathReport", "", "treeDisplayOptions", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "rootReasonGetter", "Lkotlin/Function1;", "printReportLine", "printFunc", "", "pathsCount", "percent", "instanceSize", "subgraphSize", "", "instanceCount", "status", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status;", "fieldName", "indent", "text", "(Lkotlin/jvm/functions/Function1;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Integer;Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "StackEntry", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nGCRootPathsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCRootPathsTree.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,434:1\n1054#2:435\n777#2:436\n788#2:437\n1860#2,2:438\n789#2,2:440\n1862#2:442\n791#2:443\n1860#2,2:444\n777#2:446\n788#2:447\n1860#2,2:448\n789#2,2:450\n1862#2:452\n791#2:453\n1860#2,3:454\n1862#2:457\n1#3:458\n*S KotlinDebug\n*F\n+ 1 GCRootPathsTree.kt\ncom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode\n*L\n310#1:435\n311#1:436\n311#1:437\n311#1:438,2\n311#1:440,2\n311#1:442\n311#1:443\n316#1:444,2\n367#1:446\n367#1:447\n367#1:448,2\n367#1:450,2\n367#1:452\n367#1:453\n388#1:454,3\n316#1:457\n*E\n"})
    public static final class RootNode
    implements Node {
        @NotNull
        private final ClassStore classStore;
        @NotNull
        private final TIntObjectHashMap<Pair<RegularNode, Edge>> edges;

        public RootNode(@NotNull ClassStore classStore) {
            Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
            this.classStore = classStore;
            this.edges = new TIntObjectHashMap();
        }

        @NotNull
        public final TIntObjectHashMap<Pair<RegularNode, Edge>> getEdges() {
            return this.edges;
        }

        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            Pair pair = (Pair)this.edges.get(objectId);
            RegularNode nullableNode = pair != null ? (RegularNode)pair.getFirst() : null;
            RegularNode node = null;
            if (nullableNode != null) {
                node = nullableNode;
            } else {
                RegularNode newNode = new RegularNode();
                Pair pair2 = new Pair((Object)newNode, (Object)new Edge(classDefinition, refIndex, disposed));
                newNode.getInstances().add(objectId);
                this.edges.put(objectId, (Object)pair2);
                node = newNode;
                node.setTotalSizeInDwords(subgraphSizeInDwords);
            }
            int n = node.getPathsCount();
            node.setPathsCount(n + 1);
            if ((long)node.getPathsSize() + (long)objectSize > Integer.MAX_VALUE) {
                node.setPathsSize(Integer.MAX_VALUE);
            } else {
                node.setPathsSize(node.getPathsSize() + objectSize);
            }
            return node;
        }

        private final int calculateTotalInstanceCount() {
            Ref.IntRef result2 = new Ref.IntRef();
            this.edges.forEachValue(new TObjectProcedure(result2){
                final /* synthetic */ Ref.IntRef $result;
                {
                    this.$result = $result;
                }

                public final boolean execute(Pair<RegularNode, Edge> pair) {
                    RegularNode node = (RegularNode)pair.component1();
                    this.$result.element += node.getPathsCount();
                    return true;
                }
            });
            return result2.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String createHotPathReport(@NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @NotNull Function1<? super Integer, String> rootReasonGetter2) {
            void $this$forEachIndexed$iv;
            Object object;
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv;
            Iterable $this$sortedByDescending$iv;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)treeDisplayOptions, (String)"treeDisplayOptions");
            Intrinsics.checkNotNullParameter(rootReasonGetter2, (String)"rootReasonGetter");
            StringBuilder $this$createHotPathReport_u24lambda_u246 = stringBuilder = new StringBuilder();
            boolean bl = false;
            List rootList = new ArrayList();
            this.edges.forEachEntry(new TIntObjectProcedure(rootList){
                final /* synthetic */ List<Triple<Integer, RegularNode, Edge>> $rootList;
                {
                    this.$rootList = $rootList;
                }

                public final boolean execute(int objectId, Pair<RegularNode, Edge> pair) {
                    RegularNode node = (RegularNode)pair.component1();
                    Edge edge = (Edge)pair.component2();
                    return this.$rootList.add((Triple<Integer, RegularNode, Edge>)new Triple((Object)objectId, (Object)node, (Object)edge));
                }
            });
            int totalInstanceCount = this.calculateTotalInstanceCount();
            int minimumObjectsForReport = Math.min(treeDisplayOptions.getMinimumObjectCount(), (int)(Math.ceil((double)totalInstanceCount / 100.0) * (double)treeDisplayOptions.getMinimumObjectCountPercent()));
            Iterable iterable = rootList;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Triple it = (Triple)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((RegularNode)it.getSecond()).getPathsSize());
                    it = (Triple)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((RegularNode)it.getSecond()).getPathsSize()));
                }
            });
            boolean $i$f$filterIndexed = false;
            void var11_11 = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl2 = false;
                object = (Triple)element$iv$iv;
                int index2 = index$iv$iv;
                boolean bl3 = false;
                RegularNode node = (RegularNode)object.component2();
                boolean bl4 = index2 < treeDisplayOptions.getMinimumPaths() || node.getPathsCount() >= minimumObjectsForReport || node.getPathsSize() >= treeDisplayOptions.getMinimumObjectSize();
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIndexed$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Triple triple = (Triple)item$iv;
                int index3 = n;
                boolean bl5 = false;
                int rootObjectId = ((Number)triple.component1()).intValue();
                RegularNode rootNode = (RegularNode)triple.component2();
                Edge rootEdge = (Edge)triple.component3();
                String rootReasonString = (String)rootReasonGetter2.invoke((Object)rootObjectId);
                int rootPercent = (int)(100.0 * (double)rootNode.getPathsCount() / (double)totalInstanceCount);
                StringBuilder stringBuilder2 = $this$createHotPathReport_u24lambda_u246.append("Root " + (index3 + 1) + ":");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$createHotPathReport_u24lambda_u246){

                    @NotNull
                    public final StringBuilder invoke(@Nullable String p0) {
                        StringBuilder stringBuilder = ((StringBuilder)this.receiver).append(p0);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                        return StringsKt.appendln((StringBuilder)stringBuilder);
                    }
                }), rootNode.getPathsCount(), rootPercent, rootNode.getPathsSize(), (long)rootNode.getTotalSizeInDwords() * (long)4, 1, Status.Companion.getStatus(251, false, false), false, null, "", "ROOT: " + rootReasonString);
                object = new TruncatingPrintBuffer(treeDisplayOptions.getHeadLimit(), treeDisplayOptions.getTailLimit(), (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$createHotPathReport_u24lambda_u246){

                    @NotNull
                    public final StringBuilder invoke(@Nullable String p0) {
                        StringBuilder stringBuilder = ((StringBuilder)this.receiver).append(p0);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                        return StringsKt.appendln((StringBuilder)stringBuilder);
                    }
                }));
                Throwable throwable = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object;
                    boolean bl6 = false;
                    ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
                    stack.push(new StackEntry(null, rootEdge, rootNode, "", ""));
                    while (!stack.isEmpty()) {
                        void $this$filterIndexedTo$iv$iv2;
                        void $this$filterIndexed$iv2;
                        HashMap<Edge, RegularNode> currentNodeEdges;
                        StackEntry stackEntry = (StackEntry)stack.pop();
                        ClassDefinition parentClass = stackEntry.component1();
                        Edge edge = stackEntry.component2();
                        RegularNode node = stackEntry.component3();
                        String indent = stackEntry.component4();
                        String nextIndent = stackEntry.component5();
                        ClassDefinition classDefinition = edge.component1();
                        byte refIndexByte = edge.component2();
                        boolean disposed = edge.component3();
                        int refIndex = Byte.toUnsignedInt(refIndexByte);
                        this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>((Object)buffer){

                            public final void invoke(@NotNull String p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                ((TruncatingPrintBuffer)this.receiver).println(p0);
                            }
                        }), node.getPathsCount(), (int)(100.0 * (double)node.getPathsCount() / (double)totalInstanceCount), node.getPathsSize(), (long)node.getTotalSizeInDwords() * (long)4, node.getInstances().size(), Status.Companion.getStatus(refIndex, node.getEdges() == null, disposed), disposed, RefIndexUtil.INSTANCE.getFieldDescription(refIndex, parentClass, this.classStore), indent, classDefinition.getPrettyName());
                        if (node.getEdges() == null) continue;
                        Set<Map.Entry<Edge, RegularNode>> set = currentNodeEdges.entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"currentNodeEdges\n                  .entries");
                        Iterable iterable2 = CollectionsKt.sortedWith((Iterable)set, (Comparator)createHotPathReport.1.4.3.childrenToReport.1.INSTANCE);
                        boolean $i$f$filterIndexed2 = false;
                        void var41_54 = $this$filterIndexed$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIndexedTo2 = false;
                        void $this$forEachIndexed$iv$iv$iv2 = $this$filterIndexedTo$iv$iv2;
                        boolean $i$f$forEachIndexed32 = false;
                        int index$iv$iv$iv2 = 0;
                        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv2) {
                            void e;
                            void element$iv$iv;
                            int n2;
                            if ((n2 = index$iv$iv$iv2++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Object t = item$iv$iv$iv;
                            int index$iv$iv = n2;
                            boolean bl7 = false;
                            Map.Entry entry = (Map.Entry)element$iv$iv;
                            int index4 = index$iv$iv;
                            boolean bl8 = false;
                            boolean bl9 = index4 == 0 || ((RegularNode)e.getValue()).getPathsCount() >= minimumObjectsForReport || ((RegularNode)e.getValue()).getPathsSize() >= treeDisplayOptions.getMinimumObjectSize() || (long)((RegularNode)e.getValue()).getTotalSizeInDwords() * (long)4 >= treeDisplayOptions.getMinimumSubgraphSize();
                            if (!bl9) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        List childrenToReport2 = CollectionsKt.asReversed((List)((List)destination$iv$iv2));
                        if (childrenToReport2.size() == 1 && treeDisplayOptions.getSmartIndent()) {
                            Object k = ((Map.Entry)childrenToReport2.get(0)).getKey();
                            Intrinsics.checkNotNullExpressionValue(k, (String)"childrenToReport[0].key");
                            Edge edge2 = (Edge)k;
                            Object v = ((Map.Entry)childrenToReport2.get(0)).getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"childrenToReport[0].value");
                            stack.push(new StackEntry(classDefinition, edge2, (RegularNode)v, nextIndent, nextIndent));
                            continue;
                        }
                        if (nextIndent.length() >= treeDisplayOptions.getMaximumIndent()) {
                            this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>((Object)buffer){

                                public final void invoke(@NotNull String p0) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    ((TruncatingPrintBuffer)this.receiver).println(p0);
                                }
                            }), null, null, null, null, null, Status.LastInPath, null, null, nextIndent, "\\-[...]");
                            continue;
                        }
                        Iterable $this$forEachIndexed$iv2 = childrenToReport2;
                        boolean $i$f$forEachIndexed4 = false;
                        int index$iv2 = 0;
                        for (Object item$iv2 : $this$forEachIndexed$iv2) {
                            void e;
                            int n3;
                            if ((n3 = index$iv2++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Map.Entry $i$f$forEachIndexed32 = (Map.Entry)item$iv2;
                            int index5 = n3;
                            boolean bl10 = false;
                            if (index5 == 0) {
                                Object k = e.getKey();
                                Intrinsics.checkNotNullExpressionValue(k, (String)"e.key");
                                Edge edge3 = (Edge)k;
                                Object v = e.getValue();
                                Intrinsics.checkNotNullExpressionValue(v, (String)"e.value");
                                stack.push(new StackEntry(classDefinition, edge3, (RegularNode)v, nextIndent + "\\-", nextIndent + "  "));
                                continue;
                            }
                            Object k = e.getKey();
                            Intrinsics.checkNotNullExpressionValue(k, (String)"e.key");
                            Edge edge4 = (Edge)k;
                            Object v = e.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"e.value");
                            stack.push(new StackEntry(classDefinition, edge4, (RegularNode)v, nextIndent + "+-", nextIndent + "| "));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private final void printReportLine(Function1<? super String, ? extends Object> printFunc, Integer pathsCount, Integer percent, Integer instanceSize, Long subgraphSize, Integer instanceCount, Status status2, Boolean disposed, String fieldName, String indent, String text2) {
            Object object;
            String disposedString;
            Object fieldNameString;
            String instanceCountString;
            String instanceSizeString;
            String percentString;
            String pathsCountString;
            block20: {
                block19: {
                    Object object2;
                    block18: {
                        block17: {
                            Object object3;
                            block16: {
                                block15: {
                                    Object object4;
                                    block14: {
                                        block13: {
                                            object4 = pathsCount;
                                            if (object4 == null) break block13;
                                            int it = ((Number)object4).intValue();
                                            boolean bl = false;
                                            String string = HeapReportUtils.INSTANCE.toShortStringAsCount(it);
                                            object4 = string;
                                            if (string != null) break block14;
                                        }
                                        object4 = "";
                                    }
                                    pathsCountString = StringsKt.padStart$default((String)object4, (int)5, (char)'\u0000', (int)2, null);
                                    object3 = percent;
                                    if (object3 == null) break block15;
                                    int it = ((Number)object3).intValue();
                                    boolean bl = false;
                                    String string = it + "%";
                                    object3 = string;
                                    if (string != null) break block16;
                                }
                                object3 = "";
                            }
                            percentString = StringsKt.padStart$default((String)object3, (int)4, (char)'\u0000', (int)2, null);
                            object2 = instanceSize;
                            if (object2 == null) break block17;
                            int it = ((Number)object2).intValue();
                            boolean bl = false;
                            String string = HeapReportUtils.INSTANCE.toShortStringAsSize(it);
                            object2 = string;
                            if (string != null) break block18;
                        }
                        object2 = "";
                    }
                    instanceSizeString = StringsKt.padStart$default((String)object2, (int)6, (char)'\u0000', (int)2, null);
                    Object object5 = instanceCount;
                    if (object5 == null) {
                        object5 = "";
                    }
                    instanceCountString = StringsKt.padStart$default((String)object5.toString(), (int)10, (char)'\u0000', (int)2, null);
                    String string = fieldName;
                    fieldNameString = string != null ? string + ": " : "";
                    disposedString = Intrinsics.areEqual((Object)disposed, (Object)true) ? " (disposed)" : "";
                    object = subgraphSize;
                    if (object == null) break block19;
                    long it = ((Number)object).longValue();
                    boolean bl = false;
                    String string2 = HeapReportUtils.INSTANCE.toShortStringAsSize(it);
                    object = string2;
                    if (string2 != null) break block20;
                }
                object = "";
            }
            String subgraphSizeString = StringsKt.padStart$default((String)object, (int)6, (char)'\u0000', (int)2, null);
            printFunc.invoke((Object)("[" + pathsCountString + "/" + percentString + "/" + instanceSizeString + "] " + subgraphSizeString + " " + instanceCountString + " " + status2 + " " + indent + (String)fieldNameString + text2 + disposedString));
        }

        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this.edges.forEachValue(new TObjectProcedure(result2){
                final /* synthetic */ Map<ClassDefinition, List<RegularNode>> $result;
                {
                    this.$result = $result;
                }

                /*
                 * WARNING - void declaration
                 */
                public final boolean execute(Pair<RegularNode, Edge> pair) {
                    RegularNode node = (RegularNode)pair.component1();
                    Edge edge = (Edge)pair.component2();
                    if (edge.getDisposed()) {
                        Object object;
                        void $this$getOrPut$iv;
                        Map<ClassDefinition, List<RegularNode>> map2 = this.$result;
                        ClassDefinition key$iv = edge.getClassDefinition();
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            List answer$iv = new ArrayList<E>();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((List)object).add(node);
                    } else {
                        node.collectDisposedDominatorNodes(this.$result);
                    }
                    return true;
                }
            });
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode$StackEntry;", "", "parentClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "edge", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "node", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "indent", "", "nextIndent", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;Ljava/lang/String;Ljava/lang/String;)V", "getEdge", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getIndent", "()Ljava/lang/String;", "getNextIndent", "getNode", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "getParentClass", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
        public static final class StackEntry {
            @Nullable
            private final ClassDefinition parentClass;
            @NotNull
            private final Edge edge;
            @NotNull
            private final RegularNode node;
            @NotNull
            private final String indent;
            @NotNull
            private final String nextIndent;

            public StackEntry(@Nullable ClassDefinition parentClass, @NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
                Intrinsics.checkNotNullParameter((Object)nextIndent, (String)"nextIndent");
                this.parentClass = parentClass;
                this.edge = edge;
                this.node = node;
                this.indent = indent;
                this.nextIndent = nextIndent;
            }

            @Nullable
            public final ClassDefinition getParentClass() {
                return this.parentClass;
            }

            @NotNull
            public final Edge getEdge() {
                return this.edge;
            }

            @NotNull
            public final RegularNode getNode() {
                return this.node;
            }

            @NotNull
            public final String getIndent() {
                return this.indent;
            }

            @NotNull
            public final String getNextIndent() {
                return this.nextIndent;
            }

            @Nullable
            public final ClassDefinition component1() {
                return this.parentClass;
            }

            @NotNull
            public final Edge component2() {
                return this.edge;
            }

            @NotNull
            public final RegularNode component3() {
                return this.node;
            }

            @NotNull
            public final String component4() {
                return this.indent;
            }

            @NotNull
            public final String component5() {
                return this.nextIndent;
            }

            @NotNull
            public final StackEntry copy(@Nullable ClassDefinition parentClass, @NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
                Intrinsics.checkNotNullParameter((Object)nextIndent, (String)"nextIndent");
                return new StackEntry(parentClass, edge, node, indent, nextIndent);
            }

            public static /* synthetic */ StackEntry copy$default(StackEntry stackEntry, ClassDefinition classDefinition, Edge edge, RegularNode regularNode, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    classDefinition = stackEntry.parentClass;
                }
                if ((n & 2) != 0) {
                    edge = stackEntry.edge;
                }
                if ((n & 4) != 0) {
                    regularNode = stackEntry.node;
                }
                if ((n & 8) != 0) {
                    string = stackEntry.indent;
                }
                if ((n & 0x10) != 0) {
                    string2 = stackEntry.nextIndent;
                }
                return stackEntry.copy(classDefinition, edge, regularNode, string, string2);
            }

            @NotNull
            public String toString() {
                return "StackEntry(parentClass=" + this.parentClass + ", edge=" + this.edge + ", node=" + this.node + ", indent=" + this.indent + ", nextIndent=" + this.nextIndent + ")";
            }

            public int hashCode() {
                int result2 = this.parentClass == null ? 0 : this.parentClass.hashCode();
                result2 = result2 * 31 + this.edge.hashCode();
                result2 = result2 * 31 + this.node.hashCode();
                result2 = result2 * 31 + this.indent.hashCode();
                result2 = result2 * 31 + this.nextIndent.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StackEntry)) {
                    return false;
                }
                StackEntry stackEntry = (StackEntry)other;
                if (!Intrinsics.areEqual((Object)this.parentClass, (Object)stackEntry.parentClass)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.edge, (Object)stackEntry.edge)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.node, (Object)stackEntry.node)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.indent, (Object)stackEntry.indent)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.nextIndent, (Object)stackEntry.nextIndent);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$SizeFromObjectNavigatorStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "()V", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class SizeFromObjectNavigatorStrategy
    implements ObjectSizeCalculationStrategy {
        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
            nav.goTo(id2, ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            return nav.getObjectSize();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0001\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status;", "", "(Ljava/lang/String;I)V", "getStatusCharacter", "", "toString", "", "None", "Warning", "LastInPath", "Companion", "intellij.android.core"})
    private static final class Status
    extends Enum<Status> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ Status None;
        public static final /* enum */ Status Warning;
        public static final /* enum */ Status LastInPath;
        private static final /* synthetic */ Status[] $VALUES;

        @NotNull
        public String toString() {
            return String.valueOf(this.getStatusCharacter());
        }

        public final char getStatusCharacter() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> ' ';
                case 2 -> '!';
                case 3 -> '*';
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value2) {
            return Enum.valueOf(Status.class, value2);
        }

        static {
            None = new Status();
            Warning = new Status();
            LastInPath = new Status();
            $VALUES = statusArray = new Status[]{Status.None, Status.Warning, Status.LastInPath};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status$Companion;", "", "()V", "getStatus", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status;", "refIndex", "", "lastInPath", "", "disposed", "intellij.android.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Status getStatus(int refIndex, boolean lastInPath, boolean disposed) {
                return lastInPath ? LastInPath : (disposed ? Warning : (refIndex == 252 ? Warning : (refIndex == 253 ? Warning : None)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Status.values().length];
                try {
                    nArray[Status.None.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.Warning.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.LastInPath.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

