/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

class HeapTraverseNode {
    @NotNull
    private final WeakReference<?> weakReference;
    public RefWeight ownershipWeight;
    public long ownedByComponentMask;
    public long retainedMask;
    public int retainedMaskForCategories;
    public final long tag;
    public boolean isMergePoint;

    HeapTraverseNode(Object obj, @NotNull RefWeight ownershipWeight, long ownedByComponentMask, long retainedMask, int retainedMaskForCategories, long tag, boolean isMergePoint) {
        this.weakReference = new WeakReference<Object>(obj);
        this.ownershipWeight = ownershipWeight;
        this.ownedByComponentMask = ownedByComponentMask;
        this.retainedMask = retainedMask;
        this.retainedMaskForCategories = retainedMaskForCategories;
        this.tag = tag;
        this.isMergePoint = isMergePoint;
    }

    HeapTraverseNode(Object obj, int ownershipWeightIntValue, long ownedByComponentMask, long retainedMask, int retainedMaskForCategories, long tag, boolean isMergePoint) {
        this(obj, HeapTraverseNode.refWeightFromInt(ownershipWeightIntValue), ownedByComponentMask, retainedMask, retainedMaskForCategories, tag, isMergePoint);
    }

    Object getObject() {
        return this.weakReference.get();
    }

    private static RefWeight refWeightFromInt(int refWeightInt) {
        switch (refWeightInt) {
            case 1: {
                return RefWeight.NON_COMPONENT;
            }
            case 2: {
                return RefWeight.SYNTHETIC;
            }
            case 3: {
                return RefWeight.ARRAY_ELEMENT;
            }
            case 4: {
                return RefWeight.INSTANCE_FIELD;
            }
            case 5: {
                return RefWeight.STATIC_FIELD;
            }
            case 6: {
                return RefWeight.DISPOSER_TREE_REFERENCE;
            }
        }
        return RefWeight.DEFAULT;
    }

    static native void cacheHeapSnapshotTraverseNodeConstructorId(Class<?> var0);

    static native void clearObjectIdToTraverseNodeMap();

    static native void putOrUpdateObjectIdToTraverseNodeMap(int var0, @NotNull Object var1, int var2, long var3, long var5, int var7, long var8, boolean var10);

    static native int getObjectIdToTraverseNodeMapSize();

    static native void removeElementFromObjectIdToTraverseNodeMap(int var0);

    static native HeapTraverseNode getObjectIdToTraverseNodeMapElement(int var0, Class<?> var1);

    public static enum RefWeight {
        DEFAULT(0),
        NON_COMPONENT(1),
        SYNTHETIC(2),
        ARRAY_ELEMENT(3),
        INSTANCE_FIELD(4),
        STATIC_FIELD(5),
        DISPOSER_TREE_REFERENCE(6);

        private final int value;

        private RefWeight(int value2) {
            this.value = value2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

