/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.FieldCache;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverse;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseNode;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapTraverseChildProcessor {
    private static final Set<String> REFERENCE_CLASS_FIELDS_TO_IGNORE = Set.of("referent", "discovered", "next");
    @NotNull
    private final Object myDisposerTree = Disposer.getTree();
    private final boolean myShouldUseDisposerTreeReferences = (Boolean)StudioFlags.USE_DISPOSER_TREE_REFERENCES.get();
    @NotNull
    private final HeapSnapshotStatistics myStatistics;

    public HeapTraverseChildProcessor(@NotNull HeapSnapshotStatistics statistics) {
        this.myStatistics = statistics;
    }

    void processChildObjects(@Nullable Object obj, @NotNull BiConsumer<Object, HeapTraverseNode.RefWeight> consumer, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        if (obj == null) {
            return;
        }
        if (obj == this.myDisposerTree) {
            return;
        }
        Class<?> nodeClass = obj.getClass();
        boolean objIsReference = obj instanceof Reference;
        for (Field field2 : fieldCache.getInstanceFields(nodeClass)) {
            if (objIsReference && REFERENCE_CLASS_FIELDS_TO_IGNORE.contains(field2.getName())) continue;
            try {
                Object value2 = field2.get(obj);
                consumer.accept(value2, HeapTraverseNode.RefWeight.INSTANCE_FIELD);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.myStatistics.incrementUnsuccessfulFieldAccessCounter();
            }
        }
        if (nodeClass.isArray() && !HeapTraverseUtil.isArrayOfPrimitives(nodeClass)) {
            for (Object value3 : (Object[])obj) {
                consumer.accept(value3, HeapTraverseNode.RefWeight.ARRAY_ELEMENT);
            }
        }
        if (obj instanceof Class && HeapSnapshotTraverse.isClassInitialized((Class)obj)) {
            for (Object fieldValue : fieldCache.getStaticFields((Class)obj)) {
                if (fieldValue == null) continue;
                consumer.accept(fieldValue, HeapTraverseNode.RefWeight.STATIC_FIELD);
            }
        }
        if (this.myShouldUseDisposerTreeReferences && obj instanceof Disposable) {
            Object objToNodeMap = HeapTraverseUtil.getFieldValue(this.myDisposerTree, "myObject2NodeMap");
            if (!(objToNodeMap instanceof Map)) {
                return;
            }
            Object disposableTreeNode = ((Map)objToNodeMap).get(obj);
            if (disposableTreeNode == null) {
                return;
            }
            Object disposableTreeNodeChildren = HeapTraverseUtil.getFieldValue(disposableTreeNode, "myChildren");
            if (!(disposableTreeNodeChildren instanceof List)) {
                return;
            }
            for (Object child : (List)disposableTreeNodeChildren) {
                Object currDisposable = HeapTraverseUtil.getFieldValue(child, "myObject");
                if (!(currDisposable instanceof Disposable)) continue;
                consumer.accept(currDisposable, HeapTraverseNode.RefWeight.DISPOSER_TREE_REFERENCE);
            }
        }
    }
}

