/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverse;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.IntegrationTestCollectMemoryUsageStatisticsAction;
import com.android.tools.idea.util.StudioPathManager;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import com.intellij.util.system.CpuArch;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeapSnapshotTraverseService {
    private static final long REPORT_COLLECTION_DELAY_MILLISECONDS = Duration.ofMinutes(30L).toMillis();
    private static final String COLLECT_AND_LOG_EXTENDED_MEMORY_REPORTS = "studio.collect.extended.memory.reports";
    private static final String DIAGNOSTICS_HEAP_NATIVE_PATH = "tools/adt/idea/android/src/com/android/tools/idea/diagnostics/heap/native";
    private static final String MEMORY_USAGE_REPORT_FAILURE_MESSAGE_PREFIX = "Memory usage report collection failed: ";
    private static final String JNI_OBJECT_TAGGER_LIB_NAME = "jni_object_tagger";
    private static final String RESOURCES_NATIVE_PATH = "plugins/android/resources/native";
    private static final Logger LOG = Logger.getInstance(HeapSnapshotTraverseService.class);
    @NotNull
    private final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private boolean triedToLoadAgent = false;
    private boolean agentSuccessfullyLoaded = false;

    HeapSnapshotTraverseService() {
    }

    public void registerIntegrationTestCollectMemoryUsageStatisticsAction() {
        ActionManager.getInstance().registerAction("IntegrationTestCollectMemoryUsageStatisticsAction", (AnAction)new IntegrationTestCollectMemoryUsageStatisticsAction());
    }

    @NotNull
    public static HeapSnapshotTraverseService getInstance() {
        return (HeapSnapshotTraverseService)ApplicationManager.getApplication().getService(HeapSnapshotTraverseService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadObjectTaggingAgent() {
        if (this.triedToLoadAgent) {
            return;
        }
        this.triedToLoadAgent = true;
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        String pid = vmName.substring(0, vmName.indexOf(64));
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(pid);
            Path libLocationPath = HeapSnapshotTraverseService.getLibLocation();
            if (libLocationPath == null) {
                HeapSnapshotTraverseService.sendMemoryCollectionFailureReport(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.AGENT_LOAD_FAILED);
                return;
            }
            vm.loadAgentPath(libLocationPath.toString());
            this.agentSuccessfullyLoaded = true;
        }
        catch (AgentInitializationException | AgentLoadException | AttachNotSupportedException | IOException e) {
            HeapSnapshotTraverseService.sendMemoryCollectionFailureReport(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.AGENT_LOAD_FAILED);
        }
        finally {
            if (vm != null) {
                try {
                    vm.detach();
                }
                catch (IOException e) {
                    LOG.warn("Failed to detach the VM after loading the object tagging agent", (Throwable)e);
                }
            }
        }
    }

    public void collectAndLogMemoryReport() {
        this.loadObjectTaggingAgent();
        if (!this.agentSuccessfullyLoaded) {
            return;
        }
        HeapSnapshotStatistics stats = new HeapSnapshotStatistics(new HeapTraverseConfig(ComponentsSet.buildComponentSetForIntegrationTesting(), true, true));
        HeapSnapshotTraverse.collectAndWriteStats(arg_0 -> ((Logger)LOG).info(arg_0), stats, new HeapSnapshotTraverse.HeapSnapshotPresentationConfig(HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.OPTIMAL_UNITS, true, false));
    }

    public void collectMemoryReportAndDumpToMetricsFile() {
        try (BufferedWriter writer2 = new BufferedWriter(new FileWriter(new File(PathManager.getLogPath(), "memory_usage_report.log"), StandardCharsets.UTF_8));){
            this.loadObjectTaggingAgent();
            if (!this.agentSuccessfullyLoaded) {
                writer2.append(MEMORY_USAGE_REPORT_FAILURE_MESSAGE_PREFIX).append("Failed to load agent").append("\n");
                return;
            }
            HeapSnapshotStatistics statistics = Boolean.getBoolean(COLLECT_AND_LOG_EXTENDED_MEMORY_REPORTS) ? new HeapSnapshotStatistics(new HeapTraverseConfig(ComponentsSet.buildComponentSetForIntegrationTesting(), true, true)) : new HeapSnapshotStatistics(ComponentsSet.buildComponentSetForIntegrationTesting());
            HeapSnapshotTraverse.collectAndWriteStats(s -> {
                try {
                    writer2.append((CharSequence)s).append("\n");
                }
                catch (IOException e) {
                    LOG.warn(String.format("%s Failed to write to the memory report file", MEMORY_USAGE_REPORT_FAILURE_MESSAGE_PREFIX), (Throwable)e);
                }
            }, statistics, new HeapSnapshotTraverse.HeapSnapshotPresentationConfig(HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.BYTES, false, false));
        }
        catch (IOException e) {
            LOG.error("Failed to write to the memory report file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerThreadPriorityAndCollectMemoryReport() {
        if (PowerSaveMode.isEnabled()) {
            HeapSnapshotTraverseService.sendMemoryCollectionFailureReport(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.POWER_SAVING_MODE_ENABLED);
            return;
        }
        Thread currentThread = Thread.currentThread();
        int oldThreadPriority = currentThread.getPriority();
        try {
            currentThread.setPriority(1);
            this.loadObjectTaggingAgent();
            if (!this.agentSuccessfullyLoaded) {
                return;
            }
            HeapSnapshotStatistics stats = new HeapSnapshotStatistics(ComponentsSet.buildComponentSet());
            MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = HeapSnapshotTraverse.collectMemoryReport(stats, HeapSnapshotTraverse.getLoadedClassesComputable);
            if (statusCode == MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.NO_ERROR) {
                this.addMemoryReportCollectionRequest();
            }
        }
        finally {
            currentThread.setPriority(oldThreadPriority);
        }
    }

    public void addMemoryReportCollectionRequest() {
        this.alarm.addRequest(this::lowerThreadPriorityAndCollectMemoryReport, REPORT_COLLECTION_DELAY_MILLISECONDS);
    }

    @NotNull
    private static String getLibName() {
        return System.mapLibraryName(JNI_OBJECT_TAGGER_LIB_NAME);
    }

    @NotNull
    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return CpuArch.isArm64() ? "mac_arm" : "mac";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        return "";
    }

    @Nullable
    private static Path getLibLocation() {
        String libName = HeapSnapshotTraverseService.getLibName();
        Path homePath = Paths.get(PathManager.getHomePath(), new String[0]);
        Path libFile = homePath.resolve(RESOURCES_NATIVE_PATH).resolve(libName);
        if (Files.exists(libFile, new LinkOption[0])) {
            return libFile;
        }
        if (StudioPathManager.isRunningFromSources() && Files.exists(libFile = StudioPathManager.resolvePathFromSourcesRoot((String)DIAGNOSTICS_HEAP_NATIVE_PATH).resolve(HeapSnapshotTraverseService.getPlatformName()).resolve(libName), new LinkOption[0])) {
            return libFile;
        }
        return null;
    }

    private static void sendMemoryCollectionFailureReport(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode) {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.MEMORY_USAGE_REPORT_EVENT).setMemoryUsageReportEvent(MemoryUsageReportEvent.newBuilder().setMetadata(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.newBuilder().setStatusCode(statusCode))));
    }
}

