/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.FieldCache;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseChildProcessor;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.HeapTraverseNode;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.StackNode;
import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class HeapSnapshotTraverse
implements Disposable {
    static final Computable<WeakList<Object>> getLoadedClassesComputable = () -> {
        WeakList roots = new WeakList();
        Class<?>[] classes2 = HeapSnapshotTraverse.getClasses();
        roots.addAll(Arrays.asList(classes2));
        roots.addAll(Thread.getAllStackTraces().keySet());
        roots.addAll((Collection)Arrays.stream(classes2).filter(c -> c instanceof Class).map(c -> ((Class)c).getClassLoader()).collect(Collectors.toSet()));
        return roots;
    };
    private static final int MAX_ALLOWED_OBJECT_MAP_SIZE = 1000000;
    private static final int INVALID_OBJECT_ID = -1;
    private static final int INVALID_OBJECT_TAG = -1;
    private static final int MAX_DEPTH = 100000;
    private static final long CURRENT_ITERATION_ID_MASK = 255L;
    private static final long CURRENT_ITERATION_VISITED_MASK = 256L;
    private static final long CURRENT_ITERATION_OBJECT_ID_MASK = 2199023255040L;
    private static final int CURRENT_ITERATION_OBJECT_ID_OFFSET = 9;
    private static short ourIterationId = 0;
    @NotNull
    private final LowMemoryWatcher watcher = LowMemoryWatcher.register(this::onLowMemorySignalReceived);
    @NotNull
    private final MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
    @NotNull
    private final HeapTraverseChildProcessor heapTraverseChildProcessor;
    private final short iterationId;
    @NotNull
    private final HeapSnapshotStatistics statistics;
    private volatile boolean shouldAbortTraversal = false;
    private int lastObjectId = 0;

    public HeapSnapshotTraverse(@NotNull HeapSnapshotStatistics statistics) {
        this(new HeapTraverseChildProcessor(statistics), statistics);
    }

    public HeapSnapshotTraverse(@NotNull HeapTraverseChildProcessor childProcessor, @NotNull HeapSnapshotStatistics statistics) {
        this.messageBusConnection.subscribe(PowerSaveMode.TOPIC, () -> {
            if (PowerSaveMode.isEnabled()) {
                this.shouldAbortTraversal = true;
                this.messageBusConnection.disconnect();
            }
        });
        this.heapTraverseChildProcessor = childProcessor;
        this.iterationId = HeapSnapshotTraverse.getNextIterationId();
        this.statistics = statistics;
    }

    @TestOnly
    MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode walkObjects(int maxDepth, @NotNull List<Object> roots) {
        WeakList classes2 = new WeakList();
        classes2.addAll(roots);
        return this.walkObjects(maxDepth, (Computable<WeakList<Object>>)((Computable)() -> classes2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode walkObjects(int maxDepth, @NotNull Computable<WeakList<Object>> rootsComputable) {
        try {
            if (!HeapSnapshotTraverse.canTagObjects()) {
                MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.CANT_TAG_OBJECTS;
                return statusCode;
            }
            try {
                StackNode.cacheStackNodeConstructorId(StackNode.class);
                FieldCache fieldCache = new FieldCache(this.statistics);
                StackNode.clearDepthFirstSearchStack();
                HeapTraverseNode.clearObjectIdToTraverseNodeMap();
                HeapTraverseNode.cacheHeapSnapshotTraverseNodeConstructorId(HeapTraverseNode.class);
                WeakList startRoots = (WeakList)rootsComputable.compute();
                for (Object root : startRoots) {
                    long rootTag;
                    if (root == null || (rootTag = this.depthFirstTraverseHeapObjects(root, maxDepth, fieldCache)) == -1L) continue;
                    int rootObjectId = this.getObjectId(rootTag);
                    if (rootObjectId <= 0 || rootObjectId > this.lastObjectId) {
                        MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.WRONG_ROOT_OBJECT_ID;
                        return statusCode;
                    }
                    HeapTraverseNode.putOrUpdateObjectIdToTraverseNodeMap(rootObjectId, root, HeapTraverseNode.RefWeight.DEFAULT.getValue(), 0L, 0L, 0, rootTag, this.statistics.getConfig().getComponentsSet().getComponentOfObject(root) != null);
                }
                this.statistics.setHeapObjectCount(this.lastObjectId);
                this.statistics.setTraverseSessionId(this.iterationId);
                for (int i = this.lastObjectId; i > 0; --i) {
                    boolean objectIsAComponentRoot;
                    this.abortTraversalIfRequested();
                    int mapSize = HeapTraverseNode.getObjectIdToTraverseNodeMapSize();
                    this.statistics.updateMaxObjectsQueueSize(mapSize);
                    if (mapSize > 1000000) {
                        MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode rootTag = MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.OBJECTS_MAP_IS_TOO_BIG;
                        return rootTag;
                    }
                    HeapTraverseNode node = HeapTraverseNode.getObjectIdToTraverseNodeMapElement(i, HeapTraverseNode.class);
                    if (node == null) {
                        this.statistics.incrementGarbageCollectedObjectsCounter();
                        continue;
                    }
                    HeapTraverseNode.removeElementFromObjectIdToTraverseNodeMap(i);
                    Object currentObject = node.getObject();
                    if (currentObject == null) {
                        this.statistics.incrementGarbageCollectedObjectsCounter();
                        continue;
                    }
                    HeapSnapshotTraverse.setObjectTag(currentObject, 0L);
                    ComponentsSet.Component currentObjectComponent = this.statistics.getConfig().getComponentsSet().getComponentOfObject(currentObject);
                    long currentObjectSize = HeapSnapshotTraverse.getObjectSize(currentObject);
                    String currentObjectClassName = currentObject.getClass().getName();
                    this.statistics.addObjectToTotal(currentObjectSize);
                    if (this.statistics.getConfig().collectDisposerTreeInfo && currentObject instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)currentObject))) {
                        this.statistics.addDisposedButReferencedObject(currentObjectSize, currentObjectClassName);
                    }
                    boolean bl = objectIsAComponentRoot = currentObjectComponent != null;
                    if (objectIsAComponentRoot) {
                        this.updateComponentRootMasks(node, currentObjectComponent, HeapTraverseNode.RefWeight.DEFAULT);
                    }
                    HeapTraverseUtil.processMask(node.retainedMask, index2 -> this.statistics.addRetainedObjectSizeToComponent((int)index2, currentObjectSize));
                    HeapTraverseUtil.processMask(node.retainedMaskForCategories, index2 -> this.statistics.addRetainedObjectSizeToCategoryComponent((int)index2, currentObjectSize));
                    AtomicInteger categoricalOwnedMask = new AtomicInteger();
                    HeapTraverseUtil.processMask(node.ownedByComponentMask, index2 -> categoricalOwnedMask.set(categoricalOwnedMask.get() | 1 << this.statistics.getConfig().getComponentsSet().getComponents().get((int)index2).getComponentCategory().getId()));
                    if (categoricalOwnedMask.get() != 0 && LongMath.isPowerOfTwo((long)categoricalOwnedMask.get())) {
                        HeapTraverseUtil.processMask(categoricalOwnedMask.get(), index2 -> this.statistics.addOwnedObjectSizeToCategoryComponent((int)index2, currentObjectSize, currentObjectClassName, node.isMergePoint));
                    }
                    if (node.ownedByComponentMask == 0L) {
                        int uncategorizedComponentId = this.statistics.getConfig().getComponentsSet().getUncategorizedComponent().getId();
                        int uncategorizedCategoryId = this.statistics.getConfig().getComponentsSet().getUncategorizedComponent().getComponentCategory().getId();
                        this.statistics.addOwnedObjectSizeToComponent(uncategorizedComponentId, currentObjectSize, currentObjectClassName, false);
                        this.statistics.addOwnedObjectSizeToCategoryComponent(uncategorizedCategoryId, currentObjectSize, currentObjectClassName, false);
                    } else if (LongMath.isPowerOfTwo((long)node.ownedByComponentMask)) {
                        HeapTraverseUtil.processMask(node.ownedByComponentMask, index2 -> this.statistics.addOwnedObjectSizeToComponent((int)index2, currentObjectSize, currentObjectClassName, objectIsAComponentRoot));
                    } else {
                        this.statistics.addObjectSizeToSharedComponent(node.ownedByComponentMask, currentObjectSize, currentObjectClassName, node.isMergePoint);
                    }
                    this.propagateComponentMask(currentObject, node, i, fieldCache);
                }
                this.statistics.addDisposerTreeInfo(Disposer.getTree());
                return MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.NO_ERROR;
            }
            finally {
                StackNode.clearDepthFirstSearchStack();
                HeapTraverseNode.clearObjectIdToTraverseNodeMap();
            }
        }
        catch (HeapSnapshotTraverseException exception) {
            MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = exception.getStatusCode();
            return statusCode;
        }
        finally {
            this.watcher.stop();
            this.messageBusConnection.disconnect();
        }
    }

    private void updateComponentRootMasks(HeapTraverseNode node, ComponentsSet.Component currentObjectComponent, HeapTraverseNode.RefWeight weight) {
        node.retainedMask |= 1L << currentObjectComponent.getId();
        node.retainedMaskForCategories |= 1 << currentObjectComponent.getComponentCategory().getId();
        node.ownedByComponentMask = 1L << currentObjectComponent.getId();
        node.ownershipWeight = weight;
    }

    private void abortTraversalIfRequested() throws HeapSnapshotTraverseException {
        if (this.shouldAbortTraversal) {
            throw new HeapSnapshotTraverseException(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.LOW_MEMORY);
        }
    }

    private void onLowMemorySignalReceived() {
        this.shouldAbortTraversal = true;
    }

    private boolean isTagFromTheCurrentIteration(long tag) {
        return (tag & 0xFFL) == (long)this.iterationId;
    }

    private int getObjectId(long tag) {
        if (!this.isTagFromTheCurrentIteration(tag)) {
            return -1;
        }
        return (int)(tag >> 9);
    }

    private boolean wasVisited(long tag) {
        if (!this.isTagFromTheCurrentIteration(tag)) {
            return false;
        }
        return (tag & 0x100L) != 0L;
    }

    private long setObjectId(@NotNull Object obj, long tag, int newObjectId) {
        tag &= 0xFFFFFE00000001FFL;
        tag |= (long)newObjectId << 9;
        tag &= 0xFFFFFFFFFFFFFF00L;
        HeapSnapshotTraverse.setObjectTag(obj, tag |= (long)this.iterationId);
        return tag;
    }

    private long markVisited(@NotNull Object obj, long tag) {
        tag &= 0xFFFFFFFFFFFFFEFFL;
        tag |= 0x100L;
        tag &= 0xFFFFFFFFFFFFFF00L;
        HeapSnapshotTraverse.setObjectTag(obj, tag |= (long)this.iterationId);
        return tag;
    }

    private void addToStack(@NotNull StackNode stackNode, int maxDepth, @Nullable Object value2) {
        if (value2 == null) {
            return;
        }
        if (stackNode.depth + 1 > maxDepth) {
            return;
        }
        if (HeapTraverseUtil.isPrimitive(value2.getClass()) || value2 instanceof Thread || value2 instanceof Class || value2 instanceof ClassLoader) {
            return;
        }
        long tag = HeapSnapshotTraverse.getObjectTag(value2);
        if (this.wasVisited(tag)) {
            return;
        }
        StackNode.pushElementToDepthFirstSearchStack(value2, stackNode.depth + 1, this.markVisited(value2, tag));
    }

    private void addStronglyReferencedChildrenToStack(@NotNull StackNode stackNode, int maxDepth, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        if (stackNode.depth >= maxDepth) {
            return;
        }
        this.heapTraverseChildProcessor.processChildObjects(stackNode.getObject(), (value2, weight) -> this.addToStack(stackNode, maxDepth, value2), fieldCache);
    }

    private int getNextObjectId() {
        return ++this.lastObjectId;
    }

    private long depthFirstTraverseHeapObjects(@NotNull Object root, int maxDepth, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        int stackSize;
        long rootTag = HeapSnapshotTraverse.getObjectTag(root);
        if (this.wasVisited(rootTag)) {
            return -1L;
        }
        rootTag = this.markVisited(root, rootTag);
        StackNode.pushElementToDepthFirstSearchStack(root, 0, rootTag);
        while ((stackSize = StackNode.getDepthFirstSearchStackSize()) != 0) {
            if (stackSize > 1000000) {
                StackNode.clearDepthFirstSearchStack();
                throw new HeapSnapshotTraverseException(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.OBJECTS_MAP_IS_TOO_BIG);
            }
            StackNode stackNode = StackNode.peekAndMarkProcessedDepthFirstSearchStack(StackNode.class);
            if (stackNode == null || stackNode.obj == null) {
                StackNode.popElementFromDepthFirstSearchStack();
                continue;
            }
            long tag = stackNode.tag;
            if (stackNode.referencesProcessed) {
                tag = this.setObjectId(stackNode.obj, tag, this.getNextObjectId());
                StackNode.popElementFromDepthFirstSearchStack();
                if (root != stackNode.obj) continue;
                rootTag = tag;
                continue;
            }
            this.addStronglyReferencedChildrenToStack(stackNode, maxDepth, fieldCache);
            this.abortTraversalIfRequested();
        }
        return rootTag;
    }

    private void propagateComponentMask(@NotNull Object parentObj, @NotNull HeapTraverseNode parentNode, int parentId2, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        this.heapTraverseChildProcessor.processChildObjects(parentObj, (value2, ownershipWeight) -> {
            HeapTraverseNode currentNode;
            if (value2 == null || HeapTraverseUtil.isPrimitive(value2.getClass()) || value2 instanceof Thread || value2 instanceof Class || value2 instanceof ClassLoader) {
                return;
            }
            long tag = HeapSnapshotTraverse.getObjectTag(value2);
            if (tag == 0L) {
                return;
            }
            int objectId = this.getObjectId(tag);
            if (objectId == -1 || objectId >= parentId2) {
                return;
            }
            if (parentObj.getClass().isSynthetic()) {
                ownershipWeight = HeapTraverseNode.RefWeight.SYNTHETIC;
            }
            if (parentNode.ownedByComponentMask == 0L) {
                ownershipWeight = HeapTraverseNode.RefWeight.NON_COMPONENT;
            }
            if ((currentNode = HeapTraverseNode.getObjectIdToTraverseNodeMapElement(objectId, HeapTraverseNode.class)) == null) {
                currentNode = new HeapTraverseNode(value2, (HeapTraverseNode.RefWeight)((Object)ownershipWeight), parentNode.ownedByComponentMask, parentNode.retainedMask, parentNode.retainedMaskForCategories, tag, false);
            }
            currentNode.retainedMask &= parentNode.retainedMask;
            currentNode.retainedMaskForCategories &= parentNode.retainedMaskForCategories;
            if (ownershipWeight.compareTo(currentNode.ownershipWeight) > 0) {
                currentNode.ownershipWeight = ownershipWeight;
                currentNode.ownedByComponentMask = parentNode.ownedByComponentMask;
                currentNode.isMergePoint = false;
            } else if (ownershipWeight.compareTo(currentNode.ownershipWeight) == 0) {
                if (currentNode.ownedByComponentMask != 0L && parentNode.ownedByComponentMask != currentNode.ownedByComponentMask) {
                    currentNode.isMergePoint = true;
                }
                currentNode.ownedByComponentMask |= parentNode.ownedByComponentMask;
            }
            HeapTraverseNode.putOrUpdateObjectIdToTraverseNodeMap(objectId, value2, currentNode.ownershipWeight.getValue(), currentNode.ownedByComponentMask, currentNode.retainedMask, currentNode.retainedMaskForCategories, tag, currentNode.isMergePoint);
        }, fieldCache);
    }

    public void dispose() {
        this.watcher.stop();
        this.messageBusConnection.disconnect();
    }

    public static void collectAndWriteStats(@NotNull Consumer<String> writer2, @NotNull HeapSnapshotStatistics stats, @NotNull HeapSnapshotPresentationConfig presentationConfig) {
        long collectionStartTimestamp = System.nanoTime();
        new HeapSnapshotTraverse(stats).walkObjects(100000, getLoadedClassesComputable);
        stats.print(writer2, bytes2 -> HeapTraverseUtil.getObjectsStatsPresentation(bytes2, presentationConfig.sizePresentation), presentationConfig, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - collectionStartTimestamp));
    }

    public static MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode collectMemoryReport(@NotNull HeapSnapshotStatistics stats, @NotNull Computable<WeakList<Object>> rootsComputable) {
        long startTime = System.nanoTime();
        MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = new HeapSnapshotTraverse(stats).walkObjects(100000, rootsComputable);
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.MEMORY_USAGE_REPORT_EVENT).setMemoryUsageReportEvent(stats.buildMemoryUsageReportEvent(statusCode, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), TimeUnit.NANOSECONDS.toMillis(startTime), ComponentsSet.getServerFlagConfiguration().getSharedComponentsLimit())));
        List<String> exceededClusters = HeapSnapshotTraverse.getClustersThatExceededThreshold(stats);
        if (!exceededClusters.isEmpty()) {
            HeapSnapshotTraverse.collectAndSendExtendedMemoryReport(stats.getConfig().getComponentsSet(), exceededClusters, rootsComputable);
        }
        return statusCode;
    }

    @NotNull
    private static List<String> getClustersThatExceededThreshold(@NotNull HeapSnapshotStatistics stats) {
        ArrayList exceededClusters = Lists.newArrayList();
        for (ComponentsSet.ComponentCategory category : stats.getConfig().getComponentsSet().getComponentsCategories()) {
            if (stats.getCategoryComponentStats().get(category.getId()).getOwnedClusterStat().getObjectsStatistics().getTotalSizeInBytes() <= category.getExtendedReportCollectionThresholdBytes()) continue;
            exceededClusters.add(category.getComponentCategoryLabel());
        }
        for (ComponentsSet.Component component2 : stats.getConfig().getComponentsSet().getComponents()) {
            if (stats.getComponentStats().get(component2.getId()).getOwnedClusterStat().getObjectsStatistics().getTotalSizeInBytes() <= component2.getExtendedReportCollectionThresholdBytes()) continue;
            exceededClusters.add(component2.getComponentLabel());
        }
        for (HeapSnapshotStatistics.SharedClusterStatistics value2 : stats.maskToSharedComponentStats.values()) {
            if (value2.getStatistics().getObjectsStatistics().getTotalSizeInBytes() <= stats.getConfig().getComponentsSet().getSharedClusterExtendedReportThreshold()) continue;
            exceededClusters.add(HeapSnapshotStatistics.getSharedClusterPresentationLabel(value2, stats));
        }
        return exceededClusters;
    }

    public static void collectAndSendExtendedMemoryReport(@NotNull ComponentsSet componentsSet, @NotNull List<String> exceededClusters, @NotNull Computable<WeakList<Object>> rootsComputable) {
        HeapSnapshotStatistics extendedReportStats = new HeapSnapshotStatistics(new HeapTraverseConfig(componentsSet, true, true));
        new HeapSnapshotTraverse(extendedReportStats).walkObjects(100000, rootsComputable);
        StudioCrashReporter.getInstance().submit(extendedReportStats.asCrashReport(exceededClusters), true);
    }

    private static short getNextIterationId() {
        ourIterationId = (short)(ourIterationId + 1);
        return ourIterationId;
    }

    static native long getObjectTag(@NotNull Object var0);

    private static native void setObjectTag(@NotNull Object var0, long var1);

    private static native boolean canTagObjects();

    public static native Class<?>[] getClasses();

    private static native long getObjectSize(@NotNull Object var0);

    static native boolean isClassInitialized(@NotNull Class<?> var0);

    static native Object[] getClassStaticFieldsValues(@NotNull Class<?> var0);

    static class HeapSnapshotPresentationConfig {
        final SizePresentationStyle sizePresentation;
        final boolean shouldLogSharedClusters;
        final boolean shouldLogRetainedSizes;

        HeapSnapshotPresentationConfig(SizePresentationStyle sizePresentation, boolean shouldLogSharedClusters, boolean shouldLogRetainedSizes) {
            this.sizePresentation = sizePresentation;
            this.shouldLogSharedClusters = shouldLogSharedClusters;
            this.shouldLogRetainedSizes = shouldLogRetainedSizes;
        }

        static enum SizePresentationStyle {
            BYTES,
            OPTIMAL_UNITS;

        }
    }
}

