/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.GoogleCrashReporter;
import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.ExtendedReportStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverse;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.android.tools.idea.diagnostics.report.DiagnosticCrashReport;
import com.android.tools.idea.diagnostics.report.DiagnosticReportProperties;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.ide.PowerSaveMode;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HeapSnapshotStatistics {
    @NotNull
    private final ClusterObjectsStatistics.MemoryTrafficStatistics totalStats = new ClusterObjectsStatistics.MemoryTrafficStatistics();
    @NotNull
    private final List<ComponentClusterObjectsStatistics> componentStats = new ArrayList<ComponentClusterObjectsStatistics>();
    @NotNull
    private final List<CategoryClusterObjectsStatistics> categoryComponentStats = new ArrayList<CategoryClusterObjectsStatistics>();
    @NotNull
    final Long2ObjectMap<SharedClusterStatistics> maskToSharedComponentStats = new Long2ObjectOpenHashMap();
    int maxFieldsCacheSize = 0;
    int maxObjectsQueueSize = 0;
    int enumeratedGarbageCollectedObjects = 0;
    int unsuccessfulFieldAccessCounter = 0;
    int heapObjectCount = 0;
    private short traverseSessionId;
    @NotNull
    private final HeapTraverseConfig config;
    @Nullable
    private final ExtendedReportStatistics extendedReportStatistics;

    public HeapSnapshotStatistics(@NotNull ComponentsSet componentsSet) {
        this(new HeapTraverseConfig(componentsSet, false, false));
    }

    public HeapSnapshotStatistics(@NotNull HeapTraverseConfig config2) {
        this.config = config2;
        for (ComponentsSet.Component component2 : config2.getComponentsSet().getComponents()) {
            this.componentStats.add(new ComponentClusterObjectsStatistics(component2));
        }
        for (ComponentsSet.ComponentCategory category : config2.getComponentsSet().getComponentsCategories()) {
            this.categoryComponentStats.add(new CategoryClusterObjectsStatistics(category));
        }
        this.extendedReportStatistics = config2.collectHistograms ? new ExtendedReportStatistics(config2) : null;
    }

    @NotNull
    public List<ComponentClusterObjectsStatistics> getComponentStats() {
        return this.componentStats;
    }

    @NotNull
    public List<CategoryClusterObjectsStatistics> getCategoryComponentStats() {
        return this.categoryComponentStats;
    }

    public void addObjectSizeToSharedComponent(long sharedMask, long size, String objectClassName, boolean isMergePoint) {
        if (!this.maskToSharedComponentStats.containsKey(sharedMask)) {
            this.maskToSharedComponentStats.put(sharedMask, (Object)new SharedClusterStatistics(sharedMask));
        }
        SharedClusterStatistics stats = (SharedClusterStatistics)this.maskToSharedComponentStats.get(sharedMask);
        stats.getStatistics().addObject(size);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToSharedClusterHistogram(stats, objectClassName, size, isMergePoint);
        }
    }

    public void addOwnedObjectSizeToComponent(int componentId, long size, String objectClassName, boolean isRoot2) {
        ComponentClusterObjectsStatistics stats = this.componentStats.get(componentId);
        stats.addOwnedObject(size);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToComponentOwnedHistogram(stats.getComponent(), objectClassName, size, isRoot2);
        }
    }

    public void addObjectToTotal(long size) {
        this.totalStats.addObject(size);
    }

    public void addRetainedObjectSizeToCategoryComponent(int categoryId, long size) {
        this.categoryComponentStats.get(categoryId).addRetainedObject(size);
    }

    public void addOwnedObjectSizeToCategoryComponent(int categoryId, long size, String objectClassName, boolean isRoot2) {
        CategoryClusterObjectsStatistics stats = this.categoryComponentStats.get(categoryId);
        stats.addOwnedObject(size);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToCategoryOwnedHistogram(stats.getComponentCategory(), objectClassName, size, isRoot2);
        }
    }

    public void addRetainedObjectSizeToComponent(int componentID, long size) {
        this.componentStats.get(componentID).addRetainedObject(size);
    }

    public void addDisposedButReferencedObject(long size, String objectClassName) {
        if (this.config.collectDisposerTreeInfo && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addDisposedButReferencedObject(size, objectClassName);
        }
    }

    public void addDisposerTreeInfo(@NotNull Object disposerTree) {
        Object objToNodeMap;
        if (this.config.collectDisposerTreeInfo && this.extendedReportStatistics != null && (objToNodeMap = HeapTraverseUtil.getFieldValue(disposerTree, "myObject2ParentNode")) instanceof Map) {
            this.extendedReportStatistics.setDisposerTreeSize(((Map)objToNodeMap).size());
        }
    }

    private static String getOptimalUnitsStatisticsPresentation(@NotNull ObjectsStatistics statistics) {
        return HeapTraverseUtil.getObjectsStatsPresentation(statistics, HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.OPTIMAL_UNITS);
    }

    @NotNull
    public CrashReport asCrashReport(final @NotNull List<String> exceededClusters) {
        if (this.extendedReportStatistics == null) {
            throw new IllegalStateException("Extended memory report required for sending a Crash report was not calculated.");
        }
        return new DiagnosticCrashReport("Extended Memory Report", new DiagnosticReportProperties()){

            public void serialize(MultipartEntityBuilder builder2) {
                super.serialize(builder2);
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder2, (String)"Total used memory", (String)HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(HeapSnapshotStatistics.this.totalStats.objectsStat));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder2, (String)"Clusters that exceeded the threshold", (String)String.join((CharSequence)",", exceededClusters));
                for (CategoryClusterObjectsStatistics categoryClusterObjectsStatistics : HeapSnapshotStatistics.this.categoryComponentStats) {
                    StringBuilder categoryReportBuilder = new StringBuilder();
                    categoryReportBuilder.append(String.format(Locale.US, "Owned: %s\n", HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(categoryClusterObjectsStatistics.getOwnedClusterStat().getObjectsStatistics())));
                    HeapSnapshotStatistics.this.extendedReportStatistics.logCategoryHistogram(s -> categoryReportBuilder.append((String)s).append("\n"), categoryClusterObjectsStatistics.getComponentCategory());
                    GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder2, (String)("Category " + categoryClusterObjectsStatistics.getComponentCategory().getComponentCategoryLabel()), (String)categoryReportBuilder.toString());
                }
                for (ComponentClusterObjectsStatistics componentClusterObjectsStatistics : HeapSnapshotStatistics.this.componentStats) {
                    StringBuilder componentReportBuilder = new StringBuilder();
                    componentReportBuilder.append(String.format(Locale.US, "Owned: %s\n", HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(componentClusterObjectsStatistics.getOwnedClusterStat().getObjectsStatistics())));
                    HeapSnapshotStatistics.this.extendedReportStatistics.logComponentHistogram(s -> componentReportBuilder.append((String)s).append("\n"), componentClusterObjectsStatistics.getComponent());
                    GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder2, (String)("Component " + componentClusterObjectsStatistics.getComponent().getComponentLabel()), (String)componentReportBuilder.toString());
                }
                HeapSnapshotStatistics.this.maskToSharedComponentStats.values().stream().sorted(Comparator.comparingLong(a -> a.getStatistics().getObjectsStatistics().getTotalSizeInBytes()).reversed()).limit(10L).forEach(stat -> {
                    StringBuilder sharedClusterReportBuilder = new StringBuilder();
                    sharedClusterReportBuilder.append(String.format(Locale.US, "Owned: %s\n", HeapSnapshotStatistics.getOptimalUnitsStatisticsPresentation(stat.getStatistics().getObjectsStatistics())));
                    HeapSnapshotStatistics.this.extendedReportStatistics.logSharedClusterHistogram(s -> sharedClusterReportBuilder.append((String)s).append("\n"), (SharedClusterStatistics)stat);
                    GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder2, (String)("Shared cluster " + HeapSnapshotStatistics.getSharedClusterPresentationLabel(stat, HeapSnapshotStatistics.this)), (String)sharedClusterReportBuilder.toString());
                });
                StringBuilder disposerTreeInfoBuilder = new StringBuilder();
                HeapSnapshotStatistics.this.extendedReportStatistics.logDisposerTreeReport(s -> disposerTreeInfoBuilder.append((String)s).append("\n"));
                GoogleCrashReporter.addBodyToBuilder((MultipartEntityBuilder)builder2, (String)"Disposer tree information", (String)disposerTreeInfoBuilder.toString());
            }
        };
    }

    void print(@NotNull Consumer<String> writer2, @NotNull Function<ObjectsStatistics, String> objectsStatsPresentation, @NotNull HeapSnapshotTraverse.HeapSnapshotPresentationConfig presentationConfig, long collectionTimeMs) {
        writer2.accept(String.format(Locale.US, "Total used memory: %s", objectsStatsPresentation.apply(this.totalStats.objectsStat)));
        ObjectsStatistics sharedObjectsStatistics = new ObjectsStatistics();
        this.maskToSharedComponentStats.values().forEach(e -> sharedObjectsStatistics.addStats(e.getStatistics().getObjectsStatistics()));
        writer2.accept(String.format(Locale.US, "Total shared memory: %s", objectsStatsPresentation.apply(sharedObjectsStatistics)));
        writer2.accept(String.format(Locale.US, "Report collection time: %d ms", collectionTimeMs));
        writer2.accept(String.format(Locale.US, "%d Categories:", this.categoryComponentStats.size()));
        for (CategoryClusterObjectsStatistics categoryClusterObjectsStatistics : this.categoryComponentStats) {
            writer2.accept(String.format(Locale.US, "  Category %s:", categoryClusterObjectsStatistics.getComponentCategory().getComponentCategoryLabel()));
            writer2.accept(String.format(Locale.US, "    Owned: %s", objectsStatsPresentation.apply(categoryClusterObjectsStatistics.getOwnedClusterStat().getObjectsStatistics())));
            if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                this.extendedReportStatistics.logCategoryHistogram(writer2, categoryClusterObjectsStatistics.getComponentCategory());
            }
            if (!presentationConfig.shouldLogRetainedSizes) continue;
            writer2.accept(String.format(Locale.US, "    Retained: %s", objectsStatsPresentation.apply(categoryClusterObjectsStatistics.getRetainedClusterStat().getObjectsStatistics())));
        }
        writer2.accept(String.format(Locale.US, "%d Components:", this.componentStats.size()));
        for (ComponentClusterObjectsStatistics componentClusterObjectsStatistics : this.componentStats) {
            writer2.accept(String.format(Locale.US, "  Component %s:", componentClusterObjectsStatistics.getComponent().getComponentLabel()));
            writer2.accept(String.format(Locale.US, "    Owned: %s", objectsStatsPresentation.apply(componentClusterObjectsStatistics.getOwnedClusterStat().getObjectsStatistics())));
            if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                this.extendedReportStatistics.logComponentHistogram(writer2, componentClusterObjectsStatistics.getComponent());
            }
            if (!presentationConfig.shouldLogRetainedSizes) continue;
            writer2.accept(String.format(Locale.US, "    Retained: %s", objectsStatsPresentation.apply(componentClusterObjectsStatistics.getRetainedClusterStat().getObjectsStatistics())));
        }
        if (presentationConfig.shouldLogSharedClusters) {
            writer2.accept("Shared clusters:");
            this.maskToSharedComponentStats.values().stream().sorted(Comparator.comparingLong(a -> -a.getStatistics().getObjectsStatistics().getTotalSizeInBytes())).limit(10L).forEach(s -> {
                writer2.accept(String.format(Locale.US, "  %s: %s", HeapSnapshotStatistics.getSharedClusterPresentationLabel(s, this), objectsStatsPresentation.apply(s.getStatistics().getObjectsStatistics())));
                if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                    this.extendedReportStatistics.logSharedClusterHistogram(writer2, (SharedClusterStatistics)s);
                }
                if (this.extendedReportStatistics != null) {
                    this.extendedReportStatistics.logDisposerTreeReport(writer2);
                }
            });
        }
    }

    static String getSharedClusterPresentationLabel(@NotNull SharedClusterStatistics clusterStats, @NotNull HeapSnapshotStatistics stats) {
        return clusterStats.getComponentIds(stats.getConfig()).stream().map(id2 -> stats.getComponentStats().get((int)id2).getComponent().getComponentLabel()).toList().toString();
    }

    public void updateMaxFieldsCacheSize(int currentFieldSize) {
        this.maxFieldsCacheSize = Math.max(this.maxFieldsCacheSize, currentFieldSize);
    }

    public void updateMaxObjectsQueueSize(int currentObjectsQueueSize) {
        this.maxObjectsQueueSize = Math.max(this.maxObjectsQueueSize, currentObjectsQueueSize);
    }

    public void incrementGarbageCollectedObjectsCounter() {
        ++this.enumeratedGarbageCollectedObjects;
    }

    public void incrementUnsuccessfulFieldAccessCounter() {
        ++this.unsuccessfulFieldAccessCounter;
    }

    public void setHeapObjectCount(int heapObjectCount) {
        this.heapObjectCount = heapObjectCount;
    }

    @NotNull
    private MemoryUsageReportEvent.ObjectsStatistics buildObjectStatistics(@NotNull ObjectsStatistics objectsStatistics) {
        return MemoryUsageReportEvent.ObjectsStatistics.newBuilder().setObjectsCount(objectsStatistics.getObjectsCount()).setTotalSizeBytes(objectsStatistics.getTotalSizeInBytes()).build();
    }

    @NotNull
    private MemoryUsageReportEvent.MemoryTrafficStatistics buildMemoryTrafficStatistics(@NotNull ClusterObjectsStatistics.MemoryTrafficStatistics memoryTrafficStatistics) {
        return MemoryUsageReportEvent.MemoryTrafficStatistics.newBuilder().setTotalStats(this.buildObjectStatistics(memoryTrafficStatistics.getObjectsStatistics())).build();
    }

    @NotNull
    private MemoryUsageReportEvent.ClusterObjectsStatistics buildClusterObjectsStatistics(@NotNull ClusterObjectsStatistics componentStatistics) {
        return MemoryUsageReportEvent.ClusterObjectsStatistics.newBuilder().setOwnedClusterStats(this.buildMemoryTrafficStatistics(componentStatistics.getOwnedClusterStat())).setRetainedClusterStats(this.buildMemoryTrafficStatistics(componentStatistics.getRetainedClusterStat())).build();
    }

    @NotNull
    public MemoryUsageReportEvent buildMemoryUsageReportEvent(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode, long executionTimeMs, long executionStartMs, int sharedComponentsLimit) {
        MemoryUsageReportEvent.Builder builder2 = MemoryUsageReportEvent.newBuilder();
        for (ComponentClusterObjectsStatistics componentStat : this.componentStats) {
            builder2.addComponentStats(MemoryUsageReportEvent.ClusterMemoryUsage.newBuilder().setLabel(componentStat.getComponent().getComponentLabel()).setStats(this.buildClusterObjectsStatistics(componentStat)));
        }
        this.maskToSharedComponentStats.values().stream().sorted(Comparator.comparingLong(s -> -s.getStatistics().getObjectsStatistics().getTotalSizeInBytes())).limit(sharedComponentsLimit).forEach(s -> builder2.addSharedComponentStats(MemoryUsageReportEvent.SharedClusterMemoryUsage.newBuilder().addAllIds(s.getComponentIds(this.config)).setStats(this.buildMemoryTrafficStatistics(s.getStatistics()))));
        for (CategoryClusterObjectsStatistics categoryStat : this.categoryComponentStats) {
            builder2.addComponentCategoryStats(MemoryUsageReportEvent.ClusterMemoryUsage.newBuilder().setLabel(categoryStat.getComponentCategory().getComponentCategoryLabel()).setStats(this.buildClusterObjectsStatistics(categoryStat)));
        }
        builder2.setMetadata(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.newBuilder().setStatusCode(statusCode).setTotalHeapObjectsStats(this.buildMemoryTrafficStatistics(this.totalStats)).setFieldCacheCountPeak(this.maxFieldsCacheSize).setObjectQueueLengthPeak(this.maxObjectsQueueSize).setGarbageCollectedBefore2PassCount(this.enumeratedGarbageCollectedObjects).setCollectionTimeSeconds((double)executionTimeMs / 1000.0).setIsInPowerSaveMode(PowerSaveMode.isEnabled()).setUnsuccessfulFieldAccessesCount(this.unsuccessfulFieldAccessCounter).setCollectionStartTimestampSeconds((double)executionStartMs / 1000.0).setCollectionIteration((int)this.traverseSessionId));
        return builder2.build();
    }

    public void setTraverseSessionId(short traverseSessionId) {
        this.traverseSessionId = traverseSessionId;
    }

    @NotNull
    public HeapTraverseConfig getConfig() {
        return this.config;
    }

    @Nullable
    public ExtendedReportStatistics getExtendedReportStatistics() {
        return this.extendedReportStatistics;
    }

    static class ClusterObjectsStatistics {
        @NotNull
        private final MemoryTrafficStatistics retainedClusterStat = new MemoryTrafficStatistics();
        @NotNull
        private final MemoryTrafficStatistics ownedClusterStat = new MemoryTrafficStatistics();

        ClusterObjectsStatistics() {
        }

        public void addOwnedObject(long size) {
            this.ownedClusterStat.addObject(size);
        }

        public void addRetainedObject(long size) {
            this.retainedClusterStat.addObject(size);
        }

        @NotNull
        public MemoryTrafficStatistics getOwnedClusterStat() {
            return this.ownedClusterStat;
        }

        @NotNull
        public MemoryTrafficStatistics getRetainedClusterStat() {
            return this.retainedClusterStat;
        }

        static class MemoryTrafficStatistics {
            @NotNull
            private final ObjectsStatistics objectsStat = new ObjectsStatistics();

            MemoryTrafficStatistics() {
            }

            public void addObject(long size) {
                this.objectsStat.addObject(size);
            }

            public ObjectsStatistics getObjectsStatistics() {
                return this.objectsStat;
            }
        }
    }

    static class ComponentClusterObjectsStatistics
    extends ClusterObjectsStatistics {
        @NotNull
        private final ComponentsSet.Component component;

        private ComponentClusterObjectsStatistics(@NotNull ComponentsSet.Component component2) {
            this.component = component2;
        }

        @NotNull
        ComponentsSet.Component getComponent() {
            return this.component;
        }
    }

    static class CategoryClusterObjectsStatistics
    extends ClusterObjectsStatistics {
        @NotNull
        private final ComponentsSet.ComponentCategory componentCategory;

        private CategoryClusterObjectsStatistics(@NotNull ComponentsSet.ComponentCategory category) {
            this.componentCategory = category;
        }

        @NotNull
        ComponentsSet.ComponentCategory getComponentCategory() {
            return this.componentCategory;
        }
    }

    static class SharedClusterStatistics {
        @NotNull
        private final ClusterObjectsStatistics.MemoryTrafficStatistics statistics;
        final long componentsMask;

        private SharedClusterStatistics(long componentsMask) {
            this.componentsMask = componentsMask;
            this.statistics = new ClusterObjectsStatistics.MemoryTrafficStatistics();
        }

        @NotNull
        ClusterObjectsStatistics.MemoryTrafficStatistics getStatistics() {
            return this.statistics;
        }

        @NotNull
        Collection<Integer> getComponentIds(@NotNull HeapTraverseConfig config2) {
            ArrayList<Integer> components = new ArrayList<Integer>();
            HeapTraverseUtil.processMask(this.componentsMask, index2 -> components.add(config2.getComponentsSet().getComponents().get((int)index2).getId()));
            return components;
        }
    }
}

