/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverse;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ExtendedReportStatistics {
    @NotNull
    final List<ClassNameHistogram> componentHistograms;
    @NotNull
    final List<ClassNameHistogram> categoryHistograms;
    @NotNull
    final Long2ObjectMap<ClassNameHistogram> sharedClustersHistograms;
    private int totalNumberOfDisposedButReferencedObjects = 0;
    private int totalDisposerTreeSize = 0;
    @NotNull
    private final Map<String, ObjectsStatistics> disposedButReferencedObjectsClasses = Maps.newHashMap();

    public ExtendedReportStatistics(@NotNull HeapTraverseConfig config2) {
        this.componentHistograms = Lists.newArrayList();
        this.categoryHistograms = Lists.newArrayList();
        this.sharedClustersHistograms = new Long2ObjectOpenHashMap();
        int componentIndex = 0;
        for (ComponentsSet.Component component2 : config2.getComponentsSet().getComponents()) {
            this.componentHistograms.add(new ClassNameHistogram(ClassNameHistogram.ClusterType.COMPONENT));
            assert (component2.getId() == componentIndex);
            ++componentIndex;
        }
        int componentCategoryIndex = 0;
        for (ComponentsSet.ComponentCategory componentCategory : config2.getComponentsSet().getComponentsCategories()) {
            this.categoryHistograms.add(new ClassNameHistogram(ClassNameHistogram.ClusterType.CATEGORY));
            assert (componentCategory.getId() == componentCategoryIndex);
            ++componentCategoryIndex;
        }
    }

    void addClassNameToComponentOwnedHistogram(@NotNull ComponentsSet.Component component2, @NotNull String className, long size, boolean isRoot2) {
        this.componentHistograms.get(component2.getId()).addObjectClassName(className, size, isRoot2);
    }

    void addClassNameToCategoryOwnedHistogram(@NotNull ComponentsSet.ComponentCategory componentCategory, @NotNull String className, long size, boolean isRoot2) {
        this.categoryHistograms.get(componentCategory.getId()).addObjectClassName(className, size, isRoot2);
    }

    public void addClassNameToSharedClusterHistogram(@NotNull HeapSnapshotStatistics.SharedClusterStatistics sharedClusterStatistics, @NotNull String className, long size, boolean isMergePoint) {
        this.sharedClustersHistograms.putIfAbsent(sharedClusterStatistics.componentsMask, (Object)new ClassNameHistogram(ClassNameHistogram.ClusterType.SHARED_CLUSTER));
        ((ClassNameHistogram)this.sharedClustersHistograms.get(sharedClusterStatistics.componentsMask)).addObjectClassName(className, size, isMergePoint);
    }

    public void logCategoryHistogram(@NotNull Consumer<String> writer2, @NotNull ComponentsSet.ComponentCategory componentCategory) {
        this.categoryHistograms.get(componentCategory.getId()).print(writer2);
    }

    public void logComponentHistogram(@NotNull Consumer<String> writer2, @NotNull ComponentsSet.Component component2) {
        this.componentHistograms.get(component2.getId()).print(writer2);
    }

    public void logSharedClusterHistogram(@NotNull Consumer<String> writer2, @NotNull HeapSnapshotStatistics.SharedClusterStatistics sharedClusterStatistics) {
        ((ClassNameHistogram)this.sharedClustersHistograms.get(sharedClusterStatistics.componentsMask)).print(writer2);
    }

    public void addDisposedButReferencedObject(long size, String className) {
        ++this.totalNumberOfDisposedButReferencedObjects;
        this.disposedButReferencedObjectsClasses.putIfAbsent(className, new ObjectsStatistics());
        this.disposedButReferencedObjectsClasses.get(className).addObject(size);
    }

    public void setDisposerTreeSize(int size) {
        this.totalDisposerTreeSize = size;
    }

    public void logDisposerTreeReport(@NotNull Consumer<String> writer2) {
        writer2.accept("Disposer tree size: " + this.totalDisposerTreeSize);
        writer2.accept("Total number of disposed but strong referenced objects: " + this.totalNumberOfDisposedButReferencedObjects);
        for (String className : this.disposedButReferencedObjectsClasses.keySet()) {
            writer2.accept(HeapTraverseUtil.getObjectsStatsPresentation(this.disposedButReferencedObjectsClasses.get(className), HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.OPTIMAL_UNITS) + " " + className);
        }
    }

    static class ClassNameHistogram {
        private static final int HISTOGRAM_PRINT_LIMIT = 50;
        @NotNull
        final Map<String, ObjectsStatistics> histogram = Maps.newHashMap();
        @NotNull
        final Map<String, ObjectsStatistics> rootsHistogram = Maps.newHashMap();
        @NotNull
        private final ClusterType clusterType;

        public ClassNameHistogram(@NotNull ClusterType clusterType) {
            this.clusterType = clusterType;
        }

        public void addObjectClassName(@NotNull String className, long size, boolean isRoot2) {
            this.histogram.putIfAbsent(className, new ObjectsStatistics());
            this.histogram.get(className).addObject(size);
            if (isRoot2) {
                this.rootsHistogram.putIfAbsent(className, new ObjectsStatistics());
                this.rootsHistogram.get(className).addObject(size);
            }
        }

        private boolean classNameIsStudioSource(@NotNull String className) {
            return className.startsWith("com.android.") || className.startsWith("org.jetbrains") || className.startsWith("com.intellij") || className.startsWith("com.jetbrains");
        }

        public void print(Consumer<String> writer2) {
            writer2.accept("      Histogram:");
            this.histogram.entrySet().stream().sorted(Comparator.comparingLong(a -> ((ObjectsStatistics)a.getValue()).getTotalSizeInBytes()).reversed()).limit(50L).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.OPTIMAL_UNITS), e.getKey())));
            writer2.accept("      Studio objects histogram:");
            this.histogram.entrySet().stream().filter(e -> this.classNameIsStudioSource((String)e.getKey())).sorted(Comparator.comparingLong(a -> ((ObjectsStatistics)a.getValue()).getTotalSizeInBytes()).reversed()).limit(50L).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.OPTIMAL_UNITS), e.getKey())));
            switch (this.clusterType) {
                case CATEGORY: {
                    writer2.accept("      Category roots histogram:");
                    break;
                }
                case COMPONENT: {
                    writer2.accept("      Component roots histogram:");
                    break;
                }
                case SHARED_CLUSTER: {
                    writer2.accept("      Shared cluster merge-points histogram:");
                }
            }
            this.rootsHistogram.entrySet().stream().sorted(Comparator.comparingLong(a -> ((ObjectsStatistics)a.getValue()).getTotalSizeInBytes()).reversed()).limit(50L).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.OPTIMAL_UNITS), e.getKey())));
        }

        static enum ClusterType {
            COMPONENT,
            CATEGORY,
            SHARED_CLUSTER;

        }
    }
}

