/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.android.tools.idea.diagnostics.crash.ExceptionDataCollection;
import com.android.tools.idea.diagnostics.crash.UploadFields;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.openapi.extensions.PluginId;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;

public class StudioExceptionReport
extends BaseStudioReport {
    public static final String KEY_EXCEPTION_INFO = "exception_info";
    private final String exceptionInfo;
    private final boolean userReported;
    private final String fullStack;
    private final Map<String, String> logs;
    private final PluginId pluginId;

    private StudioExceptionReport(String version2, String exceptionInfo, boolean userReported, String fullStack, @NotNull Map<String, String> logs, PluginId pluginId, Map<String, String> productData) {
        super(version2, productData, "Exception");
        this.exceptionInfo = exceptionInfo;
        this.userReported = userReported;
        this.fullStack = fullStack;
        this.logs = logs;
        this.pluginId = pluginId;
    }

    @Override
    protected void serializeTo(MultipartEntityBuilder builder2) {
        super.serializeTo(builder2);
        if (this.isKotlinOnStack()) {
            builder2.addTextBody("kotlinVersion", this.getKotlinPluginVersionDescription());
        }
        try {
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)this.pluginId);
            if (plugin != null) {
                String name3 = plugin.getName();
                String version2 = plugin.getVersion();
                builder2.addTextBody("plugin.name", name3);
                builder2.addTextBody("plugin.version", version2);
            }
        }
        catch (Throwable ignored) {
            builder2.addTextBody("plugin.name", "exceptionWhileReadingNameVersion");
        }
        builder2.addTextBody("userReported", this.userReported ? "1" : "0");
        builder2.addTextBody(KEY_EXCEPTION_INFO, this.exceptionInfo);
        if (this.fullStack != null) {
            builder2.addTextBody("fullStack", this.fullStack);
        }
        this.logs.forEach((name2, logContent) -> {
            String filename = "log_" + name2;
            builder2.addBinaryBody("log_" + name2, logContent.getBytes(StandardCharsets.UTF_8), ContentType.TEXT_PLAIN, filename + ".log");
        });
    }

    private boolean isKotlinOnStack() {
        return this.exceptionInfo.contains("\tat org.jetbrains.kotlin");
    }

    @VisibleForTesting
    protected String getKotlinPluginVersionDescription() {
        try {
            IdeaPluginDescriptor[] pluginDescriptors = PluginManagerCore.getPlugins();
            return Arrays.stream(pluginDescriptors).filter(d -> d.getPluginId() != null && d.getPluginId().getIdString().equals("org.jetbrains.kotlin") && d.isEnabled()).findFirst().map(d -> d.getVersion()).orElse("pluginNotLoaded");
        }
        catch (Exception ignored) {
            return "exceptionWhenReadingVersion";
        }
    }

    public static Throwable getRootCause(Throwable t) {
        int depth = 0;
        while (depth++ < 20) {
            if (t.getCause() == null) {
                return t;
            }
            t = t.getCause();
        }
        return t;
    }

    public static String getDescription(Throwable t) {
        return ExceptionDataCollection.getInstance().getDescription(t, true, false);
    }

    public static class Builder
    extends CrashReport.BaseBuilder<StudioExceptionReport, Builder> {
        private String exceptionInfo;
        private boolean userReported;
        private PluginId pluginId;
        private Map<String, String> logs;
        private String fullStack;

        protected Builder getThis() {
            return this;
        }

        public Builder setThrowable(Throwable throwable, boolean userReported, boolean includeLogs) {
            Throwable cause = StudioExceptionReport.getRootCause(throwable);
            ExceptionDataCollection service = ExceptionDataCollection.getInstance();
            UploadFields uploadFields = service.getExceptionUploadFields(throwable, userReported, includeLogs);
            this.exceptionInfo = uploadFields.getDescription();
            this.userReported = userReported;
            this.logs = uploadFields.getLogs();
            this.pluginId = PluginUtil.getInstance().findPluginId(cause);
            return this;
        }

        public StudioExceptionReport build() {
            return new StudioExceptionReport(this.getVersion(), this.exceptionInfo, this.userReported, this.fullStack, this.logs, this.pluginId, this.getProductData());
        }
    }
}

