/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.diagnostics.crash.ExceptionDataCollection;
import com.android.tools.idea.diagnostics.crash.ExceptionDataConfiguration;
import com.android.tools.idea.diagnostics.crash.LogBuffer;
import com.android.tools.idea.diagnostics.crash.LogCache;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.diagnostics.crash.UploadFields;
import com.android.tools.idea.diagnostics.crash.exception.NoPiiException;
import com.android.tools.idea.serverflags.protos.ExceptionAction;
import com.android.tools.idea.serverflags.protos.ExceptionConfiguration;
import com.android.tools.idea.serverflags.protos.ExceptionSeverity;
import com.android.tools.idea.serverflags.protos.LogFilter;
import com.android.tools.idea.serverflags.protos.MessageFilter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.intellij.diagnostic.DebugLogManager;
import com.intellij.diagnostic.DialogAppender;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 >2\u00020\u0001:\u0003>?@B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u001e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J>\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0019J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-H\u0002J!\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002000/H\u0002\u00a2\u0006\u0002\u00102J\u000e\u00103\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u00104\u001a\n 6*\u0004\u0018\u000105052\u0006\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u00020\u0019H\u0002J\b\u0010:\u001a\u00020\u001bH\u0007J\u0014\u0010;\u001a\u00020\u0019*\u0002052\u0006\u0010<\u001a\u000205H\u0002J\u0014\u0010=\u001a\u00020\u0019*\u0002052\u0006\u0010<\u001a\u000205H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006A"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection;", "", "()V", "configs", "", "", "Lcom/android/tools/idea/serverflags/protos/ExceptionConfiguration;", "layout", "Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$ExceptionDataCollectionLayout;", "logCache", "Lcom/android/tools/idea/diagnostics/crash/LogCache;", "regex", "Lkotlin/text/Regex;", "registeredAppenders", "", "Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$TrackingAppender;", "getRegisteredAppenders", "()Ljava/util/List;", "calculateSignature", "t", "", "fixStackTraceStringForLoggerErrorMethod", "s", "getDescription", "stripMessage", "", "includeFullStack", "", "containingThrowable", "depth", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getExceptionUploadConfigurations", "getExceptionUploadFields", "Lcom/android/tools/idea/diagnostics/crash/UploadFields;", "forceExceptionMessage", "includeLogs", "initializeLog", "registerAppendersForLogFilter", "logName", "logFilter", "Lcom/android/tools/idea/serverflags/protos/LogFilter;", "registerTrackingAppenders", "", "removeLoggerErrorFrames", "", "Ljava/lang/StackTraceElement;", "stackTraceElements", "([Ljava/lang/StackTraceElement;)[Ljava/lang/StackTraceElement;", "requiresConfirmation", "severityToLevel", "Ljava/util/logging/Level;", "kotlin.jvm.PlatformType", "severity", "Lcom/android/tools/idea/serverflags/protos/ExceptionSeverity;", "tryReconfigureExistingHandlers", "unregisterLogAppenders", "isGreaterThanOrEqual", "other", "isLessThan", "Companion", "ExceptionDataCollectionLayout", "TrackingAppender", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nExceptionDataCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionDataCollection.kt\ncom/android/tools/idea/diagnostics/crash/ExceptionDataCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,487:1\n1743#2,3:488\n1743#2,2:491\n1743#2,3:493\n1745#2:496\n1851#2,2:497\n1851#2,2:512\n1743#2,3:514\n1743#2,3:517\n1238#2,4:522\n1722#2,2:536\n1724#2:540\n1851#2,2:556\n12537#3,2:499\n4098#3,11:501\n12708#3,2:538\n1627#3,6:547\n440#4:520\n390#4:521\n481#4,7:526\n481#4,3:533\n484#4,4:541\n37#5,2:545\n183#6,3:553\n*S KotlinDebug\n*F\n+ 1 ExceptionDataCollection.kt\ncom/android/tools/idea/diagnostics/crash/ExceptionDataCollection\n*L\n125#1:488,3\n137#1:491,2\n138#1:493,3\n137#1:496\n167#1:497,2\n227#1:512,2\n241#1:514,3\n244#1:517,3\n248#1:522,4\n296#1:536,2\n296#1:540\n479#1:556,2\n218#1:499,2\n227#1:501,11\n297#1:538,2\n434#1:547,6\n248#1:520\n248#1:521\n249#1:526,7\n268#1:533,3\n268#1:541,4\n422#1:545,2\n464#1:553,3\n*E\n"})
public final class ExceptionDataCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, ExceptionConfiguration> configs;
    @NotNull
    private LogCache logCache = new LogCache();
    @NotNull
    private final ExceptionDataCollectionLayout layout = new ExceptionDataCollectionLayout();
    @TestOnly
    @NotNull
    private final List<TrackingAppender> registeredAppenders;
    @NotNull
    private final Regex regex;
    private static final ImmutableList<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableList.of(LinkageError.class, ReflectiveOperationException.class, ArrayIndexOutOfBoundsException.class, ClassCastException.class, IndexOutOfBoundsException.class, NoPiiException.class);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String LOGGER_ERROR_MESSAGE_EXCEPTION = "com.android.diagnostic.LoggerErrorMessage";
    private static final boolean LOG_COLLECTION_ENABLED = true;
    private static final ImmutableList<String> LOGGER_CLASSES;

    public ExceptionDataCollection() {
        List appendersList = null;
        try {
            this.configs = ExceptionDataConfiguration.Companion.getInstance().getConfigurations();
            appendersList = this.initializeLog();
        }
        catch (Throwable t) {
            LOG.error("Cannot initialize exception log collection", t);
            this.configs = MapsKt.emptyMap();
            appendersList = CollectionsKt.emptyList();
        }
        this.registeredAppenders = appendersList;
        this.regex = new Regex("(.*)\\$[0-9]+");
    }

    @NotNull
    public final List<TrackingAppender> getRegisteredAppenders() {
        return this.registeredAppenders;
    }

    /*
     * Unable to fully structure code
     */
    private final List<TrackingAppender> initializeLog() {
        block12: {
            block13: {
                block10: {
                    $this$any$iv = this.configs.values();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v0 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (ExceptionConfiguration)element$iv;
                            $i$a$-any-ExceptionDataCollection$initializeLog$hasAnyLog$1 = false;
                            if (!(it.getAction().getLogFilter().getMessageFilterCount() > 0)) continue;
                            v0 = true;
                            break block10;
                        }
                        v0 = hasAnyLog = false;
                    }
                }
                if (!hasAnyLog) {
                    return CollectionsKt.emptyList();
                }
                if (((Collection)DebugLogManager.Companion.getInstance().getSavedCategories()).isEmpty() == false) {
                    ExceptionDataCollection.LOG.info("Cannot register appenders: debug/trace logging enabled through DebugLogManager.");
                    return CollectionsKt.emptyList();
                }
                $this$any$iv = this.configs.values();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block13;
                v1 = false;
                break block12;
            }
            for (T element$iv : $this$any$iv) {
                block11: {
                    block14: {
                        config = (ExceptionConfiguration)element$iv;
                        $i$a$-any-ExceptionDataCollection$initializeLog$needsToReconfigureAppenders$1 = false;
                        v2 = config.getAction().getLogFilter().getMessageFilterList();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"config.action.logFilter.messageFilterList");
                        $this$any$iv = v2;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block14;
                        v3 = false;
                        break block11;
                    }
                    for (T element$iv : $this$any$iv) {
                        messageFilter = (MessageFilter)element$iv;
                        $i$a$-any-ExceptionDataCollection$initializeLog$needsToReconfigureAppenders$1$1 = false;
                        if (!messageFilter.hasSeverity()) ** GOTO lbl-1000
                        v4 = messageFilter.getSeverity();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"messageFilter.severity");
                        v5 = this.severityToLevel(v4);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"severityToLevel(messageFilter.severity)");
                        v6 = Level.INFO;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"INFO");
                        if (this.isLessThan(v5, v6)) {
                            v7 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v7 = false;
                        }
                        if (!v7) continue;
                        v3 = true;
                        break block11;
                    }
                    v3 = false;
                }
                if (!v3) continue;
                v1 = true;
                break block12;
            }
            v1 = needsToReconfigureAppenders = false;
        }
        if (needsToReconfigureAppenders && !this.tryReconfigureExistingHandlers()) {
            return CollectionsKt.emptyList();
        }
        return this.registerTrackingAppenders();
    }

    private final List<TrackingAppender> registerTrackingAppenders() {
        List registeredAppenders = new ArrayList();
        for (Map.Entry<String, ExceptionConfiguration> entry : this.configs.entrySet()) {
            String name2 = entry.getKey();
            ExceptionConfiguration config2 = entry.getValue();
            ExceptionAction action2 = config2.getAction();
            if (!action2.hasLogFilter() || action2.getLogFilter().getMaxMessageCount() <= 0) continue;
            LogFilter logFilter = action2.getLogFilter();
            Intrinsics.checkNotNullExpressionValue((Object)logFilter, (String)"action.logFilter");
            List<TrackingAppender> newAppenders = this.registerAppendersForLogFilter(name2, logFilter);
            registeredAppenders.addAll((Collection)newAppenders);
        }
        return registeredAppenders;
    }

    private final List<TrackingAppender> registerAppendersForLogFilter(String logName, LogFilter logFilter) {
        LogBuffer logBuffer = this.logCache.getLogBufferFor(logName, logFilter.getMaxMessageCount());
        List result2 = new ArrayList();
        List list2 = logFilter.getMessageFilterList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"logFilter.messageFilterList");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Level desiredLevel;
            java.util.logging.Logger logger2;
            block4: {
                block3: {
                    MessageFilter filter2 = (MessageFilter)element$iv;
                    boolean bl = false;
                    logger2 = LogManager.getLogManager().getLogger(filter2.getLoggerCategory());
                    ExceptionSeverity exceptionSeverity = filter2.getSeverity();
                    Intrinsics.checkNotNullExpressionValue((Object)exceptionSeverity, (String)"filter.severity");
                    desiredLevel = this.severityToLevel(exceptionSeverity);
                    if (logger2.getLevel() == null) break block3;
                    Level level = logger2.getLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"logger.level");
                    Intrinsics.checkNotNullExpressionValue((Object)desiredLevel, (String)"desiredLevel");
                    if (!this.isLessThan(level, desiredLevel)) break block4;
                }
                logger2.setLevel(desiredLevel);
            }
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
            TrackingAppender trackingAppender = new TrackingAppender(logger2, this.layout, logBuffer);
            trackingAppender.setLevel(desiredLevel);
            logger2.addHandler(trackingAppender);
            result2.add(trackingAppender);
        }
        return result2;
    }

    private final Level severityToLevel(ExceptionSeverity severity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1 -> Level.ALL;
            case 2 -> Level.FINE;
            case 3 -> Level.INFO;
            case 4 -> Level.WARNING;
            case 5 -> Level.SEVERE;
            default -> Level.INFO;
        };
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean tryReconfigureExistingHandlers() {
        block9: {
            if (((Collection)DebugLogManager.Companion.getInstance().getSavedCategories()).isEmpty() == false) {
                ExceptionDataCollection.LOG.info("Cannot register appenders: debug/trace logging enabled through DebugLogManager.");
                return false;
            }
            rootLogger = java.util.logging.Logger.getLogger("");
            v0 = rootLogger.getLevel();
            if (v0 == null) {
                v0 = Level.FINE;
            }
            rootLoggerLevel = v0;
            handlers = rootLogger.getHandlers();
            Intrinsics.checkNotNullExpressionValue((Object)handlers, (String)"handlers");
            $this$all$iv = handlers;
            $i$f$all = false;
            var8_8 = $this$all$iv.length;
            for (var7_6 = 0; var7_6 < var8_8; ++var7_6) {
                block10: {
                    handler = element$iv = $this$all$iv[var7_6];
                    $i$a$-all-ExceptionDataCollection$tryReconfigureExistingHandlers$allHandlersAllowed$1 = false;
                    if (!(handler instanceof ConsoleHandler)) break block10;
                    if (((ConsoleHandler)handler).getLevel() == null) ** GOTO lbl-1000
                    v1 = ((ConsoleHandler)handler).getLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"handler.level");
                    Intrinsics.checkNotNullExpressionValue((Object)rootLoggerLevel, (String)"rootLoggerLevel");
                    if (this.isGreaterThanOrEqual(v1, rootLoggerLevel)) ** GOTO lbl-1000
                }
                if (handler instanceof FileHandler) ** GOTO lbl-1000
                if (!(handler instanceof DialogAppender)) ** GOTO lbl-1000
                if (((DialogAppender)handler).getLevel() == null) ** GOTO lbl-1000
                v2 = ((DialogAppender)handler).getLevel();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"handler.level");
                Intrinsics.checkNotNullExpressionValue((Object)rootLoggerLevel, (String)"rootLoggerLevel");
                if (this.isGreaterThanOrEqual(v2, rootLoggerLevel)) lbl-1000:
                // 5 sources

                {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (v3) continue;
                v4 = false;
                break block9;
            }
            v4 = allHandlersAllowed = true;
        }
        if (!allHandlersAllowed) {
            ExceptionDataCollection.LOG.info("Cannot register appenders: unknown appender on root logger or threshold already specified on appenders.");
            return false;
        }
        $this$filterIsInstance$iv /* !! */  = handlers;
        $i$f$filterIsInstance = false;
        var7_7 = $this$filterIsInstance$iv /* !! */ ;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FileHandler)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv /* !! */  = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (FileHandler)element$iv;
            $i$a$-forEach-ExceptionDataCollection$tryReconfigureExistingHandlers$1 = false;
            if (it.getLevel() != null) {
                Intrinsics.checkNotNullExpressionValue((Object)rootLoggerLevel, (String)"rootLoggerLevel");
                v5 = it.getLevel();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it.level");
                if (!this.isLessThan(rootLoggerLevel, v5)) continue;
            }
            it.setLevel(rootLoggerLevel);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UploadFields getExceptionUploadFields(@NotNull Throwable t, boolean forceExceptionMessage, boolean includeLogs) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        try {
            Map map2;
            boolean includeFullStack;
            boolean includeMessage2;
            Map<String, ExceptionConfiguration> configs;
            Throwable cause;
            block13: {
                boolean bl;
                block12: {
                    Throwable throwable = StudioExceptionReport.getRootCause(t);
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getRootCause(t)");
                    cause = throwable;
                    configs = this.getExceptionUploadConfigurations(cause);
                    Iterable $this$any$iv = configs.values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ExceptionConfiguration it = (ExceptionConfiguration)element$iv;
                            boolean bl2 = false;
                            if (!it.getAction().getIncludeExceptionMessage()) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                includeMessage2 = bl || forceExceptionMessage || THROWABLE_CLASSES_TO_TRACK_MESSAGES.stream().anyMatch(new Predicate(t){
                    final /* synthetic */ Throwable $t;
                    {
                        this.$t = $t;
                    }

                    public final boolean test(Class<? extends Throwable> it) {
                        return it.isInstance(this.$t);
                    }
                });
                Iterable $this$any$iv = configs.values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ExceptionConfiguration it = (ExceptionConfiguration)element$iv;
                        boolean bl3 = false;
                        if (!it.getAction().getIncludeFullStack()) continue;
                        v2 = true;
                        break block13;
                    }
                    v2 = includeFullStack = false;
                }
            }
            if (includeLogs) {
                void $this$filterValues$iv;
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv;
                Object element$iv;
                Map<String, ExceptionConfiguration> $i$f$any = configs;
                boolean $i$f$mapValues = false;
                element$iv = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl4 = false;
                    String string = this.logCache.getLogAndClearFor((String)it.getKey());
                    map4.put(k, string);
                }
                $this$mapValues$iv = destination$iv$iv;
                boolean $i$f$filterValues = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                    String it = (String)entry$iv.getValue();
                    boolean bl = false;
                    boolean bl5 = ((CharSequence)it).length() > 0;
                    if (!bl5) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                map2 = MapsKt.toSortedMap((Map)result$iv);
            } else {
                map2 = MapsKt.emptyMap();
            }
            Map logs = map2;
            return new UploadFields(this.getDescription(includeFullStack ? t : cause, !includeMessage2, includeFullStack), logs);
        }
        catch (Throwable t2) {
            LOG.error("getExceptionUploadFields() call failed", t2);
            return new UploadFields(this.getDescription(t2, true, true), MapsKt.emptyMap());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Map<String, ExceptionConfiguration> getExceptionUploadConfigurations(Throwable t) {
        now = new GregorianCalendar();
        now.setTime(AnalyticsSettings.getDateProvider().now());
        $this$filterValues$iv = this.configs;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<String, ExceptionConfiguration>();
        for (Map.Entry<String, ExceptionConfiguration> entry$iv : $this$filterValues$iv.entrySet()) {
            block12: {
                block14: {
                    block10: {
                        block13: {
                            block11: {
                                config = entry$iv.getValue();
                                $i$a$-filterValues-ExceptionDataCollection$getExceptionUploadConfigurations$1 = false;
                                if (config.hasExpirationDate()) break block11;
                                v0 = false;
                                break block12;
                            }
                            expirationDate = new GregorianCalendar();
                            expirationDate.set(config.getExpirationDate().getYear(), config.getExpirationDate().getMonth() - 1, config.getExpirationDate().getDay());
                            if (!now.after(expirationDate)) break block13;
                            v0 = false;
                            break block12;
                        }
                        match = true;
                        atLeastOneFilter = false;
                        filter = config.getExceptionFilter();
                        if (filter.hasExceptionType()) {
                            match = Intrinsics.areEqual((Object)t.getClass().getName(), (Object)filter.getExceptionType()) != false;
                            atLeastOneFilter = true;
                        }
                        if (filter.hasSignature()) {
                            signature = this.calculateSignature(t);
                            match = match != false && Intrinsics.areEqual((Object)signature, (Object)filter.getSignature()) != false;
                            atLeastOneFilter = true;
                        }
                        if (filter.getFramePatternsCount() <= 0) break block14;
                        atLeastOneFilter = true;
                        stackTrace = t.getStackTrace();
                        if (!match) ** GOTO lbl-1000
                        v1 = filter.getFramePatternsList();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter.framePatternsList");
                        $this$all$iv = (Iterable)v1;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v2 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                block9: {
                                    frameToMatch = (String)element$iv;
                                    $i$a$-all-ExceptionDataCollection$getExceptionUploadConfigurations$1$1 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
                                    $this$any$iv = stackTrace;
                                    $i$f$any = false;
                                    var24_24 = $this$any$iv.length;
                                    for (var23_23 = 0; var23_23 < var24_24; ++var23_23) {
                                        frame = element$iv = $this$any$iv[var23_23];
                                        $i$a$-any-ExceptionDataCollection$getExceptionUploadConfigurations$1$1$1 = false;
                                        if (!Intrinsics.areEqual((Object)(frame.getClassName() + frame.getMethodName()), (Object)frameToMatch)) continue;
                                        v3 = true;
                                        break block9;
                                    }
                                    v3 = false;
                                }
                                if (v3) continue;
                                v2 = false;
                                break block10;
                            }
                            v2 = true;
                        }
                    }
                    if (v2) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    match = v4;
                }
                v0 = atLeastOneFilter != false && match != false;
            }
            if (!v0) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @NotNull
    public final String calculateSignature(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        StackTraceElement[] originalStackTrace = t.getStackTrace();
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"t.stackTrace");
        if (((Object[])stackTraceElementArray).length == 0) {
            return "MissingCrashedThreadStack";
        }
        StackTraceElement[] stackTraceElementArray2 = t.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray2, (String)"t.stackTrace");
        Object[] stackTrace = this.removeLoggerErrorFrames(stackTraceElementArray2);
        boolean isLoggerError = originalStackTrace.length != stackTrace.length;
        StringBuilder sb = new StringBuilder();
        CollectionsKt.joinTo$default((Iterable)ArraysKt.slice((Object[])stackTrace, (IntRange)RangesKt.until((int)1, (int)Integer.min(6, stackTrace.length))), (Appendable)sb, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<StackTraceElement, CharSequence>(this){
            final /* synthetic */ ExceptionDataCollection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull StackTraceElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String methodName = it.getMethodName();
                Regex regex = ExceptionDataCollection.access$getRegex$p(this.this$0);
                String string = methodName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodName");
                MatchResult matchResult = regex.matchEntire((CharSequence)string);
                if (matchResult != null) {
                    methodName = (String)matchResult.getGroupValues().get(1);
                }
                return !Intrinsics.areEqual((Object)methodName, (Object)"") ? (CharSequence)(it.getClassName() + "." + methodName) : (CharSequence)"";
            }
        }), (int)60, null);
        String className = isLoggerError ? LOGGER_ERROR_MESSAGE_EXCEPTION : t.getClass().getName();
        String signaturePrefix = className + " at " + ((StackTraceElement)stackTrace[0]).getClassName() + "." + ((StackTraceElement)stackTrace[0]).getMethodName();
        sb.append(signaturePrefix);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        String string2 = string;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] hashBytes = digest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)hashBytes, (String)"hashBytes");
        String string3 = ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, (Function1)calculateSignature.hash.1.INSTANCE, (int)30, null).substring(0, 8);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String hash2 = string3;
        return signaturePrefix + "-" + hash2;
    }

    private final StackTraceElement[] removeLoggerErrorFrames(StackTraceElement[] stackTraceElements) {
        int firstNonLoggerFrame;
        for (firstNonLoggerFrame = 0; firstNonLoggerFrame < stackTraceElements.length && Intrinsics.areEqual((Object)stackTraceElements[firstNonLoggerFrame].getMethodName(), (Object)"error") && LOGGER_CLASSES.contains((Object)stackTraceElements[firstNonLoggerFrame].getClassName()); ++firstNonLoggerFrame) {
        }
        return (StackTraceElement[])ArraysKt.sliceArray((Object[])stackTraceElements, (IntRange)RangesKt.until((int)firstNonLoggerFrame, (int)stackTraceElements.length));
    }

    @NotNull
    public final String getDescription(@NotNull Throwable t, boolean stripMessage, boolean includeFullStack) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        StringBuilder sb = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.getDescription(t, stripMessage, includeFullStack, null, 1, sb);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().also { s\u2026, 1, sb)\n    }.toString()");
        return string;
    }

    private final void getDescription(Throwable t, boolean stripMessage, boolean includeFullStack, Throwable containingThrowable, int depth, StringBuilder sb) {
        block7: {
            if (depth >= 20) {
                return;
            }
            if (!stripMessage) {
                String traceAsString = Throwables.getStackTraceAsString((Throwable)t);
                Intrinsics.checkNotNullExpressionValue((Object)traceAsString, (String)"traceAsString");
                sb.append(this.fixStackTraceStringForLoggerErrorMethod(traceAsString));
                return;
            }
            StackTraceElement[] originalStackTraceElements = t.getStackTrace();
            StackTraceElement[] stackTraceElementArray = t.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"t.stackTrace");
            StackTraceElement[] stackTraceElements = this.removeLoggerErrorFrames(stackTraceElementArray);
            boolean isLoggerErrorException = stackTraceElements.length != originalStackTraceElements.length;
            String exceptionName = isLoggerErrorException ? LOGGER_ERROR_MESSAGE_EXCEPTION : t.getClass().getName();
            sb.append(exceptionName + ": <elided>\n");
            int commonFrames = 0;
            if (containingThrowable != null) {
                int currThis = stackTraceElements.length - 1;
                StackTraceElement[] containingTrace = containingThrowable.getStackTrace();
                int currContaining = containingTrace.length - 1;
                while (currThis >= 0 && currContaining >= 0 && Intrinsics.areEqual((Object)stackTraceElements[currThis], (Object)containingTrace[currContaining])) {
                    --currThis;
                    --currContaining;
                    ++commonFrames;
                }
            }
            int n = stackTraceElements.length - commonFrames;
            for (int i = 0; i < n; ++i) {
                sb.append("\tat " + stackTraceElements[i] + "\n");
            }
            if (commonFrames > 0) {
                sb.append("\t... " + commonFrames + " more");
            }
            if (!includeFullStack) break block7;
            Throwable throwable = t.getCause();
            if (throwable != null) {
                Throwable cause = throwable;
                boolean bl = false;
                sb.append("Caused by: ");
                this.getDescription(cause, stripMessage, includeFullStack, t, depth + 1, sb);
            }
        }
    }

    private final String fixStackTraceStringForLoggerErrorMethod(String s) {
        int indexOfFirstNonLoggerFrame;
        int indexOfFirstFrame;
        String throwableText;
        String[] lines2;
        block6: {
            int n;
            CharSequence charSequence = s;
            Regex regex = new Regex("\n");
            int n2 = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n2);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            lines2 = thisCollection$iv.toArray(new String[0]);
            if (lines2.length <= 2) {
                return s;
            }
            throwableText = Throwable.class.getName();
            String throwableColonText = throwableText + ":";
            if (!Intrinsics.areEqual((Object)lines2[0], (Object)throwableText) && !StringsKt.startsWith$default((String)lines2[0], (String)throwableColonText, (boolean)false, (int)2, null)) {
                return s;
            }
            String[] $this$indexOfFirst$iv = lines2;
            boolean $i$f$indexOfFirst = false;
            int n3 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n3; ++index$iv) {
                String it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"\tat ", (boolean)false, (int)2, null)) continue;
                n = index$iv;
                break block6;
            }
            n = indexOfFirstFrame = -1;
        }
        if (indexOfFirstFrame == -1) {
            return s;
        }
        for (indexOfFirstNonLoggerFrame = indexOfFirstFrame; indexOfFirstNonLoggerFrame < lines2.length && (StringsKt.startsWith$default((String)lines2[indexOfFirstNonLoggerFrame], (String)("\tat " + Logger.class.getName() + ".error("), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lines2[indexOfFirstNonLoggerFrame], (String)("\tat " + IdeaLogger.class.getName() + ".error("), (boolean)false, (int)2, null)); ++indexOfFirstNonLoggerFrame) {
        }
        if (indexOfFirstNonLoggerFrame == lines2.length || indexOfFirstNonLoggerFrame == indexOfFirstFrame) {
            return s;
        }
        String string = lines2[0].substring(throwableText.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        lines2[0] = LOGGER_ERROR_MESSAGE_EXCEPTION + string;
        Stream<String> exceptionMessageLines = Arrays.stream(lines2).limit(indexOfFirstFrame);
        Stream<String> stackFramesLines = Arrays.stream(lines2).skip(indexOfFirstNonLoggerFrame);
        String string2 = Stream.concat(exceptionMessageLines, stackFramesLines).collect(Collectors.joining("\n"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"concat(exceptionMessageL\u2026Collectors.joining(\"\\n\"))");
        return string2;
    }

    public final boolean requiresConfirmation(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        try {
            boolean bl;
            block5: {
                Map<String, ExceptionConfiguration> exceptionUploadConfigurations;
                Throwable throwable = StudioExceptionReport.getRootCause(t);
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getRootCause(t)");
                Throwable cause = throwable;
                Map<String, ExceptionConfiguration> $this$any$iv = exceptionUploadConfigurations = this.getExceptionUploadConfigurations(cause);
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<String, ExceptionConfiguration>> iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, ExceptionConfiguration> element$iv;
                        Map.Entry<String, ExceptionConfiguration> entry = element$iv = iterator2.next();
                        boolean bl2 = false;
                        ExceptionConfiguration config2 = entry.getValue();
                        if (!(!config2.getAction().hasRequiresConfirmation() || config2.getAction().getRequiresConfirmation())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        catch (Throwable t2) {
            LOG.warn("cannot compute if exception requires confirmation", t2);
            return false;
        }
    }

    private final boolean isGreaterThanOrEqual(Level $this$isGreaterThanOrEqual, Level other) {
        return $this$isGreaterThanOrEqual.intValue() >= other.intValue();
    }

    private final boolean isLessThan(Level $this$isLessThan, Level other) {
        return $this$isLessThan.intValue() < other.intValue();
    }

    @TestOnly
    public final void unregisterLogAppenders() {
        Iterable $this$forEach$iv = this.registeredAppenders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackingAppender trackingAppender = (TrackingAppender)element$iv;
            boolean bl = false;
            java.util.logging.Logger logger2 = trackingAppender.getLogger();
            logger2.removeHandler(trackingAppender);
        }
    }

    @JvmStatic
    @NotNull
    public static final ExceptionDataCollection getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Regex access$getRegex$p(ExceptionDataCollection $this) {
        return $this.regex;
    }

    static {
        Logger logger2 = Logger.getInstance(ExceptionDataCollection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(ExceptionDataCollection::class.java)");
        LOG = logger2;
        LOGGER_CLASSES = ImmutableList.of((Object)Logger.class.getName(), (Object)IdeaLogger.class.getName());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000RR\u0010\r\u001aF\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u000f \t*\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e0\u000e \t*\"\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u000f \t*\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e0\u000e\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOGGER_CLASSES", "Lcom/google/common/collect/ImmutableList;", "", "kotlin.jvm.PlatformType", "LOGGER_ERROR_MESSAGE_EXCEPTION", "LOG_COLLECTION_ENABLED", "", "THROWABLE_CLASSES_TO_TRACK_MESSAGES", "Ljava/lang/Class;", "", "getInstance", "Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExceptionDataCollection getInstance() {
            Object object = ApplicationManager.getApplication().getService(ExceptionDataCollection.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026taCollection::class.java)");
            return (ExceptionDataCollection)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$ExceptionDataCollectionLayout;", "Ljava/util/logging/Formatter;", "()V", "creationTimestamp", "", "format", "", "event", "Ljava/util/logging/LogRecord;", "intellij.android.core"})
    public static final class ExceptionDataCollectionLayout
    extends Formatter {
        private final long creationTimestamp = System.currentTimeMillis();

        @Override
        @NotNull
        public String format(@Nullable LogRecord event2) {
            StringBuilder stringBuilder;
            if (event2 == null) {
                return "";
            }
            long now = System.currentTimeMillis();
            StringBuilder $this$format_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$format_u24lambda_u240.append('[');
            $this$format_u24lambda_u240.append(StringsKt.padStart$default((String)String.valueOf(now - this.creationTimestamp), (int)7, (char)'\u0000', (int)2, null));
            $this$format_u24lambda_u240.append("] ");
            String string = event2.getLevel().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.getLevel().toString()");
            String levelString = string;
            String string2 = levelString.substring(0, Integer.min(1, levelString.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$format_u24lambda_u240.append(string2);
            $this$format_u24lambda_u240.append(" [");
            String category = event2.getLoggerName();
            Intrinsics.checkNotNullExpressionValue((Object)category, (String)"category");
            String string3 = category.substring(Integer.max(0, category.length() - 30), category.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$format_u24lambda_u240.append(string3);
            $this$format_u24lambda_u240.append("] ");
            String message2 = event2.getMessage().toString();
            String string4 = message2.substring(0, Integer.min(200, message2.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$format_u24lambda_u240.append(string4);
            String string5 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
            return string5;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/diagnostics/crash/ExceptionDataCollection$TrackingAppender;", "Ljava/util/logging/Handler;", "logger", "Ljava/util/logging/Logger;", "formatter", "Ljava/util/logging/Formatter;", "logBuffer", "Lcom/android/tools/idea/diagnostics/crash/LogBuffer;", "(Ljava/util/logging/Logger;Ljava/util/logging/Formatter;Lcom/android/tools/idea/diagnostics/crash/LogBuffer;)V", "getLogger", "()Ljava/util/logging/Logger;", "close", "", "flush", "publish", "record", "Ljava/util/logging/LogRecord;", "intellij.android.core"})
    public static final class TrackingAppender
    extends Handler {
        @NotNull
        private final java.util.logging.Logger logger;
        @NotNull
        private final LogBuffer logBuffer;

        public TrackingAppender(@NotNull java.util.logging.Logger logger2, @NotNull Formatter formatter, @NotNull LogBuffer logBuffer) {
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
            Intrinsics.checkNotNullParameter((Object)logBuffer, (String)"logBuffer");
            this.logger = logger2;
            this.logBuffer = logBuffer;
            this.setFormatter(formatter);
        }

        @NotNull
        public final java.util.logging.Logger getLogger() {
            return this.logger;
        }

        @Override
        public void publish(@NotNull LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            if (Intrinsics.areEqual((Object)record.getLoggerName(), (Object)this.logger.getName())) {
                String string = this.getFormatter().format(record);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(record)");
                this.logBuffer.addEntry(string);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExceptionSeverity.values().length];
            try {
                nArray[ExceptionSeverity.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionSeverity.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionSeverity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionSeverity.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionSeverity.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

