/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class WindowsCRuntimeChecker
implements StartupActivity.Background {
    public WindowsCRuntimeChecker() {
        if (!SystemInfo.isWindows || !((Boolean)StudioFlags.WINDOWS_UCRT_CHECK_ENABLED.get()).booleanValue()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public void runActivity(@NotNull Project project) {
        ApplicationManager.getApplication().executeOnPooledThread(WindowsCRuntimeChecker::checkCRT);
    }

    private static void checkCRT() {
        Path dllPath = Paths.get(System.getenv("SystemRoot"), "system32", "ucrtbase.dll");
        if (!dllPath.toFile().exists()) {
            AndroidStudioSystemHealthMonitor systemHealthMonitor = AndroidStudioSystemHealthMonitor.getInstance();
            systemHealthMonitor.showNotification("windows.ucrt.warn.message", AndroidStudioSystemHealthMonitor.detailsAction("https://support.microsoft.com/en-ca/help/2999226/update-for-universal-c-runtime-in-windows"), new Object[0]);
        }
    }
}

