/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/TruncatingStringBuilder;", "", "maxSize", "", "truncationMessage", "", "(ILjava/lang/String;)V", "hasHitLimit", "", "getMaxSize", "()I", "size", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTruncationMessage", "()Ljava/lang/String;", "append", "", "s", "toString", "intellij.android.core"})
public final class TruncatingStringBuilder {
    private final int maxSize;
    @NotNull
    private final String truncationMessage;
    @NotNull
    private final StringBuilder stringBuilder;
    private boolean hasHitLimit;
    private int size;

    public TruncatingStringBuilder(int maxSize, @NotNull String truncationMessage) {
        Intrinsics.checkNotNullParameter((Object)truncationMessage, (String)"truncationMessage");
        this.maxSize = maxSize;
        this.truncationMessage = truncationMessage;
        this.stringBuilder = new StringBuilder();
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    @NotNull
    public final String getTruncationMessage() {
        return this.truncationMessage;
    }

    public final void append(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.hasHitLimit) {
            return;
        }
        if (s.length() + this.size > this.maxSize) {
            this.hasHitLimit = true;
            String string = s.substring(0, this.maxSize - this.size);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.stringBuilder.append(StringsKt.substringBeforeLast$default((String)string, (String)"\n", null, (int)2, null));
            this.stringBuilder.append(this.truncationMessage);
        } else {
            this.stringBuilder.append(s);
            this.size += s.length();
        }
    }

    @NotNull
    public String toString() {
        String string = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }
}

