/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.ExceptionRegistry;
import com.android.tools.idea.diagnostics.StackTrace;
import com.android.utils.DateProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 2\b\b\u0002\u0010!\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/diagnostics/ExceptionRegistry;", "", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "dateProvider", "Lcom/android/utils/DateProvider;", "getDateProvider$annotations", "getDateProvider", "()Lcom/android/utils/DateProvider;", "setDateProvider", "(Lcom/android/utils/DateProvider;)V", "leafNodes", "", "Lcom/android/tools/idea/diagnostics/ExceptionRegistry$LeafNode;", "root", "Lcom/android/tools/idea/diagnostics/ExceptionRegistry$StackFrame;", "addFrames", "Lcom/android/tools/idea/diagnostics/StackTrace;", "throwable", "", "clear", "", "find", "md5", "", "getMostFrequent", "getStackTraces", "", "threshold", "register", "LeafNode", "StackFrame", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nExceptionRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionRegistry.kt\ncom/android/tools/idea/diagnostics/ExceptionRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,433:1\n1#2:434\n1959#3,14:435\n766#3:449\n857#3,2:450\n288#3,2:452\n*S KotlinDebug\n*F\n+ 1 ExceptionRegistry.kt\ncom/android/tools/idea/diagnostics/ExceptionRegistry\n*L\n134#1:435,14\n151#1:449\n151#1:450,2\n185#1:452,2\n*E\n"})
public final class ExceptionRegistry {
    @NotNull
    public static final ExceptionRegistry INSTANCE = new ExceptionRegistry();
    private static int count;
    @NotNull
    private static final StackFrame root;
    @NotNull
    private static final List<LeafNode> leafNodes;
    @NotNull
    private static DateProvider dateProvider;

    private ExceptionRegistry() {
    }

    public final int getCount() {
        return count;
    }

    public final void setCount(int n) {
        count = n;
    }

    @NotNull
    public final DateProvider getDateProvider() {
        return dateProvider;
    }

    public final void setDateProvider(@NotNull DateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"<set-?>");
        ExceptionRegistry.dateProvider = dateProvider;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDateProvider$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StackTrace register(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            boolean bl = false;
            ++count;
            StackTrace stackTrace = INSTANCE.addFrames(throwable);
            return stackTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int count() {
        int n;
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            boolean bl = false;
            n = count;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StackTrace getMostFrequent() {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            Object v0;
            block9: {
                boolean bl = false;
                if (!leafNodes.isEmpty()) break block9;
                StackTrace stackTrace = null;
                return stackTrace;
            }
            Iterable $this$maxByOrNull$iv = leafNodes;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    LeafNode it = (LeafNode)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getCount();
                    do {
                        Object e$iv = iterator$iv.next();
                        LeafNode it2 = (LeafNode)e$iv;
                        $i$a$-maxByOrNull-ExceptionRegistry$getMostFrequent$1$1 = false;
                        int v$iv = it2.getCount();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type com.android.tools.idea.diagnostics.StackTrace");
            StackTrace stackTrace = v0;
            return stackTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            boolean bl = false;
            count = 0;
            root.setFirstChild(null);
            root.setNextSibling(null);
            leafNodes.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<StackTrace> getStackTraces(int threshold) {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = leafNodes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LeafNode it = (LeafNode)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getCount() >= threshold)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            CollectionsKt.sort((List)list2);
            List list3 = list2;
            return list3;
        }
    }

    public static /* synthetic */ List getStackTraces$default(ExceptionRegistry exceptionRegistry, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return exceptionRegistry.getStackTraces(n);
    }

    private final StackTrace addFrames(Throwable throwable) {
        StackFrame curr = root;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
        if (stackTrace.length == 0) {
            curr = curr.addChild(new StackTraceElement(throwable.getClass().getName(), "", "", 0));
        } else {
            int max;
            for (int index2 = max = stackTrace.length - 1; -1 < index2; --index2) {
                StackTraceElement element2 = stackTrace[index2];
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
                curr = curr.addChild(element2);
            }
        }
        LeafNode leaf = curr.addLeaf(throwable.getClass(), dateProvider.now().getTime());
        if (leaf.getCount() == 1) {
            leafNodes.add(leaf);
        }
        return leaf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StackTrace find(@NotNull String md5) {
        Intrinsics.checkNotNullParameter((Object)md5, (String)"md5");
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            Object v0;
            block4: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = leafNodes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LeafNode it = (LeafNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)md5, (Object)it.md5string())) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            StackTrace stackTrace = v0;
            return stackTrace;
        }
    }

    static {
        root = new StackFrame(new StackTraceElement("ROOT", "", "", 0), null);
        leafNodes = new ArrayList();
        DateProvider dateProvider = DateProvider.SYSTEM;
        Intrinsics.checkNotNull((Object)dateProvider);
        ExceptionRegistry.dateProvider = dateProvider;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0001H\u0096\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\rH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/diagnostics/ExceptionRegistry$LeafNode;", "Lcom/android/tools/idea/diagnostics/StackTrace;", "cls", "Ljava/lang/Class;", "", "parent", "Lcom/android/tools/idea/diagnostics/ExceptionRegistry$StackFrame;", "timeOfFirstHitMs", "", "(Ljava/lang/Class;Lcom/android/tools/idea/diagnostics/ExceptionRegistry$StackFrame;J)V", "getCls", "()Ljava/lang/Class;", "<set-?>", "", "count", "getCount", "()I", "md5String", "", "getParent", "()Lcom/android/tools/idea/diagnostics/ExceptionRegistry$StackFrame;", "getTimeOfFirstHitMs", "()J", "compareTo", "other", "frameSequence", "Lkotlin/sequences/Sequence;", "incrementCount", "", "md5", "Lcom/google/common/hash/HashCode;", "md5string", "printStackTrace", "writer", "Ljava/io/PrintWriter;", "summarize", "maxWidth", "toStackTrace", "intellij.android.core"})
    private static final class LeafNode
    implements StackTrace {
        @NotNull
        private final Class<Object> cls;
        @NotNull
        private final StackFrame parent;
        private final long timeOfFirstHitMs;
        private int count;
        @Nullable
        private String md5String;

        public LeafNode(@NotNull Class<Object> cls, @NotNull StackFrame parent2, long timeOfFirstHitMs) {
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            this.cls = cls;
            this.parent = parent2;
            this.timeOfFirstHitMs = timeOfFirstHitMs;
            this.count = 1;
        }

        @NotNull
        public final Class<Object> getCls() {
            return this.cls;
        }

        @NotNull
        public final StackFrame getParent() {
            return this.parent;
        }

        public final long getTimeOfFirstHitMs() {
            return this.timeOfFirstHitMs;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public long timeOfFirstHitMs() {
            return this.timeOfFirstHitMs;
        }

        @Override
        @NotNull
        public String summarize(int maxWidth) {
            StringBuilder sb = new StringBuilder(maxWidth);
            String prevClass = null;
            prevClass = "";
            String prevMethod = null;
            prevMethod = "";
            char arrow = '\u2190';
            sb.append(this.cls.getSimpleName()).append(": ");
            for (StackFrame curr : this.frameSequence()) {
                StackTraceElement $this$summarize_u24lambda_u240 = curr.getFrame();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)$this$summarize_u24lambda_u240.getClassName(), (Object)prevClass)) {
                    String string = $this$summarize_u24lambda_u240.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
                    sb.append(StringsKt.substringAfterLast((String)string, (char)'.', (String)""));
                }
                if (!Intrinsics.areEqual((Object)$this$summarize_u24lambda_u240.getMethodName(), (Object)prevMethod)) {
                    if (StringsKt.last((CharSequence)sb) != arrow) {
                        sb.append('.');
                    }
                    sb.append($this$summarize_u24lambda_u240.getMethodName());
                }
                if ($this$summarize_u24lambda_u240.getLineNumber() >= 1) {
                    if (StringsKt.last((CharSequence)sb) != arrow) {
                        sb.append(':');
                    }
                    sb.append(Integer.toString($this$summarize_u24lambda_u240.getLineNumber()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$summarize_u24lambda_u240.getClassName(), (String)"className");
                Intrinsics.checkNotNullExpressionValue((Object)$this$summarize_u24lambda_u240.getMethodName(), (String)"methodName");
                sb.append(arrow);
                if (sb.length() <= maxWidth) continue;
            }
            if (StringsKt.endsWith$default((CharSequence)sb, (char)arrow, (boolean)false, (int)2, null)) {
                sb.setLength(sb.length() - 1);
            }
            if (sb.length() > maxWidth) {
                sb.setLength(maxWidth - 1);
                sb.append('\u2026');
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        @Override
        @NotNull
        public HashCode md5() {
            HashFunction hf = Hashing.md5();
            Hasher hc = hf.newHasher();
            hc.putString((CharSequence)this.cls.getName(), Charsets.UTF_8);
            for (StackFrame curr : this.frameSequence()) {
                String string;
                String string2;
                StackTraceElement $this$md5_u24lambda_u241 = curr.getFrame();
                boolean bl = false;
                hc.putString((CharSequence)$this$md5_u24lambda_u241.getClassName(), Charsets.UTF_8);
                hc.putString((CharSequence)$this$md5_u24lambda_u241.getMethodName(), Charsets.UTF_8);
                String string3 = string2 = $this$md5_u24lambda_u241.getFileName();
                if (string3 == null) {
                    string = "";
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fileName ?: \"\"");
                    string = string2;
                }
                hc.putString((CharSequence)string, Charsets.UTF_8);
                hc.putInt($this$md5_u24lambda_u241.getLineNumber());
            }
            HashCode hashCode = hc.hash();
            Intrinsics.checkNotNullExpressionValue((Object)hashCode, (String)"hc.hash()");
            return hashCode;
        }

        @Override
        @NotNull
        public String md5string() {
            if (this.md5String == null) {
                HashCode hash2 = this.md5();
                byte[] bytes2 = hash2.asBytes();
                this.md5String = BaseEncoding.base16().upperCase().encode(bytes2);
            }
            String string = this.md5String;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @Override
        @NotNull
        public String toStackTrace() {
            StringWriter writer2 = new StringWriter();
            this.printStackTrace(new PrintWriter(writer2));
            String string = writer2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
            return string;
        }

        @Override
        public void printStackTrace(@NotNull PrintWriter writer2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            writer2.print(this.cls.getName());
            writer2.print(":\n");
            for (StackFrame curr : this.frameSequence()) {
                writer2.print("\tat ");
                StackTraceElement $this$printStackTrace_u24lambda_u242 = curr.getFrame();
                boolean bl = false;
                writer2.print($this$printStackTrace_u24lambda_u242.getClassName());
                writer2.print('.');
                writer2.print($this$printStackTrace_u24lambda_u242.getMethodName());
                if ($this$printStackTrace_u24lambda_u242.getLineNumber() == -2) {
                    writer2.print("(Native Method)");
                } else if ($this$printStackTrace_u24lambda_u242.getFileName() != null) {
                    writer2.print('(');
                    writer2.print($this$printStackTrace_u24lambda_u242.getFileName());
                    writer2.print(':');
                    writer2.print($this$printStackTrace_u24lambda_u242.getMethodName());
                    writer2.print(')');
                }
                writer2.print("\n");
            }
        }

        @Override
        public int compareTo(@NotNull StackTrace other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            LeafNode otherLeaf = (LeafNode)other;
            int delta = Intrinsics.compare((int)otherLeaf.getCount(), (int)this.getCount());
            if (delta != 0) {
                return delta;
            }
            return this.parent.compareTo(otherLeaf.parent);
        }

        private final Sequence<StackFrame> frameSequence() {
            return SequencesKt.generateSequence((Object)this.parent, (Function1)frameSequence.1.INSTANCE);
        }

        public final void incrementCount() {
            int n = this.getCount();
            this.count = n + 1;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u001c\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/diagnostics/ExceptionRegistry$StackFrame;", "", "frame", "Ljava/lang/StackTraceElement;", "parent", "(Ljava/lang/StackTraceElement;Lcom/android/tools/idea/diagnostics/ExceptionRegistry$StackFrame;)V", "firstChild", "getFirstChild", "()Lcom/android/tools/idea/diagnostics/ExceptionRegistry$StackFrame;", "setFirstChild", "(Lcom/android/tools/idea/diagnostics/ExceptionRegistry$StackFrame;)V", "getFrame", "()Ljava/lang/StackTraceElement;", "leafNode", "Lcom/android/tools/idea/diagnostics/ExceptionRegistry$LeafNode;", "getLeafNode", "()Lcom/android/tools/idea/diagnostics/ExceptionRegistry$LeafNode;", "setLeafNode", "(Lcom/android/tools/idea/diagnostics/ExceptionRegistry$LeafNode;)V", "nextSibling", "getNextSibling", "setNextSibling", "getParent", "addChild", "addLeaf", "cls", "Ljava/lang/Class;", "currentTimestampMs", "", "compareTo", "", "otherFrame", "matches", "", "element", "intellij.android.core"})
    private static class StackFrame {
        @NotNull
        private final StackTraceElement frame;
        @Nullable
        private final StackFrame parent;
        @Nullable
        private StackFrame firstChild;
        @Nullable
        private StackFrame nextSibling;
        @Nullable
        private LeafNode leafNode;

        public StackFrame(@NotNull StackTraceElement frame, @Nullable StackFrame parent2) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            this.frame = frame;
            this.parent = parent2;
        }

        @NotNull
        public final StackTraceElement getFrame() {
            return this.frame;
        }

        @Nullable
        public final StackFrame getParent() {
            return this.parent;
        }

        @Nullable
        public final StackFrame getFirstChild() {
            return this.firstChild;
        }

        public final void setFirstChild(@Nullable StackFrame stackFrame) {
            this.firstChild = stackFrame;
        }

        @Nullable
        public final StackFrame getNextSibling() {
            return this.nextSibling;
        }

        public final void setNextSibling(@Nullable StackFrame stackFrame) {
            this.nextSibling = stackFrame;
        }

        @Nullable
        public final LeafNode getLeafNode() {
            return this.leafNode;
        }

        public final void setLeafNode(@Nullable LeafNode leafNode) {
            this.leafNode = leafNode;
        }

        @NotNull
        public final StackFrame addChild(@NotNull StackTraceElement frame) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            if (this.firstChild == null) {
                StackFrame child;
                this.firstChild = child = new StackFrame(frame, this);
                return child;
            }
            StackFrame prev = null;
            StackFrame curr = this.firstChild;
            while (curr != null) {
                if (curr.matches(frame)) {
                    return curr;
                }
                prev = curr;
                curr = curr.nextSibling;
            }
            StackFrame child = new StackFrame(frame, this);
            Intrinsics.checkNotNull((Object)prev);
            prev.nextSibling = child;
            return child;
        }

        @NotNull
        public final LeafNode addLeaf(@NotNull Class<Object> cls, long currentTimestampMs) {
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            LeafNode localLeafFrame = this.leafNode;
            if (localLeafFrame == null) {
                this.leafNode = localLeafFrame = new LeafNode(cls, this, currentTimestampMs);
            } else {
                localLeafFrame.incrementCount();
            }
            return localLeafFrame;
        }

        private final boolean matches(StackTraceElement element2) {
            return Intrinsics.areEqual((Object)element2, (Object)this.frame);
        }

        public final int compareTo(@NotNull StackFrame otherFrame) {
            String otherFileName;
            String string;
            String fileName;
            Intrinsics.checkNotNullParameter((Object)otherFrame, (String)"otherFrame");
            String string2 = this.frame.getClassName();
            String string3 = otherFrame.frame.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"otherFrame.frame.className");
            int delta = string2.compareTo(string3);
            if (delta != 0) {
                return delta;
            }
            String string4 = this.frame.getMethodName();
            String string5 = otherFrame.frame.getMethodName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"otherFrame.frame.methodName");
            delta = string4.compareTo(string5);
            if (delta != 0) {
                return delta;
            }
            String string6 = this.frame.getFileName();
            if (string6 == null) {
                string6 = fileName = "";
            }
            if ((string = otherFrame.frame.getFileName()) == null) {
                string = "";
            }
            if ((delta = fileName.compareTo(otherFileName = string)) != 0) {
                return delta;
            }
            return this.frame.getLineNumber() - otherFrame.frame.getLineNumber();
        }
    }
}

