/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticsReportCleaner;
import com.android.tools.idea.diagnostics.DiagnosticsReportCleanerKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/DiagnosticsReportCleaner;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.android.core"})
public final class DiagnosticsReportCleaner
implements StartupActivity.Background {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path2 = Paths.get(PathManager.getLogPath(), new String[0]);
        for (String directory : DiagnosticsReportCleanerKt.access$getDIRECTORIES$p()) {
            Path path3 = path2.resolve(directory);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path.resolve(directory)");
            Companion.cleanupFiles(path3);
        }
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        Companion.cleanupDirectories(path2, DiagnosticsReportCleanerKt.access$getDIRECTORY_REGEXES$p());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J#\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/diagnostics/DiagnosticsReportCleaner$Companion;", "", "()V", "cleanupDirectories", "", "path", "Ljava/nio/file/Path;", "regexes", "", "Lkotlin/text/Regex;", "(Ljava/nio/file/Path;[Lkotlin/text/Regex;)V", "cleanupFiles", "isOld", "", "shouldDeleteDirectory", "(Ljava/nio/file/Path;[Lkotlin/text/Regex;)Z", "shouldDeleteFile", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nDiagnosticsReportCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsReportCleaner.kt\ncom/android/tools/idea/diagnostics/DiagnosticsReportCleaner$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,80:1\n12708#2,2:81\n*S KotlinDebug\n*F\n+ 1 DiagnosticsReportCleaner.kt\ncom/android/tools/idea/diagnostics/DiagnosticsReportCleaner$Companion\n*L\n73#1:81,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void cleanupFiles(@NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                return;
            }
            Iterator iterator2 = Files.list(path2).filter(cleanupFiles.1.INSTANCE).iterator();
            while (iterator2.hasNext()) {
                Path child = (Path)iterator2.next();
                Files.delete(child);
            }
        }

        public final void cleanupDirectories(@NotNull Path path2, @NotNull Regex[] regexes) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)regexes, (String)"regexes");
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                return;
            }
            Iterator iterator2 = Files.list(path2).filter(new Predicate(regexes){
                final /* synthetic */ Regex[] $regexes;
                {
                    this.$regexes = $regexes;
                }

                public final boolean test(Path it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return com.android.tools.idea.diagnostics.DiagnosticsReportCleaner$Companion.access$shouldDeleteDirectory(DiagnosticsReportCleaner.Companion, it, this.$regexes);
                }
            }).iterator();
            while (iterator2.hasNext()) {
                Path directory = (Path)iterator2.next();
                File file2 = directory.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"directory.toFile()");
                FilesKt.deleteRecursively((File)file2);
            }
        }

        private final boolean shouldDeleteFile(Path path2) {
            return Files.isRegularFile(path2, new LinkOption[0]) && this.isOld(path2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldDeleteDirectory(Path path2, Regex[] regexes) {
            block2: {
                if (!Files.isDirectory(path2, new LinkOption[0])) return false;
                Regex[] $this$any$iv = regexes;
                boolean $i$f$any = false;
                int n = 0;
                int n2 = $this$any$iv.length;
                while (n < n2) {
                    Regex element$iv;
                    Regex it = element$iv = $this$any$iv[n];
                    boolean bl = false;
                    if (!it.matches((CharSequence)PathsKt.getName((Path)path2))) {
                        ++n;
                        continue;
                    }
                    break block2;
                }
                return false;
            }
            boolean bl = true;
            if (!bl) return false;
            if (!this.isOld(path2)) return false;
            return true;
        }

        private final boolean isOld(Path path2) {
            return Duration.ofMillis(System.currentTimeMillis() - Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis()).compareTo(DiagnosticsReportCleanerKt.access$getMAX_AGE$p()) > 0;
        }

        public static final /* synthetic */ boolean access$shouldDeleteFile(Companion $this, Path path2) {
            return $this.shouldDeleteFile(path2);
        }

        public static final /* synthetic */ boolean access$shouldDeleteDirectory(Companion $this, Path path2, Regex[] regexes) {
            return $this.shouldDeleteDirectory(path2, regexes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

