/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanagerv2;

import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.sdklib.deviceprovisioner.DeviceState;
import com.android.tools.adtui.categorytable.IconButton;
import com.android.tools.idea.device.explorer.DeviceExplorerService;
import com.android.tools.idea.devicemanagerv2.DeviceManagerBundle;
import com.android.tools.idea.devicemanagerv2.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanagerv2.DeviceRowData;
import com.android.tools.idea.file.explorer.toolwindow.DeviceExplorer;
import com.android.tools.idea.flags.StudioFlags;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/devicemanagerv2/OpenDeviceExplorerButton;", "Lcom/android/tools/adtui/categorytable/IconButton;", "project", "Lcom/intellij/openapi/project/Project;", "handle", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "(Lcom/intellij/openapi/project/Project;Lcom/android/sdklib/deviceprovisioner/DeviceHandle;)V", "isVirtual", "", "updateState", "", "state", "Lcom/android/tools/idea/devicemanagerv2/DeviceRowData;", "intellij.android.device-manager-v2"})
public final class OpenDeviceExplorerButton
extends IconButton {
    @NotNull
    private final Project project;
    @NotNull
    private final DeviceHandle handle;
    private boolean isVirtual;

    public OpenDeviceExplorerButton(@NotNull Project project, @NotNull DeviceHandle handle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        super(AllIcons.Actions.MenuOpen);
        this.project = project;
        this.handle = handle;
        this.setToolTipText(DeviceManagerBundle.message("openDeviceExplorerButton.tooltip", new Object[0]));
        this.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(isVirtual ? DeviceManagerEvent.EventKind.VIRTUAL_DEVICE_FILE_EXPLORER_ACTION : DeviceManagerEvent.EventKind.PHYSICAL_DEVICE_FILE_EXPLORER_ACTION).build();
                Intrinsics.checkNotNullExpressionValue((Object)deviceManagerEvent, (String)"newBuilder()\n          .\u2026     )\n          .build()");
                DeviceManagerUsageTracker.INSTANCE.logEvent(deviceManagerEvent);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        String serialNumber;
                        ConnectedDevice connectedDevice = handle.getState().getConnectedDevice();
                        String string = serialNumber = connectedDevice != null ? ConnectedDeviceKt.getSerialNumber((ConnectedDevice)connectedDevice) : null;
                        if (!project.isDisposed() && serialNumber != null) {
                            Object t = StudioFlags.MERGED_DEVICE_FILE_EXPLORER_AND_DEVICE_MONITOR_TOOL_WINDOW_ENABLED.get();
                            Intrinsics.checkNotNullExpressionValue(t, (String)"MERGED_DEVICE_FILE_EXPLO\u2026TOOL_WINDOW_ENABLED.get()");
                            if (((Boolean)t).booleanValue()) {
                                DeviceExplorerService.openAndShowDevice(project, serialNumber);
                            } else {
                                DeviceExplorer.openAndShowDevice(project, serialNumber);
                            }
                        }
                    }
                });
            }
        });
    }

    public final void updateState(@NotNull DeviceRowData state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        DeviceHandle deviceHandle = state2.getHandle();
        this.setEnabled((deviceHandle != null ? deviceHandle.getState() : null) instanceof DeviceState.Connected);
        this.isVirtual = state2.isVirtual();
    }
}

