/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.prefs.AndroidLocationsException;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.devicemanager.virtualtab.EventListenerLists;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcherEvent;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcherListener;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeAvdManagers;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.event.EventListenerList;
import org.jetbrains.android.AndroidPluginDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Service
public final class VirtualDeviceWatcher
implements ApplicationActivationListener {
    @NotNull
    private final Supplier<Optional<AvdManager>> myGetAvdManager;
    @NotNull
    private final EventListenerList myListeners;
    @NotNull
    private final Alarm myAlarm;

    @UiThread
    private VirtualDeviceWatcher() {
        this(VirtualDeviceWatcher::getAvdManager);
    }

    @UiThread
    @VisibleForTesting
    VirtualDeviceWatcher(@NotNull Supplier<Optional<AvdManager>> getAvdManager) {
        this.myGetAvdManager = getAvdManager;
        this.myListeners = new EventListenerList();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)AndroidPluginDisposable.Companion.getApplicationInstance());
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)this);
    }

    @UiThread
    public void applicationActivated(@NotNull IdeFrame ideFrame) {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(this::snapshotAvds, Duration.ofSeconds(1L).toMillis());
    }

    @WorkerThread
    @NotNull
    private static Optional<AvdManager> getAvdManager() {
        try {
            return Optional.ofNullable(IdeAvdManagers.INSTANCE.getAvdManager(AndroidSdks.getInstance().tryToChooseSdkHandler()));
        }
        catch (AndroidLocationsException exception) {
            Logger.getInstance(VirtualDeviceWatcher.class).warn("Unable to get AvdManager for VirtualDeviceWatcher", (Throwable)exception);
            return Optional.empty();
        }
    }

    @UiThread
    @NotNull
    static VirtualDeviceWatcher getInstance() {
        return (VirtualDeviceWatcher)ApplicationManager.getApplication().getService(VirtualDeviceWatcher.class);
    }

    @UiThread
    void addVirtualDeviceWatcherListener(@NotNull VirtualDeviceWatcherListener listener2) {
        this.myListeners.add(VirtualDeviceWatcherListener.class, listener2);
    }

    @UiThread
    void removeVirtualDeviceWatcherListener(@NotNull VirtualDeviceWatcherListener listener2) {
        this.myListeners.remove(VirtualDeviceWatcherListener.class, listener2);
    }

    @WorkerThread
    private void snapshotAvds() {
        Application application = ApplicationManager.getApplication();
        if (!application.isActive()) {
            return;
        }
        this.myGetAvdManager.get().flatMap(VirtualDeviceWatcher::getAllAvds).ifPresent(avds -> this.fireVirtualDevicesChanged(application, (Iterable<AvdInfo>)avds));
    }

    @WorkerThread
    private void fireVirtualDevicesChanged(@NotNull Application application, @NotNull Iterable<AvdInfo> avds) {
        application.invokeLater(() -> this.fireVirtualDevicesChanged(avds));
    }

    @WorkerThread
    @NotNull
    private static Optional<Iterable<AvdInfo>> getAllAvds(@NotNull AvdManager manager) {
        try {
            manager.reloadAvds();
            return Optional.of(new ArrayList<AvdInfo>(Arrays.asList(manager.getAllAvds())));
        }
        catch (AndroidLocationsException exception) {
            Logger.getInstance(VirtualDeviceWatcher.class).warn("Unable to reload AvdManager", (Throwable)exception);
            return Optional.empty();
        }
    }

    @UiThread
    private void fireVirtualDevicesChanged(@NotNull Iterable<AvdInfo> avds) {
        EventListenerLists.fire(this.myListeners, VirtualDeviceWatcherListener::virtualDevicesChanged, VirtualDeviceWatcherListener.class, () -> new VirtualDeviceWatcherEvent(this, avds));
    }
}

