/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePath;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTable;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTableModel;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcherEvent;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcherListener;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class VirtualDeviceTableWatcherListener
implements VirtualDeviceWatcherListener {
    @NotNull
    private final VirtualDeviceTable myTable;

    VirtualDeviceTableWatcherListener(@NotNull VirtualDeviceTable table2) {
        this.myTable = table2;
    }

    @Override
    public void virtualDevicesChanged(@NotNull VirtualDeviceWatcherEvent event2) {
        VirtualDeviceTableModel model2 = this.myTable.getModel();
        Map<Key, VirtualDevice> keyToOldDeviceMap = model2.getDevices().stream().collect(Collectors.toMap(Device::getKey, device2 -> device2));
        for (AvdInfo newAvd : event2.getAvds()) {
            VirtualDevicePath newKey = new VirtualDevicePath(newAvd.getId());
            VirtualDevice oldDevice = keyToOldDeviceMap.remove(newKey);
            if (oldDevice == null) {
                this.myTable.addDevice(newKey);
                continue;
            }
            if (oldDevice.getAvdInfo().equals((Object)newAvd)) continue;
            this.myTable.reloadDevice(newKey);
        }
        keyToOldDeviceMap.keySet().forEach(model2::remove);
    }
}

