/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.devicemanager.DetailsPanel;
import com.android.tools.idea.devicemanager.DevicePanel;
import com.android.tools.idea.devicemanager.virtualtab.BuildVirtualDeviceConfigurationWizardActionListener;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceDetailsPanel;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTable;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTableWatcherListener;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcher;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualDevicePanel
extends DevicePanel {
    @Nullable
    private final Project myProject;
    @Nullable
    private VirtualDeviceTableWatcherListener myWatcherListener;
    @NotNull
    private final VirtualDeviceWatcher myWatcher;
    @NotNull
    private final JButton myCreateButton;
    @NotNull
    private final JSeparator mySeparator;
    @Nullable
    private AbstractButton myReloadButton;
    @NotNull
    private final JButton myHelpButton;

    public VirtualDevicePanel(@Nullable Project project, @NotNull Disposable parent2) {
        this(project, parent2, VirtualDeviceWatcher.getInstance());
    }

    @VisibleForTesting
    public VirtualDevicePanel(@Nullable Project project, @NotNull Disposable parent2, @NotNull VirtualDeviceWatcher watcher) {
        super(project);
        this.myProject = project;
        this.myWatcher = watcher;
        this.initReloadButton();
        this.initTable();
        this.initScrollPane();
        this.myCreateButton = new JButton("Create Device");
        this.myCreateButton.addActionListener(new BuildVirtualDeviceConfigurationWizardActionListener(this.myCreateButton, project, (VirtualDeviceTable)((Object)this.myTable)));
        JBDimension separatorSize = new JBDimension(3, 20);
        this.mySeparator = new JSeparator(1);
        this.mySeparator.setPreferredSize((Dimension)separatorSize);
        this.mySeparator.setMaximumSize((Dimension)separatorSize);
        this.myHelpButton = new CommonButton(AllIcons.Actions.Help);
        this.myHelpButton.addActionListener(event2 -> BrowserUtil.browse((String)"https://d.android.com/r/studio-ui/device-manager/virtual"));
        this.initDetailsPanelPanel();
        this.layOut();
        if (((Boolean)StudioFlags.VIRTUAL_DEVICE_WATCHER_ENABLED.get()).booleanValue()) {
            this.myWatcherListener = new VirtualDeviceTableWatcherListener(this.getTable());
            this.myWatcher.addVirtualDeviceWatcherListener(this.myWatcherListener);
        }
        Disposer.register((Disposable)parent2, (Disposable)this);
    }

    private void initReloadButton() {
        this.myReloadButton = new CommonButton(AllIcons.Actions.Refresh);
        this.myReloadButton.addActionListener(event2 -> this.getTable().refreshAvds());
    }

    @Override
    @NotNull
    protected JTable newTable() {
        VirtualDeviceTable table2 = new VirtualDeviceTable(this);
        Disposer.register((Disposable)this, (Disposable)table2);
        return table2;
    }

    @Override
    @NotNull
    protected DetailsPanel newDetailsPanel() {
        Optional<DetailsPanel> panel2 = this.getTable().getSelectedDevice().map(device2 -> new VirtualDeviceDetailsPanel((VirtualDevice)device2, this.myProject));
        return panel2.orElseGet(() -> super.newDetailsPanel());
    }

    @NotNull
    VirtualDeviceTable getTable() {
        return (VirtualDeviceTable)((Object)this.myTable);
    }

    private void layOut() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(JBUIScale.scale((int)5)).addComponent(this.myCreateButton).addGap(JBUIScale.scale((int)4)).addComponent(this.mySeparator).addComponent(this.myReloadButton).addComponent(this.myHelpButton)).addComponent((Component)((Object)this.myDetailsPanelPanel));
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myCreateButton).addComponent(this.mySeparator).addComponent(this.myReloadButton).addComponent(this.myHelpButton)).addComponent((Component)((Object)this.myDetailsPanelPanel));
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.setLayout(layout);
    }

    @Override
    public void dispose() {
        if (this.myWatcherListener != null) {
            this.myWatcher.removeVirtualDeviceWatcherListener(this.myWatcherListener);
        }
    }
}

