/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.devicemanager.DetailsPanel;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.InfoSection;
import com.android.tools.idea.devicemanager.PairedDevicesPanel;
import com.android.tools.idea.devicemanager.ScreenDiagram;
import com.android.tools.idea.devicemanager.virtualtab.AsyncVirtualDeviceDetailsBuilder;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.EdtExecutorService;
import java.text.Collator;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDeviceDetailsPanel
extends DetailsPanel {
    @NotNull
    private final VirtualDevice myDevice;
    @NotNull
    private final ListenableFuture<Device> myFuture;
    @NotNull
    private final Function<SummarySection, FutureCallback<Device>> myNewSummarySectionCallback;
    @Nullable
    private InfoSection myPropertiesSection;

    VirtualDeviceDetailsPanel(@NotNull VirtualDevice device2, @Nullable Project project) {
        this(device2, new AsyncVirtualDeviceDetailsBuilder(project, device2), VirtualDeviceDetailsPanel::newSummarySectionCallback, WearPairingManager.getInstance());
    }

    @VisibleForTesting
    VirtualDeviceDetailsPanel(@NotNull VirtualDevice device2, @NotNull AsyncVirtualDeviceDetailsBuilder builder2, @NotNull Function<SummarySection, FutureCallback<Device>> newSummarySectionCallback, @NotNull WearPairingManager manager) {
        super(device2.getName());
        this.myDevice = device2;
        this.myFuture = builder2.buildAsync();
        this.myNewSummarySectionCallback = newSummarySectionCallback;
        this.initScreenDiagram();
        this.initPropertiesSection();
        InfoSection.newPairedDeviceSection(device2, manager).ifPresent(this.myInfoSections::add);
        if (this.myPropertiesSection != null) {
            this.myInfoSections.add(this.myPropertiesSection);
        }
        if (((Boolean)StudioFlags.PAIRED_DEVICES_TAB_ENABLED.get()).booleanValue() && device2.isPairable()) {
            this.myPairedDevicesPanel = new PairedDevicesPanel(device2.getKey(), this, builder2.getProject());
        }
        this.init();
    }

    @VisibleForTesting
    @NotNull
    static FutureCallback<Device> newSummarySectionCallback(@NotNull SummarySection section) {
        return new DeviceManagerFutureCallback<Device>(VirtualDeviceDetailsPanel.class, device2 -> {
            InfoSection.setText(section.myResolutionLabel, device2.getResolution());
            InfoSection.setText(section.myDpLabel, device2.getDp());
            InfoSection.setText(section.myAbiListLabel, device2.getAbis());
            InfoSection.setText(section.myAvailableStorageLabel, device2.getStorageDevice());
        });
    }

    @Override
    protected void initSummarySection() {
        SummarySection summarySection = new SummarySection();
        InfoSection.setText(summarySection.myApiLevelLabel, this.myDevice.getAndroidVersion().getApiStringWithExtension());
        AvdInfo device2 = this.myDevice.getAvdInfo();
        if (!device2.getStatus().equals((Object)AvdInfo.AvdStatus.OK)) {
            summarySection.myErrorLabel = summarySection.addNameAndValueLabels("Error");
            InfoSection.setText(summarySection.myErrorLabel, device2.getErrorMessage());
        } else {
            String snapshot = device2.getProperty("snapshot.present");
            if (snapshot != null) {
                summarySection.mySnapshotLabel = summarySection.addNameAndValueLabels("Snapshot");
                InfoSection.setText(summarySection.mySnapshotLabel, snapshot);
            }
        }
        summarySection.setLayout();
        Futures.addCallback(this.myFuture, this.myNewSummarySectionCallback.apply(summarySection), (Executor)EdtExecutorService.getInstance());
        this.mySummarySection = summarySection;
    }

    private void initScreenDiagram() {
        DeviceManagerFutureCallback<Device> callback2 = new DeviceManagerFutureCallback<Device>(VirtualDeviceDetailsPanel.class, device2 -> {
            if (device2.getDp() != null) {
                this.myScreenDiagram = new ScreenDiagram((Device)device2);
                this.setInfoSectionPanelLayout();
            }
        });
        Futures.addCallback(this.myFuture, callback2, (Executor)EdtExecutorService.getInstance());
    }

    private void initPropertiesSection() {
        AvdInfo device2 = this.myDevice.getAvdInfo();
        if (!device2.getStatus().equals((Object)AvdInfo.AvdStatus.OK)) {
            return;
        }
        TreeMap<Object, String> properties2 = new TreeMap<Object, String>(Collator.getInstance());
        properties2.putAll(device2.getProperties());
        properties2.remove("abi.type");
        properties2.remove("hw.cpu.arch");
        properties2.remove("skin.name");
        properties2.remove("skin.path");
        properties2.remove("sdcard.size");
        properties2.remove("sdcard.path");
        properties2.remove("image.sysdir.2");
        if (properties2.isEmpty()) {
            return;
        }
        this.myPropertiesSection = new InfoSection("Properties");
        properties2.forEach((name2, value2) -> InfoSection.setText(this.myPropertiesSection.addNameAndValueLabels((String)name2), value2));
        this.myPropertiesSection.setLayout();
    }

    @NotNull
    @VisibleForTesting
    SummarySection getSummarySection() {
        assert (this.mySummarySection != null);
        return (SummarySection)((Object)this.mySummarySection);
    }

    @NotNull
    @VisibleForTesting
    InfoSection getPropertiesSection() {
        assert (this.myPropertiesSection != null);
        return this.myPropertiesSection;
    }

    @VisibleForTesting
    static final class SummarySection
    extends InfoSection {
        @VisibleForTesting
        @NotNull
        final JLabel myApiLevelLabel = this.addNameAndValueLabels("API level");
        @VisibleForTesting
        @NotNull
        final JLabel myResolutionLabel = this.addNameAndValueLabels("Resolution");
        @VisibleForTesting
        @NotNull
        final JLabel myDpLabel = this.addNameAndValueLabels("dp");
        @VisibleForTesting
        @NotNull
        final JLabel myAbiListLabel = this.addNameAndValueLabels("ABI list");
        @VisibleForTesting
        @NotNull
        final JLabel myAvailableStorageLabel = this.addNameAndValueLabels("Available storage");
        @VisibleForTesting
        @Nullable
        JLabel myErrorLabel;
        @VisibleForTesting
        @Nullable
        JLabel mySnapshotLabel;

        private SummarySection() {
            super("Summary");
        }
    }
}

