/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.devicemanager.DeviceManagerFutures;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class VirtualDeviceAsyncSupplier {
    @NotNull
    private final Supplier<List<AvdInfo>> myGetAvds;

    @UiThread
    VirtualDeviceAsyncSupplier() {
        this(() -> AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(true));
    }

    @VisibleForTesting
    VirtualDeviceAsyncSupplier(@NotNull Supplier<List<AvdInfo>> getAvds) {
        this.myGetAvds = getAvds;
    }

    @UiThread
    @NotNull
    ListenableFuture<List<VirtualDevice>> getAll() {
        return DeviceManagerFutures.appExecutorServiceSubmit(this::buildAll);
    }

    @WorkerThread
    @NotNull
    private List<VirtualDevice> buildAll() {
        return this.myGetAvds.get().stream().map(VirtualDeviceBuilder::new).map(VirtualDeviceBuilder::build).collect(Collectors.toList());
    }

    @UiThread
    @NotNull
    ListenableFuture<VirtualDevice> get(@NotNull Key key) {
        return DeviceManagerFutures.appExecutorServiceSubmit(() -> this.build(key));
    }

    @WorkerThread
    @NotNull
    private VirtualDevice build(@NotNull Key key) {
        Optional<VirtualDevice> device2 = this.myGetAvds.get().stream().filter(avd -> avd.getId().equals(key.toString())).map(VirtualDeviceBuilder::new).map(VirtualDeviceBuilder::build).findFirst();
        return device2.orElseThrow(() -> new NoSuchElementException(key.toString()));
    }
}

