/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DeviceManagerFutures;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.virtualtab.EventListenerLists;
import com.android.tools.idea.devicemanager.virtualtab.ProcessManagerEvent;
import com.android.tools.idea.devicemanager.virtualtab.ProcessManagerListener;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;

final class ProcessManager
implements AndroidDebugBridge.IDeviceChangeListener {
    private Map<Key, State> myKeyToStateMap;
    @NotNull
    private final EventListenerList myListeners = new EventListenerList();
    @NotNull
    private final NewSetKeyToStateMapFutureCallback myNewSetKeyToStateMapFutureCallback;
    @NotNull
    private final Callable<AvdManagerConnection> myGetDefaultAvdManagerConnection;

    @UiThread
    ProcessManager() {
        this(ProcessManager::newSetKeyToStateMapFutureCallback, AvdManagerConnection::getDefaultAvdManagerConnection);
    }

    @UiThread
    @VisibleForTesting
    ProcessManager(@NotNull NewSetKeyToStateMapFutureCallback newSetKeyToStateMapFutureCallback, @NotNull Callable<AvdManagerConnection> getDefaultAvdManagerConnection) {
        this.myNewSetKeyToStateMapFutureCallback = newSetKeyToStateMapFutureCallback;
        this.myGetDefaultAvdManagerConnection = getDefaultAvdManagerConnection;
    }

    @UiThread
    void addProcessManagerListener(@NotNull ProcessManagerListener listener2) {
        this.myListeners.add(ProcessManagerListener.class, listener2);
    }

    @AnyThread
    void init() {
        FluentFuture.from(DeviceManagerFutures.appExecutorServiceSubmit(this.myGetDefaultAvdManagerConnection)).transform(ProcessManager::collectKeyToStateMap, (Executor)AppExecutorUtil.getAppExecutorService()).addCallback(this.myNewSetKeyToStateMapFutureCallback.apply(this), (Executor)EdtExecutorService.getInstance());
    }

    @WorkerThread
    @NotNull
    private static Map<Key, State> collectKeyToStateMap(@NotNull AvdManagerConnection connection2) {
        return connection2.getAvds(true).stream().collect(Collectors.toMap(avd -> new VirtualDevicePath(avd.getId()), avd -> State.valueOf(connection2.isAvdRunning((AvdInfo)avd))));
    }

    @UiThread
    @VisibleForTesting
    @NotNull
    static FutureCallback<Map<Key, State>> newSetKeyToStateMapFutureCallback(@NotNull ProcessManager manager) {
        return new DeviceManagerFutureCallback<Map<Key, State>>(ProcessManager.class, manager::setKeyToStateMap);
    }

    @UiThread
    private void setKeyToStateMap(@NotNull Map<Key, State> keyToStateMap) {
        this.myKeyToStateMap = keyToStateMap;
        EventListenerLists.fire(this.myListeners, ProcessManagerListener::allStatesChanged, ProcessManagerListener.class, () -> new ProcessManagerEvent(this));
    }

    @WorkerThread
    public void deviceChanged(@NotNull IDevice device2, int mask) {
        if (!device2.isEmulator()) {
            return;
        }
        if ((mask & 1) == 0) {
            return;
        }
        IDevice.DeviceState state2 = device2.getState();
        if (state2 == null) {
            return;
        }
        switch (state2) {
            case OFFLINE: 
            case ONLINE: {
                this.init();
                break;
            }
        }
    }

    @VisibleForTesting
    @NotNull
    Object getKeyToStateMap() {
        return this.myKeyToStateMap;
    }

    public void deviceConnected(@NotNull IDevice device2) {
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
    }

    @VisibleForTesting
    static interface NewSetKeyToStateMapFutureCallback {
        @NotNull
        public FutureCallback<Map<Key, State>> apply(@NotNull ProcessManager var1);
    }

    static enum State {
        STOPPED,
        LAUNCHED;


        @WorkerThread
        @NotNull
        private static State valueOf(boolean online) {
            if (online) {
                return LAUNCHED;
            }
            return STOPPED;
        }
    }
}

