/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.idea.devicemanager.ConnectionType;
import com.android.tools.idea.devicemanager.Tables;
import com.android.tools.idea.devicemanager.physicaltab.IconLabel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBPanel;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Container;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

final class TypeTableCellRenderer
implements TableCellRenderer {
    private final UsbAndWiFiPanel myPanel = new UsbAndWiFiPanel();
    private final IconLabel myLabel = new IconLabel();

    TypeTableCellRenderer() {
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
        if (value2.equals(ConnectionType.USB_AND_WI_FI_SET)) {
            return this.myPanel.getTableCellComponent(table2, selected, focused);
        }
        if (value2.equals(Collections.EMPTY_SET)) {
            this.myLabel.setDefaultIcon(null);
        } else if (value2.equals(ConnectionType.UNKNOWN_SET)) {
            this.myLabel.setDefaultIcon(StudioIcons.Avd.CONNECTION_GENERIC);
        } else if (value2.equals(ConnectionType.USB_SET)) {
            this.myLabel.setDefaultIcon(StudioIcons.Avd.CONNECTION_USB);
        } else if (value2.equals(ConnectionType.WI_FI_SET)) {
            this.myLabel.setDefaultIcon(StudioIcons.Avd.CONNECTION_WIFI);
        } else assert (false) : value2;
        return this.myLabel.getTableCellComponent(table2, selected, focused);
    }

    @VisibleForTesting
    @NotNull
    Object getPanel() {
        return this.myPanel;
    }

    @VisibleForTesting
    @NotNull
    JLabel getLabel() {
        return this.myLabel;
    }

    private static final class UsbAndWiFiPanel
    extends JBPanel<UsbAndWiFiPanel> {
        private UsbAndWiFiPanel() {
            super(null);
            IconLabel usbLabel = new IconLabel(StudioIcons.Avd.CONNECTION_USB);
            IconLabel wiFiLabel = new IconLabel(StudioIcons.Avd.CONNECTION_WIFI);
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup().addComponent((Component)((Object)usbLabel)).addComponent((Component)((Object)wiFiLabel));
            GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addContainerGap(0, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent((Component)((Object)usbLabel)).addComponent((Component)((Object)wiFiLabel))).addContainerGap(0, Short.MAX_VALUE);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(horizontalGroup);
            layout.setVerticalGroup(verticalGroup);
            this.setLayout(layout);
        }

        @NotNull
        private Component getTableCellComponent(@NotNull JTable table2, boolean selected, boolean focused) {
            this.setBackground(Tables.getBackground(table2, selected));
            this.setBorder(Tables.getBorder(selected, focused));
            return this;
        }
    }
}

