/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.IconButtonTableCellEditor;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevicePanel;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTable;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import java.awt.Component;
import java.util.function.BiPredicate;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

final class RemoveButtonTableCellEditor
extends IconButtonTableCellEditor {
    private Device myDevice;

    RemoveButtonTableCellEditor(@NotNull PhysicalDevicePanel panel2) {
        this(panel2, RemoveButtonTableCellEditor::askToRemove);
    }

    @VisibleForTesting
    RemoveButtonTableCellEditor(@NotNull PhysicalDevicePanel panel2, @NotNull BiPredicate<Object, Project> askToRemove) {
        super(PhysicalDeviceTableModel.RemoveValue.INSTANCE, AllIcons.Actions.GC, "Remove this offline device from the list.");
        this.myButton.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.PHYSICAL_DELETE_ACTION).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            Project project = panel2.getProject();
            assert (project != null);
            if (!askToRemove.test(this.myDevice, project)) {
                this.fireEditingCanceled();
                return;
            }
            this.fireEditingStopped();
            panel2.getTable().getModel().remove(this.myDevice.getKey());
        });
    }

    private static boolean askToRemove(@NotNull Object device2, @NotNull Project project) {
        return ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)("Remove " + device2 + " Device"), (String)(device2 + " will be removed from the device manager.")).yesText("Remove")).ask(project);
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, int viewRowIndex, int viewColumnIndex) {
        super.getTableCellEditorComponent(table2, value2, selected, viewRowIndex, viewColumnIndex);
        this.myDevice = ((PhysicalDeviceTable)((Object)table2)).getDeviceAt(viewRowIndex);
        return this.myButton;
    }
}

