/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowButtonTableCellEditor;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowValue;
import com.android.tools.idea.devicemanager.ApiTableCellRenderer;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceIconButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.DeviceTable;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.IconButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.MergedTableColumn;
import com.android.tools.idea.devicemanager.PopUpMenuValue;
import com.android.tools.idea.devicemanager.Tables;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevicePanel;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevicePopUpMenuButtonTableCellEditor;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTableCellRenderer;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTableModel;
import com.android.tools.idea.devicemanager.physicaltab.RemoveButtonTableCellEditor;
import com.android.tools.idea.devicemanager.physicaltab.RemoveButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.physicaltab.TypeTableCellRenderer;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;

public final class PhysicalDeviceTable
extends DeviceTable<PhysicalDevice> {
    PhysicalDeviceTable(@NotNull PhysicalDevicePanel panel2, @NotNull WearPairingManager manager) {
        this(panel2, manager, new PhysicalDeviceTableModel());
    }

    @VisibleForTesting
    PhysicalDeviceTable(@NotNull PhysicalDevicePanel panel2, @NotNull WearPairingManager manager, @NotNull PhysicalDeviceTableModel model2) {
        super(model2, PhysicalDevice.class);
        Project project = panel2.getProject();
        assert (project != null);
        this.setDefaultEditor(ActivateDeviceFileExplorerWindowValue.class, new ActivateDeviceFileExplorerWindowButtonTableCellEditor<PhysicalDevice>(project, this, DeviceManagerEvent.EventKind.PHYSICAL_DEVICE_FILE_EXPLORER_ACTION));
        this.setDefaultEditor(PhysicalDeviceTableModel.RemoveValue.class, new RemoveButtonTableCellEditor(panel2));
        this.setDefaultEditor(PopUpMenuValue.class, new PhysicalDevicePopUpMenuButtonTableCellEditor(panel2, manager));
        this.setDefaultRenderer(DeviceType.class, new DeviceIconButtonTableCellRenderer<PhysicalDevice>(this));
        this.setDefaultRenderer(Device.class, new PhysicalDeviceTableCellRenderer(manager));
        this.setDefaultRenderer(AndroidVersion.class, new ApiTableCellRenderer());
        this.setDefaultRenderer(Collection.class, new TypeTableCellRenderer());
        this.setDefaultRenderer(ActivateDeviceFileExplorerWindowValue.class, new ActivateDeviceFileExplorerWindowButtonTableCellRenderer<PhysicalDevice>(project, this));
        this.setDefaultRenderer(PhysicalDeviceTableModel.RemoveValue.class, new RemoveButtonTableCellRenderer());
        this.setDefaultRenderer(PopUpMenuValue.class, new IconButtonTableCellRenderer(AllIcons.Actions.More, "More Actions"));
        this.setRowSorter(PhysicalDeviceTable.newRowSorter(model2));
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.getEmptyText().setText("No physical devices added. Connect a device via USB cable.");
    }

    @NotNull
    private static RowSorter<TableModel> newRowSorter(@NotNull TableModel model2) {
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(model2);
        sorter.setComparator(1, Comparator.comparing(Device::getName, Collator.getInstance()));
        sorter.setComparator(2, Comparator.naturalOrder().reversed());
        sorter.setSortable(3, false);
        sorter.setSortable(4, false);
        sorter.setSortable(5, false);
        sorter.setSortable(6, false);
        sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(1, SortOrder.ASCENDING)));
        return sorter;
    }

    @NotNull
    Optional<PhysicalDevice> getSelectedDevice() {
        int viewRowIndex = this.getSelectedRow();
        if (viewRowIndex == -1) {
            return Optional.empty();
        }
        return Optional.of((PhysicalDevice)this.getDeviceAt(viewRowIndex));
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        DefaultTableColumnModel model2 = new DefaultTableColumnModel();
        model2.addColumn(this.columnModel.getColumn(this.deviceIconViewColumnIndex()));
        model2.addColumn(this.columnModel.getColumn(this.deviceViewColumnIndex()));
        model2.addColumn(this.columnModel.getColumn(this.apiViewColumnIndex()));
        model2.addColumn(this.columnModel.getColumn(this.typeViewColumnIndex()));
        List<TableColumn> columns2 = Arrays.asList(this.columnModel.getColumn(this.activateDeviceFileExplorerWindowViewColumnIndex()), this.columnModel.getColumn(this.removeViewColumnIndex()), this.columnModel.getColumn(this.popUpMenuViewColumnIndex()));
        MergedTableColumn column2 = new MergedTableColumn(columns2);
        column2.setHeaderValue("Actions");
        model2.addColumn(column2);
        JTableHeader header = super.createDefaultTableHeader();
        header.setColumnModel(model2);
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        return header;
    }

    public void doLayout() {
        Tables.setWidths(this.columnModel.getColumn(this.deviceIconViewColumnIndex()), DeviceIconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), DeviceType.class));
        this.columnModel.getColumn(this.deviceViewColumnIndex()).setMinWidth(JBUIScale.scale((int)200));
        Tables.setWidths(this.columnModel.getColumn(this.apiViewColumnIndex()), Tables.getPreferredColumnWidth((JTable)((Object)this), this.apiViewColumnIndex(), JBUIScale.scale((int)65)), JBUIScale.scale((int)20));
        Tables.setWidths(this.columnModel.getColumn(this.typeViewColumnIndex()), Tables.getPreferredColumnWidth((JTable)((Object)this), this.typeViewColumnIndex(), JBUIScale.scale((int)65)), JBUIScale.scale((int)20));
        Tables.setWidths(this.columnModel.getColumn(this.activateDeviceFileExplorerWindowViewColumnIndex()), IconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), ActivateDeviceFileExplorerWindowValue.class));
        Tables.setWidths(this.columnModel.getColumn(this.removeViewColumnIndex()), IconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), PhysicalDeviceTableModel.RemoveValue.class));
        Tables.setWidths(this.columnModel.getColumn(this.popUpMenuViewColumnIndex()), IconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), PopUpMenuValue.class));
        super.doLayout();
    }

    private int deviceIconViewColumnIndex() {
        return this.convertColumnIndexToView(0);
    }

    @Override
    protected int deviceViewColumnIndex() {
        return this.convertColumnIndexToView(1);
    }

    private int apiViewColumnIndex() {
        return this.convertColumnIndexToView(2);
    }

    private int typeViewColumnIndex() {
        return this.convertColumnIndexToView(3);
    }

    private int activateDeviceFileExplorerWindowViewColumnIndex() {
        return this.convertColumnIndexToView(4);
    }

    private int removeViewColumnIndex() {
        return this.convertColumnIndexToView(5);
    }

    private int popUpMenuViewColumnIndex() {
        return this.convertColumnIndexToView(6);
    }

    @NotNull
    public PhysicalDeviceTableModel getModel() {
        return (PhysicalDeviceTableModel)this.dataModel;
    }
}

