/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.MenuItems;
import com.android.tools.idea.devicemanager.PopUpMenuButtonTableCellEditor;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevicePanel;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTable;
import com.android.tools.idea.wearpairing.AndroidWearPairingBundle;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

final class PhysicalDevicePopUpMenuButtonTableCellEditor
extends PopUpMenuButtonTableCellEditor {
    PhysicalDevicePopUpMenuButtonTableCellEditor(@NotNull PhysicalDevicePanel panel2, @NotNull WearPairingManager manager) {
        super(panel2, manager);
    }

    @Override
    @NotNull
    public List<JComponent> newItems() {
        ArrayList<JComponent> items2 = new ArrayList<JComponent>();
        Optional<JComponent> optionalItem = this.newViewPairedDevicesItem(DeviceManagerEvent.EventKind.PHYSICAL_UNPAIR_DEVICE_ACTION);
        items2.add(MenuItems.newViewDetailsItem(this.myPanel));
        optionalItem.ifPresent(item2 -> items2.add(new JPopupMenu.Separator()));
        items2.add(this.newPairWearableItem());
        optionalItem.ifPresent(items2::add);
        return items2;
    }

    @NotNull
    private JComponent newPairWearableItem() {
        JComponent item2 = this.newPairWearableItem(DeviceManagerEvent.EventKind.PHYSICAL_PAIR_DEVICE_ACTION);
        boolean phone = this.myDevice.getType().equals((Object)DeviceType.PHONE);
        boolean online = this.myDevice.isOnline();
        item2.setEnabled(phone && online);
        if (phone && online) {
            item2.setToolTipText(AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.ok", new Object[0]));
        } else if (phone) {
            item2.setToolTipText(AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.offline", new Object[0]));
        } else {
            item2.setToolTipText(AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.unsupported", new Object[0]));
        }
        return item2;
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, int viewRowIndex, int viewColumnIndex) {
        super.getTableCellEditorComponent(table2, value2, selected, viewRowIndex, viewColumnIndex);
        this.myDevice = ((PhysicalDeviceTable)((Object)table2)).getDeviceAt(viewRowIndex);
        return this.myButton;
    }
}

